/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import rero.gui.toolkit.GeneralListModel;
import rero.gui.windows.GeneralListDialog;
import rero.script.ScriptCore;
import rero.util.ClientUtils;
import sleep.runtime.Scalar;
import text.AttributedString;
import text.TextSource;

public class ScriptedListDialog
extends GeneralListDialog {
    public ScriptedListDialog(String string, String string2, Object object, LinkedList linkedList) {
        super(string, string2, new ScriptedListModel(linkedList, object));
    }

    public void refreshData() {
        this.model.fireTableDataChanged();
    }

    public void init() {
        ((ScriptedListModel)this.model).install(this.popupHook, this.capabilities.getScriptCore());
    }

    private static class ScriptedListModel
    extends GeneralListModel {
        private Scalar data;
        private LinkedList cols;
        private ScriptCore script;
        private String popupHook;

        public void install(String string, ScriptCore scriptCore) {
            this.script = scriptCore;
            this.popupHook = string;
        }

        public ScriptedListModel(LinkedList linkedList, Object object) {
            this.cols = linkedList;
            this.data = (Scalar)object;
        }

        public void sortColumn(int n, boolean bl) {
            this.data.getArray().sort(new ScriptedCompare(n, bl));
            this.fireTableDataChanged();
        }

        public HashMap getEventHashMap(int n) {
            return ClientUtils.getEventHashMap(n + "", "");
        }

        public int getRowCount() {
            return this.data.getArray().size();
        }

        public int getColumnCount() {
            return this.cols.size();
        }

        public int getColumnWidth(int n) {
            return (int)((double)TextSource.fontMetrics.stringWidth(this.cols.get(n).toString()) * 1.5);
        }

        public String getColumnName(int n) {
            return this.cols.get(n).toString();
        }

        public Object getValueAt(int n, int n2) {
            String string;
            String[] stringArray;
            if (n < this.getRowCount() && n2 < this.getColumnCount() && n2 < (stringArray = (string = this.data.getArray().getAt(n).toString()).split("\t")).length) {
                AttributedString attributedString = AttributedString.CreateAttributedString(stringArray[n2]);
                attributedString.assignWidths();
                return attributedString;
            }
            return null;
        }

        public boolean isSortable(int n) {
            return true;
        }
    }

    public static class ScriptedCompare
    implements Comparator {
        private int col;
        private boolean rev;

        public ScriptedCompare(int n, boolean bl) {
            this.rev = bl;
            this.col = n;
        }

        public int compare(Object object, Object stringArray) {
            String[] stringArray2;
            if (this.rev) {
                stringArray2 = stringArray;
                stringArray = object;
                object = stringArray2;
            }
            stringArray2 = object.toString().toLowerCase().split("\t");
            String[] stringArray3 = stringArray.toString().toLowerCase().split("\t");
            try {
                int n = Integer.parseInt(stringArray2[this.col]);
                int n2 = Integer.parseInt(stringArray3[this.col]);
                return n - n2;
            }
            catch (Exception exception) {
                return stringArray2[this.col].compareTo(stringArray3[this.col]);
            }
        }
    }
}

