/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.config.ClientStateListener;

public class SwitchBarOptions
implements ClientStateListener {
    protected JComponent container;
    protected JComponent switchbar;
    protected JComponent panel;
    protected static ColorListener color = null;

    public SwitchBarOptions(JComponent jComponent, JComponent jComponent2) {
        this.container = jComponent;
        this.switchbar = jComponent2;
        ClientState.getClientState().addClientStateListener("switchbar.position", this);
        ClientState.getClientState().addClientStateListener("switchbar.enabled", this);
        this.rehash();
        if (color == null) {
            color = new ColorListener();
        }
    }

    public static Color getHighlightColor() {
        return color.getColor();
    }

    public static boolean isHilightOn() {
        return color.isHilightOn();
    }

    public void rehash() {
        this.container.remove(this.switchbar);
        boolean bl = ClientState.getClientState().isOption("switchbar.enabled", true);
        int n = ClientState.getClientState().getInteger("switchbar.position", 0);
        if (bl) {
            switch (n) {
                case 0: {
                    this.container.add((Component)this.switchbar, "North");
                    break;
                }
                case 1: {
                    this.container.add((Component)this.switchbar, "South");
                    break;
                }
                case 2: {
                    this.container.add((Component)this.switchbar, "West");
                    break;
                }
                case 3: {
                    this.container.add((Component)this.switchbar, "East");
                }
            }
        }
    }

    public void propertyChanged(String string, String string2) {
        this.rehash();
        this.container.revalidate();
    }

    private static class ColorListener
    implements ClientStateListener {
        protected Color theColor;
        protected boolean hilight;

        public ColorListener() {
            ClientState.getClientState().addClientStateListener("switchbar.color", this);
            ClientState.getClientState().addClientStateListener("switchbar.hilight", this);
            this.propertyChanged(null, null);
        }

        public void propertyChanged(String string, String string2) {
            this.theColor = ClientState.getClientState().getColor("switchbar.color", ClientDefaults.switchbar_color);
            this.hilight = ClientState.getClientState().isOption("switchbar.hilight", true);
        }

        public boolean isHilightOn() {
            return this.hilight;
        }

        public Color getColor() {
            return this.theColor;
        }
    }
}

