/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.windows.StatusWindow;
import rero.gui.windows.SwitchBarOptions;

public abstract class WindowManager
extends JPanel
implements ClientStateListener,
ActionListener {
    protected SwitchBarOptions switchOptions;
    protected JToolBar switchbar;
    protected LinkedList windows;
    protected HashMap windowMap;
    protected boolean isRelative;

    public StatusWindow getWindowFor(Object object) {
        return (StatusWindow)this.windowMap.get(object);
    }

    public void addToSwitchbar(StatusWindow statusWindow) {
        if (ClientState.getClientState().isOption("switchbar.sort", false)) {
            Iterator iterator = this.windows.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                StatusWindow statusWindow2 = (StatusWindow)iterator.next();
                if (statusWindow.compareTo(statusWindow2) < 0) {
                    this.switchbar.add((Component)statusWindow.getButton(), n);
                    this.windows.add(n, statusWindow);
                    this.switchbar.revalidate();
                    return;
                }
                ++n;
            }
        }
        this.windows.add(statusWindow);
        this.switchbar.add(statusWindow.getButton());
        this.switchbar.revalidate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
        if (jToggleButton.isSelected()) {
            this.doActivate(this.getWindowFor(actionEvent.getSource()));
        } else {
            this.doDeactivate(this.getWindowFor(actionEvent.getSource()));
            int n = this.windows.indexOf(this.getWindowFor(actionEvent.getSource()));
            this.newActive(n, false);
        }
    }

    public void newActive(int n, boolean bl) {
        StatusWindow statusWindow;
        int n2;
        for (n2 = n - 1; n2 >= 0; --n2) {
            statusWindow = (StatusWindow)this.windows.get(n2);
            if (statusWindow == null || statusWindow.getWindow().isIcon()) continue;
            this.doActivate(statusWindow);
            return;
        }
        if (bl) {
            n = -1;
        }
        for (n2 = this.windows.size() - 1; n2 > n; --n2) {
            statusWindow = (StatusWindow)this.windows.get(n2);
            if (statusWindow == null || statusWindow.getWindow().isIcon()) continue;
            this.doActivate(statusWindow);
            return;
        }
    }

    public void propertyChanged(String string, String string2) {
        this.isRelative = ClientState.getClientState().isOption("window.relative", false);
        if (ClientState.getClientState().isOption("switchbar.sort", false)) {
            this.switchbar.removeAll();
            Collections.sort(this.windows);
            Iterator iterator = this.windows.iterator();
            while (iterator.hasNext()) {
                StatusWindow statusWindow = (StatusWindow)iterator.next();
                this.switchbar.add(statusWindow.getButton());
            }
            this.switchbar.revalidate();
        }
    }

    public WindowManager() {
        this.init();
        ClientState.getClientState().addClientStateListener("switchbar.sort", this);
        ClientState.getClientState().addClientStateListener("window", this);
        this.isRelative = ClientState.getClientState().isOption("window.relative", false);
    }

    public LinkedList getAllWindows() {
        return this.windows;
    }

    public abstract void init();

    public abstract void addWindow(StatusWindow var1, boolean var2);

    public abstract StatusWindow getActiveWindow();

    protected abstract void doActivate(StatusWindow var1);

    protected abstract void doDeactivate(StatusWindow var1);
}

