/*
 * Decompiled with CFR 0.152.
 */
package rero.script;

import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import rero.util.StringParser;
import rero.util.TokenizedString;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class LocalVariables
implements Variable {
    protected HashMap data = new HashMap();
    protected static Pattern rangePattern = Pattern.compile("\\$(\\d+)\\-(\\d+)");
    protected static Pattern rangeFromPattern = Pattern.compile("\\$(\\d+)\\-");
    protected static Pattern rangeToPattern = Pattern.compile("\\$\\-(\\d+)");
    protected static Pattern normalPattern = Pattern.compile("\\$(\\d+)");
    protected String parmsValue = null;

    public void setDataSource(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (string.equals("$data")) {
                this.parmsValue = (String)hashMap.get(string);
            }
            this.data.put(string, SleepUtils.getScalar((String)hashMap.get(string)));
        }
    }

    public boolean scalarExists(String string) {
        if (this.data.containsKey(string) || "%localData".equals(string)) {
            return true;
        }
        return this.parmsValue != null && (Character.isDigit(string.charAt(1)) || string.charAt(1) == '-');
    }

    public Scalar getScalar(String string) {
        if ("%localData".equals(string)) {
            return SleepUtils.getHashWrapper(this.data);
        }
        Scalar scalar = (Scalar)this.data.get(string);
        if (scalar == null && this.parmsValue != null && (Character.isDigit(string.charAt(1)) || string.charAt(1) == '-')) {
            TokenizedString tokenizedString = new TokenizedString(this.parmsValue, " ");
            StringParser stringParser = new StringParser(string, rangePattern);
            if (stringParser.matches()) {
                int n = Integer.parseInt(stringParser.getParsedStrings()[0]);
                int n2 = Integer.parseInt(stringParser.getParsedStrings()[1]);
                return SleepUtils.getScalar(tokenizedString.getTokenRange(n, n2));
            }
            stringParser = new StringParser(string, rangeToPattern);
            if (stringParser.matches()) {
                int n = Integer.parseInt(stringParser.getParsedStrings()[0]);
                return SleepUtils.getScalar(tokenizedString.getTokenTo(n));
            }
            stringParser = new StringParser(string, rangeFromPattern);
            if (stringParser.matches()) {
                int n = Integer.parseInt(stringParser.getParsedStrings()[0]);
                return SleepUtils.getScalar(tokenizedString.getTokenFrom(n));
            }
            stringParser = new StringParser(string, normalPattern);
            if (stringParser.matches()) {
                int n = Integer.parseInt(stringParser.getParsedStrings()[0]);
                return SleepUtils.getScalar(tokenizedString.getToken(n));
            }
        }
        return scalar;
    }

    public Scalar putScalar(String string, Scalar scalar) {
        return this.data.put(string, scalar);
    }

    public void removeScalar(String string) {
    }

    public Variable createLocalVariableContainer() {
        return null;
    }

    public Variable createInternalVariableContainer() {
        return null;
    }
}

