/*
 * Decompiled with CFR 0.152.
 */
package rero.script;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.WeakHashMap;
import rero.bridges.BridgeKeeper;
import rero.config.ClientState;
import rero.ircfw.ChatFramework;
import rero.script.GlobalVariables;
import rero.script.LocalVariables;
import sleep.engine.Block;
import sleep.interfaces.Loadable;
import sleep.parser.CodeGenerator;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class ScriptCore
implements Loadable {
    protected ScriptLoader scriptLoader;
    protected Hashtable environment;
    protected ScriptVariables variables;
    protected GlobalVariables globalData;
    protected BridgeKeeper bridges;
    protected static Scalar GLOBAL_HASH;

    public ScriptCore() {
        if (GLOBAL_HASH == null) {
            GLOBAL_HASH = SleepUtils.getHashScalar();
        }
        this.scriptLoader = new ScriptLoader();
        this.environment = new Hashtable();
        this.globalData = new GlobalVariables();
        this.globalData.putScalar("%GLOBAL", GLOBAL_HASH);
        this.variables = new ScriptVariables(this.globalData);
        this.bridges = new BridgeKeeper();
        this.scriptLoader.setCharsetConversion(false);
        this.scriptLoader.setGlobalCache(true);
        this.scriptLoader.addSpecificBridge(this);
        CodeGenerator.installEscapeConstant('B', "\u0002");
        CodeGenerator.installEscapeConstant('U', "\u001f");
        CodeGenerator.installEscapeConstant('R', "\u0016");
        CodeGenerator.installEscapeConstant('C', "\u0003");
        CodeGenerator.installEscapeConstant('O', "\u000f");
        CodeGenerator.installEscapeConstant('b', "\u0002");
        CodeGenerator.installEscapeConstant('u', "\u001f");
        CodeGenerator.installEscapeConstant('r', "\u0016");
        CodeGenerator.installEscapeConstant('c', "\u0003");
        CodeGenerator.installEscapeConstant('o', "\u000f");
        SleepUtils.addKeyword("wait");
        SleepUtils.addKeyword("on");
        SleepUtils.addKeyword("alias");
        SleepUtils.addKeyword("bind");
        Loadable[] loadableArray = this.bridges.getScriptBridges();
        for (int i = 0; i < loadableArray.length; ++i) {
            this.addBridge(loadableArray[i]);
        }
    }

    public void announceFramework(ChatFramework chatFramework) {
        this.bridges.announceFramework(chatFramework);
    }

    public void addBridge(Loadable loadable) {
        this.scriptLoader.addGlobalBridge(loadable);
    }

    public void storeDataStructures(WeakHashMap weakHashMap) {
        weakHashMap.put("scriptVariables", this.variables);
        weakHashMap.put("globalVariables", this.globalData);
        weakHashMap.put("scriptLoader", this.scriptLoader);
        weakHashMap.put("sharedEnvironment", this.environment);
        this.bridges.storeDataStructures(weakHashMap);
    }

    public Scalar callFunction(String string, Stack stack) {
        if (string.charAt(0) != '&') {
            string = '&' + string;
        }
        ScriptInstance scriptInstance = (ScriptInstance)this.scriptLoader.getScripts().getFirst();
        return scriptInstance.callFunction(string, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runCode(ScriptInstance scriptInstance, Block block, HashMap hashMap) {
        ScriptVariables scriptVariables = scriptInstance.getScriptVariables();
        synchronized (scriptVariables) {
            ScriptVariables scriptVariables2 = scriptInstance.getScriptVariables();
            scriptVariables2.pushLocalLevel();
            LocalVariables localVariables = (LocalVariables)scriptVariables2.getLocalVariables();
            if (hashMap != null) {
                localVariables.setDataSource(hashMap);
            }
            SleepUtils.runCode(block, scriptInstance.getScriptEnvironment());
            scriptVariables2.popLocalLevel();
        }
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        scriptInstance.setScriptVariables(this.variables);
        ClientState.getClientState().fireChange("loaded.scripts", scriptInstance.getName());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
        ClientState.getClientState().fireChange("loaded.scripts", scriptInstance.getName());
    }
}

