/*
 * Decompiled with CFR 0.152.
 */
package rero.util;

import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.dialogs.DialogUtilities;
import rero.util.TokenizedString;
import text.AttributedString;
import text.TextSource;

public class ClientUtils {
    private static String CP437TABLE = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00a2\u00a3\u00a5\u20a7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u2310\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u00df\u0393\u03c0\u03a3\u03c3\u00b5\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u03c6\u03b5\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0 ";

    public static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static JFrame getFrameForComponent(JComponent jComponent) {
        for (Container container = jComponent.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JFrame)) continue;
            return (JFrame)container;
        }
        return null;
    }

    public static String strip(String string) {
        return AttributedString.CreateAttributedString(string).getText();
    }

    public static String ShowVersion() {
        String string = ClientUtils.tagline();
        return "jIRCii " + ClientState.getClientState().getString("version.string", "08.07.08") + " " + System.getProperty("os.name").replaceAll(" ", "") + " : " + ClientState.getClientState().getString("version.addons", ClientUtils.tagline());
    }

    public static String tagline() {
        String[] stringArray = new String[]{"highly caffeinated", "Fat butane, grubbin' on French fries", "Clean. Christian. Comprehensive."};
        int n = ClientUtils.ctime() % stringArray.length;
        return stringArray[n];
    }

    public static String formatTime(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l < 60L) {
            return l + " seconds";
        }
        if (l < 3600L) {
            return l / 60L + " minutes";
        }
        if (l < 86400L) {
            return l / 3600L + " hours";
        }
        return l / 86400L + " days";
    }

    public static String formatTime2(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = (int)l;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n4 = n / 86400;
        n3 = n / 3600 % 24;
        n2 = n / 60 % 60;
        n %= 60;
        if (n4 > 0) {
            stringBuffer.append(n4);
            stringBuffer.append(":");
        }
        if (n3 > 0) {
            if (n3 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n3);
            stringBuffer.append(":");
        }
        if (n2 > 0) {
            if (n2 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n2);
            stringBuffer.append(":");
        }
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public static String formatTime3(long l) {
        int n = (int)l;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n4 = n / 86400;
        n3 = n / 3600 % 24;
        n2 = n / 60 % 60;
        n %= 60;
        StringBuffer stringBuffer = new StringBuffer();
        if (n4 > 0) {
            stringBuffer.append(n4).append(n4 != 1 ? " days, " : " day, ");
        }
        if (n4 > 0 || n3 > 0) {
            stringBuffer.append(n3).append(n3 != 1 ? " hours, " : " hour, ");
        }
        if (n3 > 0 || n2 > 0) {
            stringBuffer.append(n2).append(n2 != 1 ? " minutes, " : " minute, ");
        }
        stringBuffer.append(n).append(n != 1 ? " seconds" : " second");
        return stringBuffer.toString();
    }

    public static String formatBytes(long l) {
        if (l < 1024L) {
            return l + "b";
        }
        if ((l /= 1024L) < 1024L) {
            return l + "kb";
        }
        if ((l /= 1024L) < 1024L) {
            return l + "mb";
        }
        return (l /= 1024L) + "GB";
    }

    public static String encodeFont(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getFamily());
        stringBuffer.append("-");
        if (font.isBold()) {
            stringBuffer.append("BOLD");
        } else if (font.isItalic()) {
            stringBuffer.append("ITALIC");
        } else {
            stringBuffer.append("PLAIN");
        }
        stringBuffer.append("-");
        stringBuffer.append(font.getSize());
        return stringBuffer.toString();
    }

    public static void openURL(String string) {
        try {
            Runtime.getRuntime().exec(ClientState.getClientState().getString("ui.openfiles", ClientDefaults.ui_openfiles) + " " + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String mask(String string, int n) {
        if (string.length() == 0 || string.indexOf(33) < 1 || string.indexOf(64) < 1 || string.indexOf(46) < 1) {
            return "<bad address, use nick!user@host format>";
        }
        String string2 = string.substring(0, string.indexOf(33));
        String string3 = string.substring(string.indexOf(33) + 1, string.indexOf(64));
        String string4 = string.substring(string.indexOf(64) + 1, string.length());
        String string5 = string.lastIndexOf(46, string.lastIndexOf(46) - 1) > -1 ? "*" + string.substring(string.lastIndexOf(46, string.lastIndexOf(46) - 1), string.length()) : string4;
        switch (n) {
            case 0: {
                return "*!" + string3 + "@" + string4;
            }
            case 1: {
                return "*!*" + string3 + "@" + string4;
            }
            case 2: {
                return "*!*@" + string4;
            }
            case 3: {
                return "*!*" + string3 + "@" + string5;
            }
            case 4: {
                return "*!*@" + string5;
            }
            case 5: {
                return string2 + "!" + string3 + "@" + string4;
            }
            case 6: {
                return string2 + "!*" + string3 + "@" + string4;
            }
            case 7: {
                return string2 + "!*@" + string4;
            }
            case 8: {
                return string2 + "!*" + string3 + "@" + string5;
            }
            case 9: {
                return string2 + "!*@" + string5;
            }
        }
        return string;
    }

    public static String longip(String string) {
        TokenizedString tokenizedString = new TokenizedString(string);
        tokenizedString.tokenize(".");
        if (tokenizedString.getTotalTokens() == 4) {
            long l = Long.parseLong(tokenizedString.getToken(0));
            long l2 = Long.parseLong(tokenizedString.getToken(1));
            long l3 = Long.parseLong(tokenizedString.getToken(2));
            long l4 = Long.parseLong(tokenizedString.getToken(3));
            long l5 = (l << 24) + (l2 << 16) + (l3 << 8) + l4;
            return l5 + "";
        }
        long l = Long.parseLong(string);
        long l6 = (l & 0xFFFFFFFFFF000000L) >> 24;
        long l7 = (l & 0xFF0000L) >> 16;
        long l8 = (l & 0xFF00L) >> 8;
        long l9 = l & 0xFFL;
        return l6 + "." + l7 + "." + l8 + "." + l9;
    }

    public static String TimeStamp() {
        Date date = new Date();
        String string = "am";
        int n = date.getHours();
        int n2 = date.getMinutes();
        if (n == 0) {
            n = 12;
            string = "am";
        } else if (n > 12) {
            n -= 12;
            string = "pm";
        } else if (n == 12) {
            string = "pm";
        }
        String string2 = n2 <= 9 ? n + ":0" + n2 + string : n + ":" + n2 + string;
        return string2;
    }

    public static HashMap getEventHashMap(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("$data", string + " " + string2);
        hashMap.put("$parms", string2);
        return hashMap;
    }

    public static String TimeDateStamp(long l) {
        Date date = new Date(l * 1000L);
        String string = "am";
        int n = date.getHours();
        int n2 = date.getMinutes();
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (n >= 12) {
            string = "pm";
            if ((n -= 12) == 0) {
                n = 12;
            }
        }
        if (n2 <= 9) {
            stringBuffer.append(n);
            stringBuffer.append(":0");
            stringBuffer.append(n2);
            stringBuffer.append(string);
        } else {
            stringBuffer.append(n);
            stringBuffer.append(":");
            stringBuffer.append(n2);
            stringBuffer.append(string);
        }
        stringBuffer2.append(ClientUtils.intToDay(date.getDay()));
        stringBuffer2.append(" ");
        stringBuffer2.append(ClientUtils.intToMonth(date.getMonth()));
        stringBuffer2.append(" ");
        stringBuffer2.append(date.getDate());
        stringBuffer2.append(" ");
        stringBuffer2.append(date.getYear() + 1900);
        stringBuffer2.append(" ");
        stringBuffer2.append(stringBuffer.toString());
        return stringBuffer2.toString();
    }

    public static String intToDay(int n) {
        switch (n %= 7) {
            case 0: {
                return "Sun";
            }
            case 1: {
                return "Mon";
            }
            case 2: {
                return "Tues";
            }
            case 3: {
                return "Wed";
            }
            case 4: {
                return "Thurs";
            }
            case 5: {
                return "Fri";
            }
            case 6: {
                return "Sat";
            }
        }
        return "Unknown Day: " + n;
    }

    public static boolean isNumeric(String string) {
        return Character.isDigit(string.charAt(0));
    }

    public static String intToMonth(int n) {
        switch (n) {
            case 0: {
                return "Jan";
            }
            case 1: {
                return "Feb";
            }
            case 2: {
                return "Mar";
            }
            case 3: {
                return "Apr";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "Jun";
            }
            case 6: {
                return "Jul";
            }
            case 7: {
                return "Aug";
            }
            case 8: {
                return "Sep";
            }
            case 9: {
                return "Oct";
            }
            case 10: {
                return "Nov";
            }
            case 11: {
                return "Dec";
            }
        }
        return "Unknown Month: " + n;
    }

    public static boolean isChannel(String string) {
        return string.length() > 0 && (string.charAt(0) == '#' || string.charAt(0) == '&');
    }

    public static int ctime() {
        Long l = new Long(System.currentTimeMillis() / 1000L);
        return l.intValue();
    }

    public static String BuildCP437String(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= CP437TABLE.length()) continue;
            cArray[i] = CP437TABLE.charAt(c);
        }
        return new String(cArray);
    }

    public static void dump2(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println(string + "=> " + hashMap.get(string));
        }
        System.out.println("   ... Done ...");
    }

    public static String formatLongAsDecimal(long l) {
        String string = l + "";
        if (string.length() < 3) {
            while (string.length() < 3) {
                string = "0" + string;
            }
            return "." + string;
        }
        return string.substring(0, string.length() - 3) + "." + string.substring(string.length() - 3, string.length());
    }

    public static void removeAll(Collection collection, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            collection.remove(iterator.next());
        }
    }

    public static String generateThemeScript(String string) {
        Comparable<File> comparable;
        if ((string == null || string.length() == 0) && (comparable = DialogUtilities.showSaveDialog("Save Theme Script")) != null) {
            string = ((File)comparable).getAbsolutePath();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        comparable = new StringBuffer();
        ((StringBuffer)comparable).append("# jIRCii Theme File, scripters feel free to edit this file to export more settings\n");
        ((StringBuffer)comparable).append("#     by default only color settings are exported.\n\n");
        ((StringBuffer)comparable).append("# some miscellaneous colors\n");
        ((StringBuffer)comparable).append(ClientUtils.generateThemeLine("statusbar.color", null));
        ((StringBuffer)comparable).append(ClientUtils.generateThemeLine("window.color", null));
        ((StringBuffer)comparable).append(ClientUtils.generateThemeLine("desktop.color", null));
        ((StringBuffer)comparable).append(ClientUtils.generateThemeLine("switchbar.color", null));
        ((StringBuffer)comparable).append(ClientUtils.generateThemeLine("ui.editcolor", null));
        ((StringBuffer)comparable).append("\n");
        ((StringBuffer)comparable).append("# the actual color map\n");
        for (int i = 0; i < 100; ++i) {
            ((StringBuffer)comparable).append("setMappedColor(");
            ((StringBuffer)comparable).append(i);
            ((StringBuffer)comparable).append(", \"");
            ((StringBuffer)comparable).append(TextSource.colorTable[i].getRGB());
            ((StringBuffer)comparable).append("\");\n");
        }
        ((StringBuffer)comparable).append("\n# force jIRCii to update settings right away\n");
        ((StringBuffer)comparable).append("setProperty(\"desktop\", -1);\n");
        ((StringBuffer)comparable).append("setProperty(\"statusbar\", -1);\n");
        ((StringBuffer)comparable).append("setProperty(\"window\", -1);\n");
        ((StringBuffer)comparable).append("\nsaveColorMap();\n");
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(string), false));
            printWriter.println(((StringBuffer)comparable).toString());
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new File(string).getName();
    }

    private static String generateThemeLine(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (ClientState.getClientState().getString(string, null) != null) {
            if (string2 != null) {
                stringBuffer.append("# " + string2 + "\n");
            }
            stringBuffer.append("setProperty(\"");
            stringBuffer.append(string);
            stringBuffer.append("\", \"");
            stringBuffer.append(ClientState.getClientState().getString(string, null));
            stringBuffer.append("\");\n");
        }
        return stringBuffer.toString();
    }

    public static File getFile(String string) {
        if (string.length() > 0 && string.charAt(0) == '~' && System.getProperty("user.home") != null) {
            return new File(System.getProperty("user.home").toString(), string.substring(1));
        }
        return new File(string);
    }

    public static LinkedList fileCompleteAll(String string) {
        File file;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = null;
        File file2 = ClientUtils.getFile(string);
        if (file2.isDirectory()) {
            file = file2;
            string2 = null;
        } else if (file2.getParentFile() != null && file2.getParentFile().isDirectory()) {
            file = file2.getParentFile();
            string2 = file2.getName();
        } else {
            file = new File(new File("").getAbsolutePath());
            string2 = string;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string3 = fileArray[i].getName();
            if (string2 == null) {
                linkedList.add(fileArray[i].getAbsolutePath());
                continue;
            }
            if (string3.length() >= string2.length() && string3.toUpperCase().substring(0, string2.length()).equals(string2.toUpperCase())) {
                linkedList.add(0, fileArray[i].getAbsolutePath());
                continue;
            }
            if (string3.toUpperCase().indexOf(string2.toUpperCase()) <= -1) continue;
            linkedList.add(fileArray[i].getAbsolutePath());
        }
        linkedList.add(string);
        return linkedList;
    }
}

