/*
 * Decompiled with CFR 0.152.
 */
package sleep.console;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import sleep.bridges.DefaultVariable;
import sleep.bridges.SleepClosure;
import sleep.console.ConsoleProxy;
import sleep.engine.Block;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Loadable;
import sleep.interfaces.Variable;
import sleep.parser.ImportManager;
import sleep.parser.Parser;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;
import sleep.runtime.ScriptVariables;

public class ConsoleImplementation
implements RuntimeWarningWatcher,
Loadable,
ConsoleProxy {
    private ScriptInstance script;
    private ConsoleProxy myProxy;
    private Hashtable sharedEnvironment;
    private Variable sharedVariables;
    private ScriptLoader loader;
    private ImportManager imports;
    private boolean interact = true;

    public ConsoleImplementation() {
        this(new Hashtable(), new DefaultVariable(), new ScriptLoader());
    }

    public ConsoleImplementation(Hashtable hashtable, Variable variable, ScriptLoader scriptLoader) {
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (variable == null) {
            variable = new DefaultVariable();
        }
        if (scriptLoader == null) {
            scriptLoader = new ScriptLoader();
        }
        this.sharedEnvironment = hashtable;
        this.sharedVariables = variable;
        this.loader = scriptLoader;
        this.loader.addSpecificBridge(this);
        this.setProxy(this);
    }

    public ConsoleProxy getProxy() {
        return this.myProxy;
    }

    public void setProxy(ConsoleProxy consoleProxy) {
        this.myProxy = consoleProxy;
    }

    public void consolePrint(String string) {
    }

    public String consoleReadln() {
        return null;
    }

    public void consolePrintln(Object object) {
    }

    public void rppl() throws IOException {
        block25: {
            this.getProxy().consolePrintln(">> Welcome to the Sleep scripting language");
            this.interact = false;
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            while (true) {
                Object object;
                String string2;
                String string3;
                if (!this.interact) {
                    this.getProxy().consolePrint("> ");
                }
                String string4 = this.getProxy().consoleReadln();
                if (this.interact) {
                    if (string4 == null || string4.equals("done")) {
                        this.interact = false;
                        continue;
                    }
                    if (string4.equals(".")) {
                        if (stringBuffer.length() == 0) {
                            this.eval(string, string);
                            continue;
                        }
                        this.eval(stringBuffer.toString(), stringBuffer.toString());
                        string = stringBuffer.toString();
                        stringBuffer = new StringBuffer();
                        continue;
                    }
                    stringBuffer.append(string4 + "\n");
                    continue;
                }
                if (string4 == null) break;
                if (string4.indexOf(32) > -1) {
                    string3 = string4.substring(0, string4.indexOf(32));
                    string2 = string4.substring(string3.length() + 1, string4.length());
                } else {
                    string3 = string4;
                    string2 = null;
                }
                if (string3.equals("env")) {
                    String string5;
                    if (string2 != null && string2.indexOf(32) > -1) {
                        string5 = string2.substring(string2.indexOf(32) + 1, string2.length());
                        string2 = string2.substring(0, string2.indexOf(32));
                    } else {
                        string5 = null;
                    }
                    this.env(string2, string5);
                    continue;
                }
                if (string3.equals("version")) {
                    this.getProxy().consolePrintln("Sleep 2.1 (20080807)");
                    continue;
                }
                if (string3.equals("help") && string2 != null) {
                    this.help(string2);
                    continue;
                }
                if (string3.equals("help")) {
                    this.help();
                    continue;
                }
                if (string3.equals("interact")) {
                    this.interact();
                    continue;
                }
                if (string3.equals("list")) {
                    this.list();
                    continue;
                }
                if (string3.equals("debug") && string2 != null) {
                    object = string2.split(" ");
                    if (((String[])object).length == 2) {
                        this.debug(object[0], Integer.parseInt(object[1]));
                        continue;
                    }
                    if (((String[])object).length == 1) {
                        this.debug(null, Integer.parseInt(object[0]));
                        continue;
                    }
                    this.getProxy().consolePrintln("Invalid usage: debug [script] <level>");
                    continue;
                }
                if (string3.equals("load") && string2 != null) {
                    this.load(string2);
                    continue;
                }
                if (string3.equals("tree") && (string2 != null || this.script != null)) {
                    this.tree(string2);
                    continue;
                }
                if (string3.equals("unload") && string2 != null) {
                    this.unload(string2);
                    continue;
                }
                if (string3.equals("x") && string2 != null) {
                    object = this.eval("return " + string2 + ";", string2);
                    if (object == null) continue;
                    this.getProxy().consolePrintln(object + "");
                    continue;
                }
                if (string3.equals("?") && string2 != null) {
                    object = this.eval("return iff(" + string2 + ", 'true', 'false');", string2);
                    if (object == null) continue;
                    this.getProxy().consolePrintln(object + "");
                    continue;
                }
                if (string3.equals("quit") || string3.equals("exit") || string3.equals("done")) {
                    this.getProxy().consolePrintln("Good bye!");
                    this.setProxy(this);
                    break block25;
                }
                if (string3.trim().length() <= 0) continue;
                this.getProxy().consolePrintln("Command '" + string3 + "' not understood.  Type 'help' if you need it");
            }
            this.getProxy().consolePrintln("Good bye!");
            this.setProxy(this);
        }
        this.interact = true;
    }

    private void help() {
        this.getProxy().consolePrintln("debug [script] <level>");
        this.getProxy().consolePrintln("env [functions/other] [regex filter]");
        this.getProxy().consolePrintln("help [command]");
        this.getProxy().consolePrintln("interact");
        this.getProxy().consolePrintln("list");
        this.getProxy().consolePrintln("load <file>");
        this.getProxy().consolePrintln("unload <file>");
        this.getProxy().consolePrintln("tree [key]");
        this.getProxy().consolePrintln("quit");
        this.getProxy().consolePrintln("version");
        this.getProxy().consolePrintln("x <expression>");
        this.getProxy().consolePrintln("? <predicate expression>");
    }

    private void help(String string) {
        if (string.equals("debug")) {
            this.getProxy().consolePrintln("debug [script] <level>");
            this.getProxy().consolePrintln("   sets the debug level for the specified script");
            this.getProxy().consolePrintln("   1 - show critical errors");
            this.getProxy().consolePrintln("   2 - show warnings");
            this.getProxy().consolePrintln("   4 - strict mode, complain about non-declared variables");
            this.getProxy().consolePrintln("   8 - trace all function calls");
            this.getProxy().consolePrintln("   to combine options, add their numbers together");
        } else if (string.equals("env")) {
            this.getProxy().consolePrintln("env [functions/other] [regex filter]");
            this.getProxy().consolePrintln("   dumps the shared environment, filters output with specified regex");
        } else if (string.equals("interact")) {
            this.getProxy().consolePrintln("interact");
            this.getProxy().consolePrintln("   enters the console into interactive mode.");
        } else if (string.equals("list")) {
            this.getProxy().consolePrintln("list");
            this.getProxy().consolePrintln("   lists all of the currently loaded scripts");
        } else if (string.equals("load")) {
            this.getProxy().consolePrintln("load <file>");
            this.getProxy().consolePrintln("   loads a script file into the script loader");
        } else if (string.equals("unload")) {
            this.getProxy().consolePrintln("unload <file>");
            this.getProxy().consolePrintln("   unloads a script file from the script loader");
        } else if (string.equals("tree")) {
            this.getProxy().consolePrintln("tree [key]");
            this.getProxy().consolePrintln("   displays the Abstract Syntax Tree for the specified key");
        } else if (string.equals("quit")) {
            this.getProxy().consolePrintln("quit");
            this.getProxy().consolePrintln("   stops the console");
        } else if (string.equals("version")) {
            this.getProxy().consolePrintln("version");
            this.getProxy().consolePrintln("   display the current Sleep version");
        } else if (string.equals("x")) {
            this.getProxy().consolePrintln("x <expression>");
            this.getProxy().consolePrintln("   evaluates a sleep expression and displays the value");
        } else if (string.equals("?")) {
            this.getProxy().consolePrintln("? <predicate expression>");
            this.getProxy().consolePrintln("   evaluates a sleep predicate expression and displays the truth value");
        } else {
            this.getProxy().consolePrintln("help [command]");
            this.getProxy().consolePrintln("   displays a help message for the specified command");
        }
    }

    private void load(String string) {
        try {
            ScriptInstance scriptInstance = this.loader.loadScript(string, this.sharedEnvironment);
            if (System.getProperty("sleep.debug") != null) {
                scriptInstance.setDebugFlags(Integer.parseInt(System.getProperty("sleep.debug")));
            }
            scriptInstance.runScript();
        }
        catch (YourCodeSucksException yourCodeSucksException) {
            this.processScriptErrors(yourCodeSucksException);
        }
        catch (Exception exception) {
            this.getProxy().consolePrintln("Could not load script " + string + ": " + exception.getMessage());
        }
    }

    private String getFullScript(String string) {
        if (this.loader.getScriptsByKey().containsKey(string)) {
            return string;
        }
        Iterator iterator = this.loader.getScripts().iterator();
        while (iterator.hasNext()) {
            ScriptInstance scriptInstance = (ScriptInstance)iterator.next();
            File file = new File(scriptInstance.getName());
            if (!file.getName().equals(string)) continue;
            return file.getAbsolutePath();
        }
        return string;
    }

    private void unload(String string) {
        try {
            this.loader.unloadScript(this.getFullScript(string));
        }
        catch (Exception exception) {
            this.getProxy().consolePrintln("Could not unloaded script " + string + ": " + exception.getMessage());
        }
    }

    private void list() {
        Iterator iterator = this.loader.getScripts().iterator();
        while (iterator.hasNext()) {
            ScriptInstance scriptInstance = (ScriptInstance)iterator.next();
            this.getProxy().consolePrintln(scriptInstance.getName());
        }
    }

    private void env(String string, String string2) {
        Iterator iterator = this.sharedEnvironment.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (string != null && (!string.equals("functions") || k.toString().charAt(0) != '&') && (!string.equals("other") || k.toString().charAt(0) == '&') || string2 != null && !Pattern.matches(".*?" + string2 + ".*", this.sharedEnvironment.get(k).toString())) continue;
            this.getProxy().consolePrintln(this.align(k.toString(), 20) + " => " + this.sharedEnvironment.get(k));
        }
    }

    private String align(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private void tree(String string) {
        if (string == null) {
            this.getProxy().consolePrintln(this.script.getRunnableBlock().toString());
        } else if (string.charAt(0) == '&' || string.charAt(0) == '$') {
            if (this.sharedEnvironment != null && this.sharedEnvironment.get(string) instanceof SleepClosure) {
                SleepClosure sleepClosure = (SleepClosure)this.sharedEnvironment.get(string);
                this.getProxy().consolePrintln(sleepClosure.getRunnableCode());
            } else {
                this.getProxy().consolePrintln("Could not find code block " + string + " to print tree of");
            }
        } else {
            Map map2 = this.loader.getScriptsByKey();
            if (map2.get(this.getFullScript(string)) != null) {
                this.getProxy().consolePrintln(((ScriptInstance)map2.get(this.getFullScript(string))).getRunnableBlock());
            } else {
                this.getProxy().consolePrintln("Could not find script " + string + " to print tree of");
            }
        }
    }

    private void debug(String string, int n) {
        if (string == null) {
            System.setProperty("sleep.debug", "" + n);
            this.getProxy().consolePrintln("Default debug level set");
        } else {
            Map map2 = this.loader.getScriptsByKey();
            if (map2.get(this.getFullScript(string)) != null) {
                ((ScriptInstance)map2.get(this.getFullScript(string))).setDebugFlags(n);
                this.getProxy().consolePrintln("Debug level set for " + string);
            } else {
                this.getProxy().consolePrintln("Could not find script " + string + " to set debug level for");
            }
        }
    }

    private void interact() {
        this.interact = true;
        this.getProxy().consolePrintln(">> Welcome to interactive mode.");
        this.getProxy().consolePrintln("Type your code and then '.' on a line by itself to execute the code.");
        this.getProxy().consolePrintln("Type Ctrl+D or 'done' on a line by itself to leave interactive mode.");
    }

    private Scalar eval(String string, String string2) {
        try {
            Parser parser = new Parser("eval", string.toString(), this.imports);
            this.imports = parser.getImportManager();
            parser.parse();
            Block block = parser.getRunnableBlock();
            this.script = this.loader.loadScript("<interact mode>", block, this.sharedEnvironment);
            if (System.getProperty("sleep.debug") != null) {
                this.script.setDebugFlags(Integer.parseInt(System.getProperty("sleep.debug")));
            }
            return this.script.runScript();
        }
        catch (YourCodeSucksException yourCodeSucksException) {
            this.processScriptErrors(yourCodeSucksException);
        }
        catch (Exception exception) {
            this.getProxy().consolePrintln("error with " + string2 + ": " + exception.toString());
        }
        return null;
    }

    public void processScriptErrors(YourCodeSucksException yourCodeSucksException) {
        this.getProxy().consolePrint(yourCodeSucksException.formatErrors());
    }

    public void processScriptWarning(ScriptWarning scriptWarning) {
        this.getProxy().consolePrintln(scriptWarning.toString());
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        if (!scriptInstance.getName().equals("<interact mode>") && !this.interact) {
            this.getProxy().consolePrintln(scriptInstance.getName() + " loaded successfully.");
        }
        scriptInstance.addWarningWatcher(this);
        scriptInstance.setScriptVariables(new ScriptVariables(this.sharedVariables));
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
        this.getProxy().consolePrintln(scriptInstance.getName() + " has been unloaded");
    }
}

