/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.engine.ObjectUtilities;
import sleep.interfaces.Function;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class ProxyInterface
implements InvocationHandler {
    protected ScriptInstance script;
    protected Function func;

    public ProxyInterface(Function function2, ScriptInstance scriptInstance) {
        this.func = function2;
        this.script = scriptInstance;
    }

    public ScriptInstance getOwner() {
        return this.script;
    }

    public static Object BuildInterface(Class clazz, Function function2, ScriptInstance scriptInstance) {
        return ProxyInterface.BuildInterface(new Class[]{clazz}, function2, scriptInstance);
    }

    public static Object BuildInterface(Class[] classArray, Function function2, ScriptInstance scriptInstance) {
        ProxyInterface proxyInterface = new ProxyInterface(function2, scriptInstance);
        return Proxy.newProxyInstance(classArray[0].getClassLoader(), classArray, (InvocationHandler)proxyInterface);
    }

    public static Object BuildInterface(Class clazz, Block block, ScriptInstance scriptInstance) {
        return ProxyInterface.BuildInterface(clazz, (Function)new SleepClosure(scriptInstance, block), scriptInstance);
    }

    public static Object BuildInterface(Class[] classArray, Block block, ScriptInstance scriptInstance) {
        return ProxyInterface.BuildInterface(classArray, (Function)new SleepClosure(scriptInstance, block), scriptInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        ScriptVariables scriptVariables = this.script.getScriptVariables();
        synchronized (scriptVariables) {
            Scalar scalar;
            this.script.getScriptEnvironment().pushSource("<Java>");
            Stack<Scalar> stack = new Stack<Scalar>();
            boolean bl = (this.script.getDebugFlags() & 8) == 8;
            StringBuffer stringBuffer = null;
            if (objectArray != null) {
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    stack.push(ObjectUtilities.BuildScalar(true, objectArray[i]));
                }
            }
            this.script.getScriptEnvironment().installExceptionHandler(null, null, null);
            if (bl) {
                if (!this.script.isProfileOnly()) {
                    stringBuffer = new StringBuffer("[" + this.func + " " + method.getName());
                    if (!stack.isEmpty()) {
                        stringBuffer.append(": " + SleepUtils.describe(stack));
                    }
                    stringBuffer.append("]");
                }
                long l = System.currentTimeMillis();
                scalar = this.func.evaluate(method.getName(), this.script, stack);
                l = System.currentTimeMillis() - l;
                if (this.func.getClass() == SleepClosure.class) {
                    this.script.collect(((SleepClosure)this.func).toStringGeneric(), -1, l);
                }
                if (stringBuffer != null) {
                    if (this.script.getScriptEnvironment().isThrownValue()) {
                        stringBuffer.append(" - FAILED!");
                    } else {
                        stringBuffer.append(" = " + SleepUtils.describe(scalar));
                    }
                    this.script.fireWarning(stringBuffer.toString(), -1, true);
                }
            } else {
                scalar = this.func.evaluate(method.getName(), this.script, stack);
            }
            this.script.getScriptEnvironment().popExceptionContext();
            this.script.getScriptEnvironment().clearReturn();
            this.script.getScriptEnvironment().popSource();
            if (this.script.getScriptEnvironment().isThrownValue()) {
                this.script.recordStackFrame(this.func + " as " + method.toString(), "<Java>", -1);
                Object object2 = this.script.getScriptEnvironment().getExceptionMessage().objectValue();
                if (object2 instanceof Throwable) {
                    throw (Throwable)object2;
                }
                throw new RuntimeException(object2.toString());
            }
            if (scalar != null) {
                return ObjectUtilities.buildArgument(method.getReturnType(), scalar, this.script);
            }
            return null;
        }
    }
}

