/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import sleep.engine.Block;
import sleep.engine.GeneratedSteps;
import sleep.engine.Step;
import sleep.engine.atoms.Check;
import sleep.engine.atoms.PLiteral;
import sleep.parser.Checkers;
import sleep.parser.LexicalAnalyzer;
import sleep.parser.Parser;
import sleep.parser.ParserConstants;
import sleep.parser.ParserUtilities;
import sleep.parser.Statement;
import sleep.parser.StringIterator;
import sleep.parser.Token;
import sleep.parser.TokenList;
import sleep.parser.TokenParser;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class CodeGenerator
implements ParserConstants {
    protected Block CURRENT_BLOCK;
    protected Stack BACKUP_BLOCKS;
    protected GeneratedSteps factory;
    protected Parser parser;
    protected static HashMap escape_constants = new HashMap();

    public static void installEscapeConstant(char c, String string) {
        escape_constants.put(c + "", string);
    }

    public Block getRunnableBlock() {
        return this.CURRENT_BLOCK;
    }

    public void add(Step step, Token token) {
        this.CURRENT_BLOCK.add(step);
        step.setInfo(token.getHint());
    }

    public void backup() {
        this.BACKUP_BLOCKS.push(this.CURRENT_BLOCK);
        this.CURRENT_BLOCK = new Block(this.parser.getName());
    }

    public Block restore() {
        Block block = this.CURRENT_BLOCK;
        this.CURRENT_BLOCK = (Block)this.BACKUP_BLOCKS.pop();
        return block;
    }

    public CodeGenerator(Parser parser, GeneratedSteps generatedSteps) {
        this.parser = parser;
        this.factory = generatedSteps != null ? generatedSteps : new GeneratedSteps();
        this.CURRENT_BLOCK = new Block(this.parser.getName());
        this.BACKUP_BLOCKS = new Stack();
    }

    public CodeGenerator(Parser parser) {
        this(parser, null);
    }

    public Check parsePredicate(Token token) {
        Statement statement = TokenParser.ParsePredicate(this.parser, LexicalAnalyzer.GroupBlockTokens(this.parser, new StringIterator(token.toString(), token.getHint())));
        return this.parsePredicate(statement);
    }

    public Check parsePredicate(Statement statement) {
        Token[] tokenArray = statement.getTokens();
        String[] stringArray = statement.getStrings();
        switch (statement.getType()) {
            case 805: {
                return this.parsePredicate(ParserUtilities.extract(tokenArray[0]));
            }
            case 806: {
                if (stringArray[0].charAt(0) == '!' && stringArray[0].length() > 1) {
                    return this.parsePredicate(tokenArray[0].copy("!-istrue (" + stringArray[0].substring(1, stringArray[0].length()) + ")"));
                }
                return this.parsePredicate(tokenArray[0].copy("-istrue (" + stringArray[0] + ")"));
            }
            case 801: {
                this.backup();
                this.parseIdea(tokenArray[0]);
                this.parseIdea(tokenArray[2]);
                Check check = this.factory.Check(stringArray[1], this.restore());
                check.setInfo(tokenArray[1].getHint());
                return check;
            }
            case 802: {
                this.backup();
                this.parseIdea(tokenArray[1]);
                Check check = this.factory.Check(stringArray[0], this.restore());
                check.setInfo(tokenArray[0].getHint());
                return check;
            }
            case 804: {
                Check check = null;
                Stack<Token> stack = new Stack<Token>();
                for (int i = 0; i < tokenArray.length; ++i) {
                    stack.push(tokenArray[i]);
                }
                while (!stack.isEmpty()) {
                    Token token = (Token)stack.pop();
                    if (token.toString().equals("&&")) continue;
                    Check check2 = check;
                    check = this.parsePredicate(token);
                    check.setChoices(check2, null);
                }
                return check;
            }
            case 803: {
                Check check = null;
                Stack<Token> stack = new Stack<Token>();
                for (int i = 0; i < tokenArray.length; ++i) {
                    stack.push(tokenArray[i]);
                }
                while (!stack.isEmpty()) {
                    Token token = (Token)stack.pop();
                    if (token.toString().equals("||")) continue;
                    Check check3 = check;
                    check = this.parsePredicate(token);
                    check.setChoices(null, check3);
                }
                return check;
            }
        }
        this.parser.reportError("Unknown predicate.", tokenArray[0].copy(statement.toString()));
        return null;
    }

    public void parseObject(Token token) {
        Statement statement = TokenParser.ParseObject(this.parser, LexicalAnalyzer.GroupExpressionIndexTokens(this.parser, new StringIterator(token.toString(), token.getHint())));
        if (this.parser.hasErrors()) {
            return;
        }
        this.parseObject(statement);
    }

    public void parseObject(Statement statement) {
        String[] stringArray = statement.getStrings();
        Token[] tokenArray = statement.getTokens();
        Class clazz = null;
        switch (statement.getType()) {
            case 441: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                if (tokenArray.length > 1) {
                    this.parseParameters(tokenArray[1]);
                }
                if ((clazz = this.parser.findImportedClass(stringArray[0])) == null) {
                    this.parser.reportError("Class " + stringArray[0] + " was not found", tokenArray[0]);
                }
                step = this.factory.ObjectNew(clazz);
                this.add(step, tokenArray[0]);
                break;
            }
            case 446: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                if (tokenArray.length > 1) {
                    this.parseParameters(tokenArray[1]);
                }
                this.parseIdea(tokenArray[0]);
                step = this.factory.ObjectAccess(null);
                this.add(step, tokenArray[0]);
                break;
            }
            case 442: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                if (tokenArray.length > 2) {
                    this.parseParameters(tokenArray[2]);
                }
                this.parseIdea(tokenArray[0]);
                step = this.factory.ObjectAccess(stringArray[1]);
                this.add(step, tokenArray[0]);
                break;
            }
            case 443: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                if (tokenArray.length > 2) {
                    this.parseParameters(tokenArray[2]);
                }
                if ((clazz = this.parser.findImportedClass(stringArray[0])) == null) {
                    this.parser.reportError("Class " + stringArray[0] + " was not found", tokenArray[0]);
                }
                step = this.factory.ObjectAccessStatic(clazz, stringArray[1]);
                this.add(step, tokenArray[0]);
            }
        }
    }

    public void parseBlock(Token token) {
        LinkedList linkedList = TokenParser.ParseBlocks(this.parser, LexicalAnalyzer.GroupBlockTokens(this.parser, new StringIterator(token.toString(), token.getHint())));
        if (this.parser.hasErrors()) {
            return;
        }
        if (linkedList.size() == 0) {
            Step step = new Step();
            this.add(step, token);
        } else {
            this.parseBlock(linkedList);
        }
    }

    public void parseBlock(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.parse((Statement)iterator.next());
        }
    }

    public List parseIdea(Token token) {
        LinkedList linkedList = TokenParser.ParseIdea(this.parser, LexicalAnalyzer.GroupBlockTokens(this.parser, new StringIterator(token.toString(), token.getHint())));
        if (this.parser.hasErrors()) {
            return null;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.parse((Statement)iterator.next());
        }
        return linkedList;
    }

    public void parse(Statement statement) {
        String[] stringArray = statement.getStrings();
        Token[] tokenArray = statement.getTokens();
        switch (statement.getType()) {
            case 705: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                step = this.factory.Get(stringArray[0].substring(1));
                this.add(step, tokenArray[0]);
                Scalar scalar = SleepUtils.getScalar(stringArray[0].substring(1));
                step = this.factory.SValue(scalar);
                this.add(step, tokenArray[0]);
                step = this.factory.Operate("=>");
                this.add(step, tokenArray[0]);
                break;
            }
            case 612: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[2]);
                List list = this.parseIdea(tokenArray[2]);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Statement statement2 = (Statement)iterator.next();
                    if (statement2.getType() != 612) continue;
                    this.parser.reportError("key/value pair specified for '" + tokenArray[0] + "', did you forget a comma?", tokenArray[2]);
                }
                Scalar scalar = SleepUtils.getScalar(stringArray[0]);
                step = this.factory.SValue(scalar);
                this.add(step, tokenArray[0]);
                step = this.factory.Operate(stringArray[1]);
                this.add(step, tokenArray[1]);
                break;
            }
            case 603: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[2]);
                this.parseIdea(tokenArray[2]);
                this.parseIdea(tokenArray[0]);
                step = this.factory.Operate(stringArray[1]);
                this.add(step, tokenArray[1]);
                break;
            }
            case 611: {
                this.parseObject(ParserUtilities.extract(tokenArray[0]));
                break;
            }
            case 606: {
                StringBuffer stringBuffer = new StringBuffer(ParserUtilities.extract(stringArray[0]));
                for (int i = 0; i < stringBuffer.length(); ++i) {
                    char c;
                    if (stringBuffer.charAt(i) != '\\' || i + 1 >= stringBuffer.length() || (c = stringBuffer.charAt(i + 1)) != '\'' && c != '\\') continue;
                    stringBuffer.deleteCharAt(i);
                }
                Scalar scalar = SleepUtils.getScalar(stringBuffer.toString());
                Step step = this.factory.SValue(scalar);
                this.add(step, tokenArray[0]);
                break;
            }
            case 607: {
                Scalar scalar = stringArray[0].endsWith("L") ? SleepUtils.getScalar(Long.decode(stringArray[0].substring(0, stringArray[0].length() - 1))) : SleepUtils.getScalar(Integer.decode(stringArray[0]));
                Step step = this.factory.SValue(scalar);
                this.add(step, tokenArray[0]);
                break;
            }
            case 608: {
                Scalar scalar = SleepUtils.getScalar(Double.parseDouble(stringArray[0]));
                Step step = this.factory.SValue(scalar);
                this.add(step, tokenArray[0]);
                break;
            }
            case 609: {
                Scalar scalar = SleepUtils.getScalar(Boolean.valueOf(stringArray[0]));
                Step step = this.factory.SValue(scalar);
                this.add(step, tokenArray[0]);
                break;
            }
            case 614: {
                Class clazz = this.parser.findImportedClass(stringArray[0].substring(1));
                if (clazz == null) {
                    this.parser.reportError("unable to resolve class: " + stringArray[0].substring(1), tokenArray[0]);
                    break;
                }
                Scalar scalar = SleepUtils.getScalar(this.parser.findImportedClass(stringArray[0].substring(1)));
                Step step = this.factory.SValue(scalar);
                this.add(step, tokenArray[0]);
                break;
            }
            case 701: {
                if (stringArray[0].equals("$null")) {
                    Scalar scalar = SleepUtils.getEmptyScalar();
                    Step step = this.factory.SValue(scalar);
                    this.add(step, tokenArray[0]);
                    break;
                }
                Step step = this.factory.Get(stringArray[0]);
                this.add(step, tokenArray[0]);
                break;
            }
            case 710: {
                this.parseIdea(tokenArray[0]);
                for (int i = 1; i < tokenArray.length; ++i) {
                    this.backup();
                    Step step = this.factory.CreateFrame();
                    this.add(step, tokenArray[0]);
                    this.parseIdea(ParserUtilities.extract(tokenArray[i]));
                    step = this.factory.Index(stringArray[0], this.restore());
                    this.add(step, tokenArray[0]);
                }
                break;
            }
            case 601: {
                this.parseIdea(ParserUtilities.extract(tokenArray[0]));
                break;
            }
            case 506: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                statement.setType(605);
                this.parse(statement);
                step = this.factory.Call("__EXEC__");
                this.add(step, tokenArray[0]);
                break;
            }
            case 605: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                boolean bl = false;
                StringBuffer stringBuffer = new StringBuffer();
                LinkedList<PLiteral.Fragment> linkedList = new LinkedList<PLiteral.Fragment>();
                StringIterator stringIterator = new StringIterator(ParserUtilities.extract(stringArray[0]), tokenArray[0].getHint());
                while (stringIterator.hasNext()) {
                    char c = stringIterator.next();
                    if (c == '\\' && stringIterator.hasNext()) {
                        c = stringIterator.next();
                        String string = c + "";
                        if (escape_constants.containsKey(string)) {
                            stringBuffer.append(escape_constants.get(string));
                        } else if (c == 'u') {
                            if (!stringIterator.hasNext(4)) {
                                this.parser.reportErrorWithMarker("not enough remaining characters for \\uXXXX", stringIterator.getErrorToken());
                            } else {
                                string = stringIterator.next(4);
                                try {
                                    int n = Integer.parseInt(string, 16);
                                    stringBuffer.append((char)n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.parser.reportErrorWithMarker("invalid unicode escape \\u" + string + " - must be hex digits", stringIterator.getErrorToken());
                                }
                            }
                        } else if (c == 'x') {
                            if (!stringIterator.hasNext(2)) {
                                this.parser.reportErrorWithMarker("not enough remaining characters for \\xXX", stringIterator.getErrorToken());
                            } else {
                                string = stringIterator.next(2);
                                try {
                                    int n = Integer.parseInt(string, 16);
                                    stringBuffer.append((char)n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.parser.reportErrorWithMarker("invalid unicode escape \\x" + string + " - must be hex digits", stringIterator.getErrorToken());
                                }
                            }
                        } else {
                            stringBuffer.append(c);
                        }
                    } else if (c == ' ' && stringIterator.isNextString("$+ ")) {
                        stringIterator.skip(3);
                    } else if (c == '$' && stringIterator.isNextChar('+')) {
                        this.parser.reportErrorWithMarker("operator $+ must be surrounded with whitespace", stringIterator.getErrorToken());
                    } else if (bl && (Checkers.isEndOfVar(stringIterator.peek()) || !stringIterator.hasNext())) {
                        String string;
                        stringBuffer.append(c);
                        String[] stringArray2 = LexicalAnalyzer.CreateTerms(this.parser, new StringIterator(stringBuffer.toString(), stringIterator.getLineNumber())).getStrings();
                        if (stringArray2.length == 3) {
                            string = stringArray2[0] + stringArray2[2];
                            String string2 = ParserUtilities.extract(stringArray2[1]);
                            if (string2.length() > 0) {
                                this.parseIdea(new Token(string2, stringIterator.getLineNumber()));
                                linkedList.add(PLiteral.fragment(2, null));
                            } else {
                                this.parser.reportErrorWithMarker("Empty alignment specification for " + string, stringIterator.getErrorToken());
                            }
                        } else {
                            string = stringBuffer.toString();
                        }
                        this.parseIdea(new Token(string, stringIterator.getLineNumber()));
                        linkedList.add(PLiteral.fragment(3, null));
                        bl = false;
                        stringBuffer = new StringBuffer();
                    } else if (c == '$' && !Checkers.isEndOfVar(stringIterator.peek()) && stringIterator.hasNext()) {
                        linkedList.add(PLiteral.fragment(1, stringBuffer.toString()));
                        stringBuffer = new StringBuffer();
                        stringBuffer.append('$');
                        bl = true;
                        if (stringIterator.isNextChar('[')) {
                            int n = 0;
                            do {
                                if ((c = stringIterator.next()) == '[') {
                                    ++n;
                                }
                                if (c == ']') {
                                    --n;
                                }
                                stringBuffer.append(c);
                            } while (stringIterator.hasNext() && n > 0);
                            if (n != 0) {
                                this.parser.reportError("missing close brace for variable alignment", new Token(stringBuffer.toString(), stringIterator.getLineNumber()));
                                bl = false;
                            } else if (!stringIterator.hasNext() || Checkers.isEndOfVar(stringIterator.peek())) {
                                this.parser.reportErrorWithMarker("can not align an empty variable", stringIterator.getErrorToken());
                                bl = false;
                            }
                        }
                    } else {
                        stringBuffer.append(c);
                    }
                    if (stringIterator.hasNext() || stringBuffer.length() <= 0) continue;
                    linkedList.add(PLiteral.fragment(1, stringBuffer.toString()));
                }
                step = this.factory.PLiteral(linkedList);
                this.add(step, tokenArray[0]);
                break;
            }
            case 901: {
                String string = stringArray[0].substring(0, stringArray[0].length() - 2);
                this.parseBlock(new Token(string + " = " + string + " + 1;", tokenArray[0].getHint()));
                break;
            }
            case 902: {
                String string = stringArray[0].substring(0, stringArray[0].length() - 2);
                this.parseBlock(new Token(string + " = " + string + " - 1;", tokenArray[0].getHint()));
                break;
            }
            case 504: {
                this.backup();
                this.parseBlock(tokenArray[2]);
                Step step = this.factory.BindPredicate(stringArray[0], this.parsePredicate(ParserUtilities.extract(tokenArray[1])), this.restore());
                this.add(step, tokenArray[0]);
                break;
            }
            case 505: {
                this.backup();
                this.parseBlock(tokenArray[3]);
                Block block = this.restore();
                Step step = this.factory.BindFilter(stringArray[0], stringArray[1], block, stringArray[2]);
                this.add(step, tokenArray[0]);
                break;
            }
            case 502: {
                this.backup();
                if (Checkers.isString(stringArray[1]) || Checkers.isLiteral(stringArray[1])) {
                    this.parseIdea(tokenArray[1]);
                } else {
                    this.parseIdea(new Token("'" + stringArray[1] + "'", tokenArray[1].getHint()));
                }
                Block block = this.restore();
                this.backup();
                this.parseBlock(tokenArray[2]);
                Step step = this.factory.Bind(stringArray[0], block, this.restore());
                this.add(step, tokenArray[0]);
                break;
            }
            case 403: {
                this.backup();
                this.parseBlock(ParserUtilities.extract(tokenArray[1]));
                Step step = this.factory.PopTry();
                this.add(step, tokenArray[4]);
                Block block = this.restore();
                this.backup();
                step = this.factory.PopTry();
                this.add(step, tokenArray[4]);
                this.parseBlock(ParserUtilities.extract(tokenArray[4]));
                Block block2 = this.restore();
                step = this.factory.Try(block, block2, stringArray[3]);
                this.add(step, tokenArray[0]);
                break;
            }
            case 150: {
                this.parseBlock(ParserUtilities.extract(tokenArray[0]));
                break;
            }
            case 613: {
                this.backup();
                this.parseBlock(ParserUtilities.extract(tokenArray[0]));
                Step step = this.factory.CreateClosure(this.restore());
                this.add(step, tokenArray[0]);
                break;
            }
            case 604: {
                TokenList tokenList = LexicalAnalyzer.CreateTerms(this.parser, new StringIterator(stringArray[0], tokenArray[0].getHint()));
                stringArray = tokenList.getStrings();
                tokenArray = tokenList.getTokens();
                if (stringArray[0].charAt(0) != '&') {
                    stringArray[0] = '&' + stringArray[0];
                }
                if ((stringArray[0].equals("&iff") || stringArray[0].equals("&?")) && tokenArray.length > 1) {
                    TokenList tokenList2 = ParserUtilities.groupByParameterTerm(this.parser, ParserUtilities.extract(tokenArray[1]));
                    Token[] tokenArray2 = tokenList2.getTokens();
                    this.backup();
                    if (tokenArray2.length >= 2) {
                        this.parseIdea(tokenArray2[1]);
                    } else {
                        this.parseIdea(tokenArray2[0].copy("true"));
                    }
                    Block block = this.restore();
                    this.backup();
                    if (tokenArray2.length == 3) {
                        this.parseIdea(tokenArray2[2]);
                    } else {
                        this.parseIdea(tokenArray2[0].copy("false"));
                    }
                    Block block3 = this.restore();
                    Step step = this.factory.Decide(this.parsePredicate(tokenArray2[0]), block, block3);
                    this.add(step, tokenArray[0]);
                    break;
                }
                if (tokenArray.length > 1) {
                    Step step = this.factory.CreateFrame();
                    this.add(step, tokenArray[0]);
                    if (stringArray[0].equals("&warn")) {
                        step = this.factory.SValue(SleepUtils.getScalar(tokenArray[0].getHint()));
                        this.add(step, tokenArray[0]);
                    }
                    this.parseParameters(ParserUtilities.extract(tokenArray[1]));
                    step = this.factory.Call(stringArray[0]);
                    this.add(step, tokenArray[0]);
                    break;
                }
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                step = this.factory.SValue(SleepUtils.getScalar(stringArray[0]));
                this.add(step, tokenArray[0]);
                step = this.factory.Call("function");
                this.add(step, tokenArray[0]);
                break;
            }
            case 100: {
                this.backup();
                this.parseBlock(tokenArray[2]);
                Step step = this.factory.Goto(this.parsePredicate(ParserUtilities.extract(tokenArray[1])), this.restore(), null);
                this.add(step, tokenArray[1]);
                break;
            }
            case 101: {
                this.backup();
                this.parseBlock(tokenArray[3]);
                Block block = this.restore();
                this.backup();
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[2]);
                this.parseIdea(tokenArray[2]);
                this.backup();
                this.parseIdea(tokenArray[1]);
                step = this.factory.Assign(this.restore());
                this.add(step, tokenArray[2]);
                this.add(this.factory.SValue(SleepUtils.getEmptyScalar()), tokenArray[2]);
                Block block4 = this.restore();
                Check check = this.factory.Check("!is", block4);
                check.setInfo(tokenArray[1].getHint());
                step = this.factory.Goto(check, block, null);
                this.add(step, tokenArray[1]);
                break;
            }
            case 202: 
            case 204: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                TokenList tokenList = ParserUtilities.groupByParameterTerm(this.parser, ParserUtilities.extract(tokenArray[0]));
                Token[] tokenArray3 = tokenList.getTokens();
                for (int i = 0; i < tokenArray3.length; ++i) {
                    this.parseIdea(tokenArray3[i]);
                }
                this.parseIdea(tokenArray[2]);
                step = statement.getType() == 204 ? this.factory.AssignTupleAndOperate(stringArray[1].substring(0, stringArray[1].length() - 1)) : this.factory.AssignT();
                this.add(step, tokenArray[0]);
                break;
            }
            case 200: 
            case 203: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[2]);
                this.parseIdea(tokenArray[2]);
                this.backup();
                this.parseIdea(tokenArray[0]);
                step = statement.getType() == 203 ? this.factory.AssignAndOperate(this.restore(), stringArray[1].substring(0, stringArray[1].length() - 1)) : this.factory.Assign(this.restore());
                this.add(step, tokenArray[2]);
                break;
            }
            case 301: {
                this.backup();
                this.parseBlock(tokenArray[2]);
                Block block = this.restore();
                this.backup();
                if (tokenArray.length >= 4) {
                    if (stringArray[4].equals("if")) {
                        this.parseBlock(ParserUtilities.join(ParserUtilities.get(tokenArray, 4, tokenArray.length)));
                    } else {
                        this.parseBlock(tokenArray[4]);
                    }
                }
                Block block5 = this.restore();
                Step step = this.factory.Decide(this.parsePredicate(ParserUtilities.extract(tokenArray[1])), block, block5);
                this.add(step, tokenArray[1]);
                break;
            }
            case 400: 
            case 402: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                if (statement.getType() == 400) {
                    this.parseIdea(ParserUtilities.extract(tokenArray[2]));
                    step = this.factory.IteratorCreate(null, stringArray[1]);
                } else {
                    this.parseIdea(ParserUtilities.extract(tokenArray[4]));
                    step = this.factory.IteratorCreate(stringArray[1], stringArray[3]);
                }
                this.add(step, tokenArray[0]);
                this.backup();
                if (statement.getType() == 400) {
                    this.parseBlock(ParserUtilities.extract(tokenArray[3]));
                } else {
                    this.parseBlock(ParserUtilities.extract(tokenArray[5]));
                }
                Block block = this.restore();
                this.backup();
                step = this.factory.IteratorNext();
                this.add(step, tokenArray[0]);
                Check check = this.factory.Check("-istrue", this.restore());
                check.setInfo(tokenArray[0].getHint());
                step = this.factory.Goto(check, block, null);
                this.add(step, tokenArray[1]);
                step = this.factory.IteratorDestroy();
                this.add(step, tokenArray[1]);
                break;
            }
            case 401: {
                Block block;
                Token[] tokenArray4 = ParserUtilities.groupByBlockTerm(this.parser, ParserUtilities.extract(tokenArray[1])).getTokens();
                StringBuffer stringBuffer = new StringBuffer();
                TokenList tokenList = ParserUtilities.groupByParameterTerm(this.parser, tokenArray4[0]);
                Iterator iterator = tokenList.getList().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next().toString());
                    stringBuffer.append("; ");
                }
                this.parseBlock(tokenArray[0].copy(stringBuffer.toString()));
                if (tokenArray4.length == 3) {
                    this.backup();
                    stringBuffer = new StringBuffer();
                    TokenList tokenList3 = ParserUtilities.groupByParameterTerm(this.parser, tokenArray4[2]);
                    iterator = tokenList3.getList().iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append(iterator.next().toString());
                        stringBuffer.append("; ");
                    }
                    this.parseBlock(tokenArray[0].copy(stringBuffer.toString()));
                    block = this.restore();
                } else {
                    block = null;
                    stringBuffer = new StringBuffer();
                }
                this.backup();
                this.parseBlock(tokenArray[2]);
                this.parseBlock(tokenArray[0].copy(stringBuffer.toString()));
                Block block6 = this.restore();
                Step step = this.factory.Goto(this.parsePredicate(tokenArray4[1]), block6, block);
                this.add(step, tokenArray[1]);
                break;
            }
            case 444: {
                try {
                    if (stringArray.length == 1) {
                        this.parser.importPackage(stringArray[0], null);
                        break;
                    }
                    if (Checkers.isString(stringArray[1]) || Checkers.isLiteral(stringArray[1])) {
                        stringArray[1] = ParserUtilities.extract(stringArray[1]);
                    }
                    this.parser.importPackage(stringArray[0], stringArray[1]);
                }
                catch (Exception exception) {
                    if (tokenArray.length == 2) {
                        this.parser.reportError(exception.getMessage(), ParserUtilities.makeToken("import " + stringArray[0] + " from: " + stringArray[1], tokenArray[1]));
                        break;
                    }
                    this.parser.reportError(exception.getMessage(), ParserUtilities.makeToken("import " + stringArray[0], tokenArray[0]));
                }
                break;
            }
            case 507: {
                if (tokenArray.length == 1) {
                    this.parser.reportError("Assertion can't be empty!", tokenArray[0]);
                    return;
                }
                if (Boolean.valueOf(System.getProperty("sleep.assert", "true")) == Boolean.FALSE) {
                    return;
                }
                Token[] tokenArray5 = ParserUtilities.groupByMessageTerm(this.parser, tokenArray[1]).getTokens();
                this.backup();
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                if (tokenArray5.length == 1) {
                    Scalar scalar = SleepUtils.getScalar("assertion failed");
                    step = this.factory.SValue(scalar);
                    this.add(step, tokenArray[0]);
                } else {
                    this.parseIdea(tokenArray5[1]);
                }
                step = this.factory.Call("&exit");
                this.add(step, tokenArray[0]);
                Block block = this.restore();
                step = this.factory.Decide(this.parsePredicate(tokenArray5[0]), null, block);
                this.add(step, tokenArray[1]);
                break;
            }
            case 500: {
                Step step = this.factory.CreateFrame();
                this.add(step, tokenArray[0]);
                if (stringArray[0].equals("done")) {
                    this.parseIdea(tokenArray[0].copy("1"));
                } else if (stringArray[0].equals("halt")) {
                    this.parseIdea(tokenArray[0].copy("2"));
                } else if (tokenArray.length >= 2) {
                    this.parseIdea(tokenArray[1]);
                } else {
                    this.parseIdea(tokenArray[0].copy("$null"));
                }
                if (stringArray[0].equals("break")) {
                    step = this.factory.Return(2);
                    this.add(step, tokenArray[0]);
                    break;
                }
                if (stringArray[0].equals("continue")) {
                    step = this.factory.Return(4);
                    this.add(step, tokenArray[0]);
                    break;
                }
                if (stringArray[0].equals("throw")) {
                    step = this.factory.Return(16);
                    this.add(step, tokenArray[0]);
                    break;
                }
                if (stringArray[0].equals("yield")) {
                    step = this.factory.Return(8);
                    this.add(step, tokenArray[0]);
                    break;
                }
                if (stringArray[0].equals("callcc")) {
                    step = this.factory.Return(72);
                    this.add(step, tokenArray[0]);
                    break;
                }
                step = this.factory.Return(1);
                this.add(step, tokenArray[0]);
                break;
            }
        }
    }

    public void parseParameters(Token token) {
        TokenList tokenList = ParserUtilities.groupByParameterTerm(this.parser, token);
        Token[] tokenArray = tokenList.getTokens();
        for (int i = tokenArray.length - 1; i >= 0; --i) {
            this.parseIdea(tokenArray[i]);
        }
    }

    static {
        CodeGenerator.installEscapeConstant('t', "\t");
        CodeGenerator.installEscapeConstant('n', "\n");
        CodeGenerator.installEscapeConstant('r', "\r");
    }
}

