/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.util.LinkedList;
import sleep.parser.Checkers;
import sleep.parser.LexicalAnalyzer;
import sleep.parser.Parser;
import sleep.parser.ParserConstants;
import sleep.parser.ParserUtilities;
import sleep.parser.Statement;
import sleep.parser.StringIterator;
import sleep.parser.Token;
import sleep.parser.TokenList;

public class TokenParser
implements ParserConstants {
    public static Statement ParseObject(Parser parser, TokenList tokenList) {
        Token[] tokenArray = tokenList.getTokens();
        String[] stringArray = tokenList.getStrings();
        Statement statement = new Statement();
        int n = 0;
        if (tokenArray.length < 1) {
            parser.reportError("Object Access: expression is empty", new Token(tokenList.toString(), tokenArray[0].getHint()));
            return null;
        }
        if (stringArray.length >= 2 && stringArray[1].equals(".")) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < tokenArray.length - 1 && stringArray[n2 + 1].equals("."); n2 += 2) {
                stringBuffer.append(stringArray[n2]);
                stringBuffer.append(".");
            }
            if (n2 < tokenArray.length) {
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
            Token token = tokenArray[0].copy(stringBuffer.toString());
            TokenList tokenList2 = new TokenList();
            tokenList2.add(token);
            while (n2 < tokenArray.length) {
                tokenList2.add(tokenArray[n2]);
                ++n2;
            }
            return TokenParser.ParseObject(parser, tokenList2);
        }
        if (stringArray.length >= 3 && stringArray[2].equals(".")) {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            TokenList tokenList3 = new TokenList();
            tokenList3.add(tokenArray[0]);
            for (n3 = 1; n3 < tokenArray.length - 1 && stringArray[n3 + 1].equals("."); n3 += 2) {
                stringBuffer.append(stringArray[n3]);
                stringBuffer.append(".");
            }
            if (n3 < tokenArray.length) {
                stringBuffer.append(stringArray[n3]);
                ++n3;
            }
            Token token = tokenArray[1].copy(stringBuffer.toString());
            tokenList3.add(token);
            while (n3 < tokenArray.length) {
                tokenList3.add(tokenArray[n3]);
                ++n3;
            }
            return TokenParser.ParseObject(parser, tokenList3);
        }
        if (stringArray.length == 1) {
            statement.setType(446);
            statement.add(tokenArray[0]);
            n = 1;
        } else if (stringArray.length >= 2 && Checkers.isClosureCall(stringArray[0], stringArray[1])) {
            statement.setType(446);
            statement.add(tokenArray[0]);
            n = 1;
        } else if (stringArray.length >= 2 && Checkers.isObjectNew(stringArray[0], stringArray[1])) {
            statement.setType(441);
            statement.add(tokenArray[1]);
            n = 2;
        } else if (stringArray.length >= 2 && Checkers.isClassIdentifier(parser, stringArray[0])) {
            statement.setType(443);
            statement.add(tokenArray[0]);
            statement.add(tokenArray[1]);
            n = 2;
        } else {
            statement.setType(442);
            statement.add(tokenArray[0]);
            statement.add(tokenArray[1]);
            n = 2;
        }
        if (n >= tokenArray.length) {
            return statement;
        }
        if (!stringArray[n].equals("EOT")) {
            parser.reportError("Object Access: parameter separator is :", new Token(tokenList.toString(), tokenArray[0].getHint()));
            return null;
        }
        if (n + 1 >= tokenArray.length) {
            parser.reportError("Object Access: can not specify empty arg list after :", new Token("[" + tokenList.toString().substring(0, tokenList.toString().length() - 4) + ":<null>]", tokenArray[0].getHint()));
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[++n]);
        ++n;
        while (n < tokenArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        statement.add(new Token(stringBuffer.toString(), tokenArray[n - 1].getHint()));
        return statement;
    }

    public static Statement ParsePredicate(Parser parser, TokenList tokenList) {
        int n;
        Token[] tokenArray = tokenList.getTokens();
        String[] stringArray = tokenList.getStrings();
        Statement statement = new Statement();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        if (tokenArray.length >= 3 && Checkers.isUniPredicate(stringArray[n2], stringArray[n2 + 1]) && Checkers.isIndexableItem(stringArray[n2 + 1], stringArray[n2 + 2])) {
            statement.add(tokenArray[n2]);
            statement.add(ParserUtilities.makeToken(stringArray[++n2] + stringArray[n2 + 1], tokenArray[0]));
            n2 += 2;
            while (n2 < tokenArray.length) {
                statement.add(tokenArray[n2]);
                ++n2;
            }
            return TokenParser.ParsePredicate(parser, statement);
        }
        if (tokenArray.length == 3) {
            bl = Checkers.isOrPredicate(stringArray[n2], stringArray[n2 + 1], stringArray[n2 + 2]);
            bl2 = Checkers.isAndPredicate(stringArray[n2], stringArray[n2 + 1], stringArray[n2 + 2]);
        } else if (2 < tokenArray.length && (n = TokenParser.findPrecedentOperators(statement, tokenList, 0, "&& ||", 2)) != 0) {
            return TokenParser.ParsePredicate(parser, statement);
        }
        if (n2 + 2 < tokenArray.length && (bl || bl2)) {
            if (bl) {
                statement.setType(803);
            }
            if (bl2) {
                statement.setType(804);
            }
            statement.add(tokenArray[n2]);
            statement.add(tokenArray[n2 + 1]);
            n2 += 2;
        } else if (n2 + 2 < tokenArray.length && Checkers.isBiPredicate(stringArray[n2], stringArray[n2 + 1], stringArray[n2 + 2])) {
            statement.setType(801);
            statement.add(tokenArray[n2]);
            statement.add(tokenArray[n2 + 1]);
            n2 += 2;
        } else if (n2 + 1 < tokenArray.length && Checkers.isUniPredicate(stringArray[n2], stringArray[n2 + 1])) {
            statement.setType(802);
            statement.add(tokenArray[n2]);
            ++n2;
        } else if (Checkers.isExpression(stringArray[n2])) {
            statement.setType(805);
        } else {
            statement.setType(806);
        }
        if (n2 < tokenArray.length) {
            StringBuffer stringBuffer = new StringBuffer(stringArray[n2]);
            ++n2;
            while (n2 < tokenArray.length) {
                stringBuffer.append(" ");
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
            statement.add(new Token(stringBuffer.toString(), tokenArray[n2 - 1].getHint()));
        }
        return statement;
    }

    protected static int findPrecedentOperators(Statement statement, TokenList tokenList, int n, String string, int n2) {
        String[] stringArray = tokenList.getStrings();
        Token[] tokenArray = tokenList.getTokens();
        for (int i = n; i < tokenArray.length; ++i) {
            int n3;
            if (stringArray[i].equals("EOT")) {
                return n;
            }
            if (stringArray[i].length() != n2 || string.indexOf(stringArray[i]) <= -1) continue;
            StringBuffer stringBuffer = new StringBuffer(stringArray[n]);
            for (int j = n + 1; j < i; ++j) {
                stringBuffer.append(" ");
                stringBuffer.append(stringArray[j]);
            }
            StringBuffer stringBuffer2 = new StringBuffer(stringArray[i + 1]);
            for (n3 = i + 2; n3 < tokenArray.length && !stringArray[n3].equals("EOT"); ++n3) {
                stringBuffer2.append(" ");
                stringBuffer2.append(stringArray[n3]);
            }
            statement.add(new Token(stringBuffer.toString(), tokenArray[n].getHint()));
            statement.add(tokenArray[i]);
            statement.add(new Token(stringBuffer2.toString(), tokenArray[i + 1].getHint()));
            return n3;
        }
        return n;
    }

    public static LinkedList ParseIdea(Parser parser, TokenList tokenList) {
        Token[] tokenArray = tokenList.getTokens();
        String[] stringArray = tokenList.getStrings();
        LinkedList<Statement> linkedList = new LinkedList<Statement>();
        for (int i = 0; i < tokenArray.length; ++i) {
            int n;
            Statement statement = new Statement();
            if (i + 2 < tokenArray.length && Checkers.isOperator(stringArray[i], stringArray[i + 1], stringArray[i + 2])) {
                statement.setType(603);
                int n2 = TokenParser.findPrecedentOperators(statement, tokenList, i, "=>", 2);
                if (n2 != i) {
                    statement.setType(612);
                    i = n2;
                } else {
                    n2 = TokenParser.findPrecedentOperators(statement, tokenList, i, "+ - .", 1);
                    if (n2 == i) {
                        statement.add(tokenArray[i]);
                        statement.add(tokenArray[i + 1]);
                        n = tokenArray[i + 2].getHint();
                        StringBuffer stringBuffer = new StringBuffer(stringArray[i + 2]);
                        i += 3;
                        while (i < tokenArray.length && !stringArray[i].equals("EOT")) {
                            stringBuffer.append(" ");
                            stringBuffer.append(stringArray[i]);
                            ++i;
                        }
                        statement.add(new Token(stringBuffer.toString(), n));
                    } else {
                        i = n2;
                    }
                }
            } else if (Checkers.isIndexableItem(stringArray[i])) {
                statement.setType(710);
                Token[] tokenArray2 = LexicalAnalyzer.CreateTerms(parser, new StringIterator(stringArray[i], tokenArray[i].getHint())).getTokens();
                n = 0;
                if (n + 1 < tokenArray2.length && Checkers.isFunctionCall(tokenArray2[0].toString(), tokenArray2[1].toString())) {
                    statement.add(ParserUtilities.combineTokens(tokenArray2[0], tokenArray2[1]));
                    n += 2;
                }
                while (n < tokenArray2.length) {
                    statement.add(tokenArray2[n]);
                    ++n;
                }
            } else if (Checkers.isIndex(stringArray[i])) {
                statement.setType(611);
                statement.add(tokenArray[i]);
            } else if (Checkers.isFunctionCall(stringArray[i])) {
                statement.setType(604);
                statement.add(tokenArray[i]);
            } else if (Checkers.isIncrementHack(stringArray[i])) {
                statement.setType(901);
                statement.add(tokenArray[i]);
            } else if (Checkers.isDecrementHack(stringArray[i])) {
                statement.setType(902);
                statement.add(tokenArray[i]);
            } else if (Checkers.isVariableReference(stringArray[i])) {
                statement.setType(705);
                statement.add(tokenArray[i]);
            } else if (Checkers.isVariable(stringArray[i])) {
                statement.setType(701);
                statement.add(tokenArray[i]);
            } else if (Checkers.isExpression(stringArray[i])) {
                statement.setType(601);
                statement.add(tokenArray[i]);
            } else if (Checkers.isFunction(stringArray[i]) && Checkers.isFunctionReferenceToken(stringArray[i])) {
                statement.setType(604);
                statement.add(tokenArray[i]);
            } else if (Checkers.isString(stringArray[i])) {
                statement.setType(605);
                statement.add(tokenArray[i]);
            } else if (Checkers.isBacktick(stringArray[i])) {
                statement.setType(506);
                statement.add(tokenArray[i]);
            } else if (Checkers.isLiteral(stringArray[i])) {
                statement.setType(606);
                statement.add(tokenArray[i]);
            } else if (Checkers.isNumber(stringArray[i])) {
                statement.setType(607);
                statement.add(tokenArray[i]);
            } else if (Checkers.isDouble(stringArray[i])) {
                statement.setType(608);
                statement.add(tokenArray[i]);
            } else if (Checkers.isBoolean(stringArray[i])) {
                statement.setType(609);
                statement.add(tokenArray[i]);
            } else if (Checkers.isBlock(stringArray[i])) {
                statement.setType(613);
                statement.add(tokenArray[i]);
            } else if (Checkers.isClassLiteral(stringArray[i])) {
                statement.setType(614);
                statement.add(tokenArray[i]);
            } else {
                parser.reportError("Unknown expression", new Token(tokenList.toString(), tokenArray[i].getHint()));
                return null;
            }
            linkedList.add(statement);
        }
        return linkedList;
    }

    public static LinkedList ParseBlocks(Parser parser, TokenList tokenList) {
        String[] stringArray = tokenList.getStrings();
        Token[] tokenArray = tokenList.getTokens();
        LinkedList<Statement> linkedList = new LinkedList<Statement>();
        for (int i = 0; i < tokenArray.length; ++i) {
            int n;
            Object object;
            Statement statement = new Statement();
            if (i + 5 < tokenArray.length && Checkers.isSpecialForeach(stringArray[i], stringArray[i + 1], stringArray[i + 2], stringArray[i + 3], stringArray[i + 4], stringArray[i + 5])) {
                statement.setType(402);
                statement.add(tokenArray[i]);
                statement.add(tokenArray[i + 1]);
                statement.add(tokenArray[i + 2]);
                statement.add(tokenArray[i + 3]);
                statement.add(tokenArray[i + 4]);
                statement.add(tokenArray[i + 5]);
                i += 5;
            } else if (i + 4 < tokenArray.length && Checkers.isTryCatch(stringArray[i], stringArray[i + 1], stringArray[i + 2], stringArray[i + 3], stringArray[i + 4])) {
                statement.setType(403);
                statement.add(tokenArray[i]);
                statement.add(tokenArray[i + 1]);
                statement.add(tokenArray[i + 2]);
                statement.add(tokenArray[i + 3]);
                statement.add(tokenArray[i + 4]);
                i += 4;
            } else if (i + 3 < tokenArray.length && Checkers.isSpecialWhile(stringArray[i], stringArray[i + 1], stringArray[i + 2], stringArray[i + 3])) {
                statement.setType(101);
                statement.add(tokenArray[i]);
                statement.add(tokenArray[i + 1]);
                statement.add(tokenArray[i + 2]);
                statement.add(tokenArray[i + 3]);
                i += 3;
            } else if (i + 3 < tokenArray.length && Checkers.isForeach(stringArray[i], stringArray[i + 1], stringArray[i + 2], stringArray[i + 3])) {
                statement.setType(400);
                statement.add(tokenArray[i]);
                statement.add(tokenArray[i + 1]);
                statement.add(tokenArray[i + 2]);
                statement.add(tokenArray[i + 3]);
                i += 3;
            } else if (i + 2 < tokenArray.length && Checkers.isIfStatement(stringArray[i], stringArray[i + 1], stringArray[i + 2])) {
                statement.setType(301);
                statement.add(tokenArray[i]);
                statement.add(tokenArray[i + 1]);
                statement.add(tokenArray[i + 2]);
                i += 3;
                while (i + 3 < tokenArray.length && Checkers.isElseIfStatement(stringArray[i], stringArray[i + 1], stringArray[i + 2], stringArray[i + 3])) {
                    statement.add(tokenArray[i]);
                    statement.add(tokenArray[i + 1]);
                    statement.add(tokenArray[i + 2]);
                    statement.add(tokenArray[i + 3]);
                    i += 4;
                }
                if (i + 1 < tokenArray.length && Checkers.isElseStatement(stringArray[i], stringArray[i + 1])) {
                    statement.add(tokenArray[i]);
                    statement.add(tokenArray[i + 1]);
                    i += 2;
                }
                --i;
            } else if (i + 2 < tokenArray.length && Checkers.isWhile(stringArray[i], stringArray[i + 1], stringArray[i + 2])) {
                statement.setType(100);
                statement.add(tokenArray[i]);
                statement.add(tokenArray[i + 1]);
                statement.add(tokenArray[i + 2]);
                i += 2;
            } else if (i + 2 < tokenArray.length && Checkers.isFor(stringArray[i], stringArray[i + 1], stringArray[i + 2])) {
                statement.setType(401);
                statement.add(tokenArray[i]);
                statement.add(tokenArray[i + 1]);
                statement.add(tokenArray[i + 2]);
                i += 2;
            } else if (Checkers.isReturn(stringArray[i]) || Checkers.isAssert(stringArray[i])) {
                if (Checkers.isAssert(stringArray[i])) {
                    statement.setType(507);
                } else {
                    statement.setType(500);
                }
                statement.add(tokenArray[i]);
                object = new StringBuffer();
                if (++i == tokenArray.length) {
                    parser.reportError("Missing terminator", new Token(((StringBuffer)object).toString(), tokenArray[i - 1].getHint(), ((StringBuffer)object).toString().length()));
                    return null;
                }
                n = tokenArray[i].getHint();
                while (i < stringArray.length && !stringArray[i].equals("EOT")) {
                    ((StringBuffer)object).append(stringArray[i]);
                    ((StringBuffer)object).append(" ");
                    if (++i < tokenArray.length) continue;
                    parser.reportError("Missing terminator", new Token(((StringBuffer)object).toString(), tokenArray[i - 1].getHint(), ((StringBuffer)object).toString().length()));
                    return null;
                }
                if (((StringBuffer)object).length() > 0) {
                    statement.add(new Token(((StringBuffer)object).toString(), n));
                }
            } else if (i + 1 < tokenArray.length && Checkers.isImportStatement(stringArray[i], stringArray[i + 1])) {
                statement.setType(444);
                ++i;
                object = new StringBuffer();
                while (i < stringArray.length && !stringArray[i].equals("EOT")) {
                    if (stringArray[i].equals("from:")) {
                        if (((StringBuffer)object).length() == 0) {
                            parser.reportError("Attempted to import '' from:", new Token("import from:", tokenArray[i].getHint(), "import from:".length()));
                            return null;
                        }
                        statement.add(new Token(((StringBuffer)object).toString(), tokenArray[i].getHint()));
                        object = new StringBuffer();
                    } else {
                        ((StringBuffer)object).append(stringArray[i]);
                    }
                    if (++i < tokenArray.length) continue;
                    parser.reportError("Missing terminator", new Token(((StringBuffer)object).toString(), tokenArray[i - 1].getHint(), ((StringBuffer)object).toString().length()));
                    return null;
                }
                if (((StringBuffer)object).length() > 0) {
                    statement.add(new Token(((StringBuffer)object).toString(), tokenArray[i].getHint()));
                }
            } else if (Checkers.isIndex(stringArray[i])) {
                statement.setType(611);
                statement.add(tokenArray[i]);
            } else if (!stringArray[i].equals("EOT")) {
                if (i + 2 < tokenArray.length && Checkers.isBindPredicate(stringArray[i], stringArray[i + 1], stringArray[i + 2])) {
                    statement.setType(504);
                    statement.add(tokenArray[i]);
                    statement.add(tokenArray[i + 1]);
                    statement.add(tokenArray[i + 2]);
                    i += 2;
                } else if (i + 2 < tokenArray.length && Checkers.isBind(stringArray[i], stringArray[i + 1], stringArray[i + 2])) {
                    statement.setType(502);
                    statement.add(tokenArray[i]);
                    statement.add(tokenArray[i + 1]);
                    statement.add(tokenArray[i + 2]);
                    i += 2;
                } else if (Checkers.isIncrementHack(stringArray[i])) {
                    statement.setType(901);
                    statement.add(tokenArray[i]);
                } else if (Checkers.isDecrementHack(stringArray[i])) {
                    statement.setType(902);
                    statement.add(tokenArray[i]);
                } else if (Checkers.isBlock(stringArray[i])) {
                    statement.setType(150);
                    statement.add(tokenArray[i]);
                } else if (Checkers.isBacktick(stringArray[i])) {
                    statement.setType(506);
                    statement.add(tokenArray[i]);
                } else if (Checkers.isFunctionCall(stringArray[i])) {
                    statement.setType(604);
                    statement.add(tokenArray[i]);
                } else if (i + 3 < tokenArray.length && Checkers.isBindFilter(stringArray[i], stringArray[i + 1], stringArray[i + 2], stringArray[i + 3])) {
                    statement.setType(505);
                    statement.add(tokenArray[i]);
                    statement.add(tokenArray[i + 1]);
                    statement.add(tokenArray[i + 2]);
                    statement.add(tokenArray[i + 3]);
                    i += 3;
                } else {
                    int n2 = TokenParser.findPrecedentOperators(statement, tokenList, i, "+= -= *= .= /= %= |= &= ^=", 2);
                    if (n2 != i || (n2 = TokenParser.findPrecedentOperators(statement, tokenList, i, "<<= >>=", 3)) != i) {
                        if (Checkers.isExpression(stringArray[i])) {
                            statement.setType(204);
                        } else {
                            statement.setType(203);
                        }
                        i = n2;
                    } else {
                        n2 = TokenParser.findPrecedentOperators(statement, tokenList, i, "=", 1);
                        if (n2 != i) {
                            if (Checkers.isExpression(stringArray[i])) {
                                statement.setType(202);
                            } else {
                                statement.setType(200);
                            }
                            i = n2;
                        } else {
                            object = new TokenList();
                            for (n = i; n < tokenArray.length && !stringArray[n].equals("EOT") && stringArray[n].indexOf(10) == -1; ++n) {
                                ((TokenList)object).add(tokenArray[n]);
                            }
                            parser.reportError("Syntax error", new Token(((TokenList)object).toString(), tokenArray[i].getHint()));
                            return null;
                        }
                    }
                }
            }
            if (statement.getType() == 0) continue;
            linkedList.add(statement);
        }
        return linkedList;
    }
}

