/*
 * Decompiled with CFR 0.152.
 */
package text;

import rero.util.TokenizedString;
import text.AttributedText;
import text.TextSource;

public class AttributedString {
    public static final char bold = '\u0002';
    public static final char underline = '\u001f';
    public static final char color = '\u0003';
    public static final char cancel = '\u000f';
    public static final char reverse = '\u0016';
    public static final char tab = '\t';
    protected AttributedText attrs;
    protected TokenizedString tokens;
    protected String text;

    public AttributedString(String string, AttributedText attributedText) {
        this(string, attributedText, " ");
    }

    public AttributedString(String string, AttributedText attributedText, String string2) {
        this.text = string;
        this.attrs = attributedText;
        this.tokens = new TokenizedString(this.text, string2);
    }

    public String getText() {
        return this.text;
    }

    public TokenizedString getTokens() {
        return this.tokens;
    }

    public AttributedText getAttributedText() {
        return this.attrs;
    }

    public AttributedText substring(int n, int n2) {
        return this.substring(this.attrs, n, n2);
    }

    public void assignWidths() {
        AttributedText attributedText = this.attrs;
        while (attributedText != null) {
            attributedText.width = TextSource.fontMetrics.stringWidth(attributedText.text);
            attributedText = attributedText.next;
        }
    }

    public AttributedText substring(AttributedText attributedText, int n, int n2) {
        AttributedText attributedText2 = attributedText;
        while (attributedText2 != null) {
            if (n > attributedText2.start && n2 <= attributedText2.end) {
                AttributedText attributedText3 = attributedText2.copyAttributes();
                attributedText3.text = this.text.substring(n, n2);
                attributedText3.width = TextSource.fontMetrics.stringWidth(attributedText3.text);
                return attributedText3;
            }
            if (n <= attributedText2.start && n2 >= attributedText2.end) {
                AttributedText attributedText4 = attributedText2.copyAttributes();
                attributedText4.text = attributedText2.text;
                attributedText4.width = TextSource.fontMetrics.stringWidth(attributedText4.text);
                attributedText4.next = this.substring(attributedText2.next, n, n2);
                return attributedText4;
            }
            if (n <= attributedText2.start && n2 <= attributedText2.end && n2 > attributedText2.start) {
                AttributedText attributedText5 = attributedText2.copyAttributes();
                attributedText5.text = this.text.substring(attributedText2.start, n2);
                attributedText5.width = TextSource.fontMetrics.stringWidth(attributedText5.text);
                return attributedText5;
            }
            if (n > attributedText2.start && n <= attributedText2.end && n2 >= attributedText2.end) {
                AttributedText attributedText6 = attributedText2.copyAttributes();
                attributedText6.text = this.text.substring(n, attributedText2.end);
                attributedText6.width = TextSource.fontMetrics.stringWidth(attributedText6.text);
                attributedText6.next = this.substring(attributedText2.next, n, n2);
                return attributedText6;
            }
            attributedText2 = attributedText2.next;
        }
        return null;
    }

    public static AttributedString CreateAttributedString(String string) {
        return AttributedString.CreateAttributedString(string, " ");
    }

    public static AttributedString CreateAttributedString(String string, String string2) {
        AttributedText attributedText = new AttributedText();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        AttributedText attributedText2 = attributedText;
        char[] cArray = string.toCharArray();
        block8: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\u0002': {
                    if (stringBuffer.length() > 0) {
                        attributedText.text = stringBuffer.toString();
                        attributedText.end = attributedText.start + attributedText.text.length();
                        stringBuffer = new StringBuffer();
                        attributedText.next = attributedText.copyAttributes();
                        attributedText.next.start = attributedText.end;
                        attributedText = attributedText.next;
                    }
                    attributedText.isBold = !attributedText.isBold;
                    continue block8;
                }
                case '\u0003': {
                    int n = attributedText.backIndex;
                    int n2 = attributedText.foreIndex;
                    if (i + 1 < cArray.length && Character.isDigit(cArray[i + 1])) {
                        if (i + 2 < cArray.length && Character.isDigit(cArray[i + 2])) {
                            n2 = Character.digit(cArray[i + 1], 10) * 10 + Character.digit(cArray[i + 2], 10);
                            i += 2;
                        } else {
                            n2 = Character.digit(cArray[i + 1], 10);
                            ++i;
                        }
                        if (i + 2 < cArray.length && cArray[i + 1] == ',' && Character.isDigit(cArray[i + 2])) {
                            if (++i + 2 < cArray.length && Character.isDigit(cArray[i + 2])) {
                                n = Character.digit(cArray[i + 1], 10) * 10 + Character.digit(cArray[i + 2], 10);
                                i += 2;
                            } else {
                                n = Character.digit(cArray[i + 1], 10);
                                ++i;
                            }
                        }
                    }
                    if (n2 == attributedText.foreIndex && n == attributedText.backIndex) continue block8;
                    if (stringBuffer.length() > 0) {
                        attributedText.text = stringBuffer.toString();
                        attributedText.end = attributedText.start + attributedText.text.length();
                        stringBuffer = new StringBuffer();
                        attributedText.next = attributedText.copyAttributes();
                        attributedText.next.start = attributedText.end;
                        attributedText = attributedText.next;
                    }
                    attributedText.foreIndex = n2;
                    attributedText.backIndex = n;
                    continue block8;
                }
                case '\u000f': {
                    if (stringBuffer.length() > 0) {
                        attributedText.text = stringBuffer.toString();
                        attributedText.end = attributedText.start + attributedText.text.length();
                        stringBuffer = new StringBuffer();
                        attributedText.next = new AttributedText().copyAttributes();
                        attributedText.next.foreIndex = attributedText.foreIndex;
                        attributedText.next.start = attributedText.end;
                        attributedText = attributedText.next;
                        continue block8;
                    }
                    attributedText.isBold = false;
                    attributedText.isUnderline = false;
                    attributedText.isReverse = false;
                    attributedText.backIndex = -1;
                    attributedText.foreIndex = 0;
                    continue block8;
                }
                case '\u0016': {
                    if (stringBuffer.length() > 0) {
                        attributedText.text = stringBuffer.toString();
                        attributedText.end = attributedText.start + attributedText.text.length();
                        stringBuffer = new StringBuffer();
                        attributedText.next = attributedText.copyAttributes();
                        attributedText.next.start = attributedText.end;
                        attributedText = attributedText.next;
                    }
                    attributedText.isReverse = !attributedText.isReverse;
                    continue block8;
                }
                case '\u001f': {
                    if (stringBuffer.length() > 0) {
                        attributedText.text = stringBuffer.toString();
                        attributedText.end = attributedText.start + attributedText.text.length();
                        stringBuffer = new StringBuffer();
                        attributedText.next = attributedText.copyAttributes();
                        attributedText.next.start = attributedText.end;
                        attributedText = attributedText.next;
                    }
                    attributedText.isUnderline = !attributedText.isUnderline;
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("   ");
                    stringBuffer2.append("   ");
                    continue block8;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                    stringBuffer2.append(cArray[i]);
                }
            }
        }
        attributedText.text = stringBuffer.toString();
        attributedText.end = attributedText.start + attributedText.text.length();
        return new AttributedString(stringBuffer2.toString(), attributedText2, string2);
    }
}

