/*
 * Decompiled with CFR 0.152.
 */
package text;

import text.TextSource;

public class AttributedText {
    public static int INSTANCES = 0;
    public int foreIndex = 0;
    public int backIndex = -1;
    public boolean isUnderline = false;
    public boolean isBold = false;
    public boolean isReverse = false;
    public int start = 0;
    public int end = 0;
    public int width;
    public AttributedText next;
    public String text;

    public AttributedText() {
        ++INSTANCES;
    }

    public void finalize() {
        --INSTANCES;
    }

    public AttributedText copyAttributes() {
        AttributedText attributedText = new AttributedText();
        attributedText.foreIndex = this.foreIndex;
        attributedText.backIndex = this.backIndex;
        attributedText.isUnderline = this.isUnderline;
        attributedText.isBold = this.isBold;
        attributedText.isReverse = this.isReverse;
        return attributedText;
    }

    public AttributedText cloneAttributedText() {
        AttributedText attributedText = this.copyAttributes();
        attributedText.width = this.width;
        attributedText.text = this.text;
        return attributedText;
    }

    public AttributedText cloneList() {
        AttributedText attributedText;
        AttributedText attributedText2 = attributedText = this.cloneAttributedText();
        AttributedText attributedText3 = this.next;
        while (attributedText3 != null) {
            attributedText2 = attributedText2.next = attributedText3.cloneAttributedText();
            attributedText3 = attributedText3.next;
        }
        return attributedText;
    }

    public void setIndent() {
        this.start = Integer.MAX_VALUE;
        this.end = Integer.MIN_VALUE;
    }

    public boolean isIndent() {
        return this.start == Integer.MAX_VALUE && this.end == Integer.MIN_VALUE;
    }

    public int getWidth() {
        int n = 0;
        AttributedText attributedText = this;
        while (attributedText != null) {
            n += attributedText.width;
            attributedText = attributedText.next;
        }
        return n;
    }

    public AttributedText getAttributesAt(int n) {
        if (n < this.width) {
            return this;
        }
        if (this.next != null) {
            return this.next.getAttributesAt(n - this.width);
        }
        return null;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        AttributedText attributedText = this;
        while (attributedText != null) {
            stringBuffer.append(attributedText.text);
            attributedText = attributedText.next;
        }
        return stringBuffer.toString();
    }

    private static int findIndex(String string, int n, int n2, int n3) {
        int n4 = n2 + 1;
        int n5 = 0;
        while (n4 + n4 < string.length() && n5 < n) {
            n4 += n4;
            n5 = TextSource.fontMetrics.stringWidth(string.substring(0, n4)) + n3;
        }
        n4 /= 2;
        n5 = 0;
        while (n4 < string.length() && n5 < n) {
            n5 = TextSource.fontMetrics.stringWidth(string.substring(0, n4)) + n3;
            ++n4;
        }
        return n4 - 1;
    }

    public String getRange(int n, int n2) {
        AttributedText attributedText = this;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (attributedText != null) {
            int n4;
            int n5 = n3;
            int n6 = n3 + attributedText.width;
            if (n > n5 && n2 <= n6) {
                n4 = AttributedText.findIndex(attributedText.text, n, 0, n3);
                int n7 = AttributedText.findIndex(attributedText.text, n2, n4, n3);
                return attributedText.text.substring(n4, n7);
            }
            if (n <= n5 && n2 >= n6) {
                stringBuffer.append(attributedText.text);
            } else if (n <= n5 && n2 <= n6 && n2 > n) {
                n4 = AttributedText.findIndex(attributedText.text, n2, 0, n3);
                if (n4 > 1) {
                    stringBuffer.append(attributedText.text.substring(0, n4));
                }
            } else if (n > n5 && n <= n6 && n2 >= n6) {
                n4 = AttributedText.findIndex(attributedText.text, n2, 0, n3);
                stringBuffer.append(attributedText.text.substring(n4, attributedText.text.length()));
            }
            n3 += attributedText.width;
            attributedText = attributedText.next;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "";
        if (this.isBold) {
            string = string + "B";
        }
        if (this.isUnderline) {
            string = string + "U";
        }
        if (this.isReverse) {
            string = string + "R";
        }
        String string2 = "|";
        if (this.next != null) {
            string2 = this.next.toString();
        }
        if (this.start == 0 && this.end == 0) {
            return "[\"" + this.text + "\"," + this.width + "px:" + string + ":" + this.foreIndex + "," + this.backIndex + "]->" + string2;
        }
        return "[\"" + this.text + "\"," + this.start + "-" + this.end + ":" + string + ":" + this.foreIndex + "," + this.backIndex + "]->" + string2;
    }
}

