/*
 * Decompiled with CFR 0.152.
 */
package text.list;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import text.TextSource;
import text.list.ListData;
import text.list.ListElement;

public class ListDisplayComponent
extends JComponent
implements ChangeListener,
ClientStateListener {
    protected ListData data;
    protected String test_string = "";
    private static final String widthstring = "1234567890123456789012345678901234567890123456789012345678901234567890";

    public ListDisplayComponent() {
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        ClientState.getClientState().addClientStateListener("listbox.width", this);
        this.propertyChanged(null, null);
    }

    public void installDataSource(ListData listData) {
        this.data = listData;
    }

    public void propertyChanged(String string, String string2) {
        this.test_string = widthstring.substring(0, ClientState.getClientState().getInteger("listbox.width", 10));
        this.revalidate();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.repaint();
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = TextSource.fontMetrics;
        return new Dimension(fontMetrics.stringWidth(this.test_string) + 2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        TextSource.initGraphics(graphics);
        this.data.setExtent(this.getHeight() / (TextSource.fontMetrics.getHeight() + 2));
        int n = graphics.getClipBounds().y - 10;
        int n2 = n + graphics.getClipBounds().height + 20;
        int n3 = super.getWidth();
        int n4 = super.getHeight();
        graphics.setFont(TextSource.clientFont);
        Object object = this.data.getSynchronizationKeyOuter();
        synchronized (object) {
            Object object2 = this.data.getSynchronizationKeyInner();
            synchronized (object2) {
                ListElement listElement = this.data.head();
                for (int i = TextSource.fontMetrics.getHeight() - 2; listElement != null && i < n4; i += TextSource.fontMetrics.getHeight() + 2) {
                    if (i <= n2 && i >= n) {
                        if (listElement.isSelected()) {
                            graphics.setColor(UIManager.getColor("TextField.selectionBackground"));
                            int n5 = TextSource.fontMetrics.getHeight();
                            graphics.fillRect(0, i - n5 + 2, n3, n5 + 2);
                        }
                        TextSource.drawText(graphics, listElement.getAttributedText(), 2, i);
                    }
                    listElement = this.data.next();
                }
            }
        }
    }
}

