/*
 * Decompiled with CFR 0.152.
 */
package text.list;

import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.event.MouseInputAdapter;
import text.ListDisplay;
import text.TextSource;
import text.list.ListData;
import text.list.ListElement;

public class ListSelectionSpace
extends MouseInputAdapter {
    protected ListData data;
    protected ListDisplay display;
    protected int start;

    public ListSelectionSpace(ListDisplay listDisplay, ListData listData) {
        this.data = listData;
        this.display = listDisplay;
    }

    public void clearSelections() {
        Iterator iterator = this.data.dataIterator();
        while (iterator.hasNext()) {
            ListElement listElement = (ListElement)iterator.next();
            listElement.setSelected(false);
        }
    }

    public ListElement getSelectedElement() {
        ListElement listElement = this.data.getElementAtLocation(this.start);
        if (listElement != null && listElement.isSelected()) {
            return listElement;
        }
        return null;
    }

    public LinkedList getSelectedElements() {
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        Iterator iterator = this.data.dataIterator();
        while (iterator.hasNext()) {
            ListElement listElement = (ListElement)iterator.next();
            if (!listElement.isSelected()) continue;
            linkedList.add(listElement);
        }
        return linkedList;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!(mouseEvent.getButton() != 1 || mouseEvent.isPopupTrigger() || mouseEvent.isShiftDown() && mouseEvent.isControlDown())) {
            if ((mouseEvent.getModifiers() & 2) == 2 || (mouseEvent.getModifiers() & 8) == 8) {
                ListElement listElement = this.data.getElementAtLocation(mouseEvent.getY());
                if (listElement != null) {
                    if (!listElement.isSelected()) {
                        this.start = mouseEvent.getY();
                    }
                    listElement.setSelected(!listElement.isSelected());
                    this.display.repaint();
                }
            } else if ((mouseEvent.getModifiers() & 1) == 1) {
                this.selectRange(mouseEvent);
            } else {
                this.start = mouseEvent.getY();
                this.clearSelections();
                this.setSelectedAt(this.start, true);
                this.display.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 16 || (mouseEvent.getModifiers() & 0x10) == 16) {
            this.selectRange(mouseEvent);
        }
    }

    private void selectRange(MouseEvent mouseEvent) {
        this.clearSelections();
        boolean bl = false;
        int n = TextSource.fontMetrics.getHeight() + 2;
        if (this.start < mouseEvent.getY()) {
            for (int i = this.start; i < mouseEvent.getY(); i += n) {
                this.setSelectedAt(i, true);
            }
        } else {
            for (int i = mouseEvent.getY(); i < this.start; i += n) {
                this.setSelectedAt(i, true);
            }
            this.setSelectedAt(this.start, true);
        }
        this.display.repaint();
    }

    public boolean setSelectedAt(int n, boolean bl) {
        ListElement listElement = this.data.getElementAtLocation(n);
        if (listElement != null && listElement.isSelected() != bl) {
            listElement.setSelected(bl);
            return true;
        }
        return false;
    }

    public int translateToLineNumber(int n) {
        int n2 = TextSource.fontMetrics.getHeight() + 2;
        int n3 = (n - n % n2) / n2 + this.data.getValue();
        return n3;
    }
}

