/*
 * Decompiled with CFR 0.152.
 */
package text.wrapped;

import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import text.AttributedText;
import text.TextSource;
import text.wrapped.SelectionSpace;
import text.wrapped.WrappedContainer;
import text.wrapped.WrappedData;

public class WrappedDisplayComponent
extends JComponent
implements ChangeListener {
    protected WrappedData data;

    public WrappedDisplayComponent() {
        this.setOpaque(false);
        this.setDoubleBuffered(false);
    }

    public void setWrappedData(WrappedData wrappedData) {
        this.data = wrappedData;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        TextSource.initGraphics(graphics);
        WrappedContainer wrappedContainer = this.data.getCurrentText();
        this.data.setExtent((this.getHeight() - 5) / (TextSource.fontMetrics.getHeight() * 3));
        if (wrappedContainer == null) {
            return;
        }
        int n = graphics.getClipBounds().y - 10;
        int n2 = n + graphics.getClipBounds().height + 20;
        int n3 = super.getWidth();
        int n4 = super.getHeight();
        graphics.setFont(TextSource.clientFont);
        int n5 = n4 - 5;
        WrappedContainer wrappedContainer2 = wrappedContainer;
        if (this.data.getSelection() != null) {
            this.data.getSelection().clear();
        }
        while (wrappedContainer2 != null && n5 > 0) {
            wrappedContainer2.touch(n3);
            AttributedText[] attributedTextArray = wrappedContainer2.getWrappedText();
            for (int i = 0; i < attributedTextArray.length && n5 > 0; n5 -= TextSource.fontMetrics.getHeight() + 2, ++i) {
                if (n5 > n2 || n5 < n) continue;
                TextSource.drawBackground(graphics, attributedTextArray[i], 0, n5);
                this.drawSelection(graphics, attributedTextArray[i], n5, i == 0);
                TextSource.drawForeground(graphics, attributedTextArray[i], 0, n5);
            }
            wrappedContainer2 = wrappedContainer2.next();
        }
    }

    public void drawSelection(Graphics graphics, AttributedText attributedText, int n, boolean bl) {
        if (this.data.getSelection() == null) {
            return;
        }
        SelectionSpace selectionSpace = this.data.getSelection();
        graphics.setColor(UIManager.getColor("TextField.selectionBackground"));
        if (selectionSpace.isOnlyLine(n)) {
            int n2 = attributedText.getRange(0, selectionSpace.getSingleStart()).length();
            int n3 = attributedText.getRange(0, selectionSpace.getSingleEnd()).length();
            String string = attributedText.getText();
            int n4 = TextSource.fontMetrics.getHeight();
            int n5 = TextSource.fontMetrics.stringWidth(string.substring(0, n2));
            int n6 = TextSource.fontMetrics.stringWidth(string.substring(0, n3));
            selectionSpace.append(string.substring(n2, n3));
            graphics.fillRect(n5, n - n4 + 2, n6 - n5, n4 + 2);
        } else if (selectionSpace.isStartLine(n)) {
            if (bl) {
                selectionSpace.touch();
            }
            String string = attributedText.getRange(0, selectionSpace.getSelectionStart());
            int n7 = TextSource.fontMetrics.getHeight();
            int n8 = TextSource.fontMetrics.stringWidth(string);
            String string2 = attributedText.getText();
            string = string2.substring(string.length(), string2.length());
            selectionSpace.append(string);
            graphics.fillRect(n8, n - n7 + 2, attributedText.getWidth() - n8, n7 + 2);
        } else if (selectionSpace.isEndLine(n)) {
            if (bl) {
                selectionSpace.touch();
            }
            int n9 = TextSource.fontMetrics.getHeight();
            int n10 = TextSource.fontMetrics.stringWidth(attributedText.getRange(0, selectionSpace.getSelectionEnd()));
            if (attributedText.isIndent()) {
                String string = attributedText.next.getRange(0, selectionSpace.getSelectionEnd());
                selectionSpace.append(string);
                selectionSpace.append(" ");
            } else {
                String string = attributedText.getRange(0, selectionSpace.getSelectionEnd());
                selectionSpace.append(string);
            }
            graphics.fillRect(0, n - n9 + 2, n10, n9 + 2);
        } else if (selectionSpace.isSelectedLine(n)) {
            if (bl) {
                selectionSpace.touch();
            }
            int n11 = TextSource.fontMetrics.getHeight();
            graphics.fillRect(0, n - n11 + 2, attributedText.getWidth(), n11 + 2);
            if (attributedText.isIndent()) {
                attributedText = attributedText.next;
                selectionSpace.append(attributedText.getText());
                selectionSpace.append(" ");
            } else {
                selectionSpace.append(attributedText.getText());
            }
        }
    }
}

