name = "Forge Cooldown Timer"
version = "1.01"
description =
[[
Displays cooldown timer for active ability on current weapon.
Chat announcer for when timer is less than a certain value.
]]
author = "T Shaw Killer"
forumthread = ""
api_version = 10
dont_starve_compatible = false
reign_of_giants_compatible = false
dst_compatible = true
all_clients_require_mod = false
client_only_mod = true
server_filter_tags = {}
icon_atlas = "cooldown.xml"
icon = "cooldown.tex"

local display_update_options = {}
for i=1,20 do
	display_update_options[i] = {description = i*0.1 .." s", data = i*0.1}
end

local cooldown_fontsize_options = {}
for i=1,20 do
	cooldown_fontsize_options[i] = {description = i+20, data = i+20}
end

local cooldown_chat_time_options = {}
for i=1,9 do
	cooldown_chat_time_options[i] = {description = (i*0.5)+0.5, data = (i*0.5)+0.5}
end

local cooldown_pos_x_options = {}
for i=1,101 do
	cooldown_pos_x_options[i] = {description = (i*10)-510, data = (i*10)-510}
end

local cooldown_pos_y_options = {}
for i=1,65 do
	cooldown_pos_y_options[i] = {description = (i*10)-330, data = (i*10)-330}
end

local true_false_options = {
	{description = "No", data = false},
	{description = "Yes", data = true}
}

local null_options = {
	{ description = "\n", data = 0 }
}


configuration_options =
{
	{
		name = "SHOW_CD_KEY",
		label = "Toggle Cooldown Display Key",
		hover = "Key to show/hide the cooldown timer",
		options = (function()
			local keylist = {
				"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","BACKSPACE","PERIOD","SLASH","TILDE","0","1","2","3","4","5","6","7","8","9"
			}
			local Keys = {}
			for i = 1,#keylist do
				Keys[i] =  {description = keylist[i], data = "KEY_"..keylist[i]}
			end
			return Keys
		end)(),
		default = "KEY_C"
	},
	{
		name = "POS_Y",
		label = "Up/Down Location",
		options = cooldown_pos_y_options,
		default = -280,
		hover = "How far up/down the cooldown timer is"
	},
	{
		name = "POS_X",
		label = "Left/Right Location",
		options = cooldown_pos_x_options,
		default = 0,
		hover = "How far left/right the cooldown timer is"
	},
	{
		name = "DT_DISPLAY",
		label = "Cooldown Display Update",
		options = display_update_options,
		default = 0.1,
		hover = "How frequently the mod updates the cooldown display"
	},
	{
		name = "COOLDOWN_FONTSIZE",
		label = "Cooldown Size",
		options = cooldown_fontsize_options,
		default = 40,
		hover = "Fontsize of the cooldown timer"
	},
	{
		name = "null",
		label = "Cooldown Announcer",
		options = null_options,
		default = 0,
		hover = "Options for the cooldown announcer"
	},
	{
		name = "COOLDOWN_SAY_CHAT",
		label = "Cooldown Chat Announce",
		options = true_false_options,
		default = true,
		hover = "Enable the chat announcer for cooldown time left on active ability"
	},
	{
		name = "COOLDOWN_CHAT_TIME",
		label = "Cooldown Chat Threshold",
		options = cooldown_chat_time_options,
		default = 3,
		hover = "Time left on the cooldown timer to announce"
	},
	{
		name = "WEAPON_BLOWDART_LAVA",
		label = "Darts",
		options = true_false_options,
		default = false,
		hover = "Announce time left until \'Barrage\'"
	},
	{
		name = "WEAPON_BLOWDART_LAVA2",
		label = "Molten Dart",
		options = true_false_options,
		default = false,
		hover = "Announce time left until \'Molten Bolt\'"
	},
	{
		name = "WEAPON_BOOK_ELEMENTAL",
		label = "Tome of Beckoning",
		options = true_false_options,
		default = false,
		hover = "Announce time left until \'Summon Magma Golem\'"
	},
	{
		name = "WEAPON_BOOK_FOSSIL",
		label = "Petrifying Tome",
		options = true_false_options,
		default = false,
		hover = "Announce time left until \'Petrify\'"
	},
	{
		name = "WEAPON_FIREBALLSTAFF",
		label = "Infernal Staff",
		options = true_false_options,
		default = false,
		hover = "Announce time left until \'Call Cataclysm\'"
	},
	{
		name = "WEAPON_HAMMER_MJOLNIR",
		label = "Forging Hammer",
		options = true_false_options,
		default = false,
		hover = "Announce time left until \'Anvil Strike\'"
	},
	{
		name = "WEAPON_HEALINGSTAFF",
		label = "Living Staff",
		options = true_false_options,
		default = false,
		hover = "Announce time left until \'Cast Life Blossom\'"
	},
	{
		name = "WEAPON_SPEAR_GUNGNIR",
		label = "Pith Pike",
		options = true_false_options,
		default = false,
		hover = "Announce time left until \'Pyre Poker\'"
	},
	{
		name = "WEAPON_SPEAR_LANCE",
		label = "Spiral Spear",
		options = true_false_options,
		default = false,
		hover = "Announce time left until \'Sky Lunge\'"
	},
}