local _G = GLOBAL
local require = _G.require
local CDWidget = require "widgets/cdwidget"
local TheInput = _G.TheInput

local SHOW_CD = GetModConfigData("SHOW_CD_KEY") or "KEY_C"

local options = {
	dt_display         = GetModConfigData("DT_DISPLAY"),
	pos_x              = GetModConfigData("POS_X"),
	pos_y              = GetModConfigData("POS_Y"),
	cooldown_fontsize  = GetModConfigData("COOLDOWN_FONTSIZE"),
	cd_chat_time       = GetModConfigData("COOLDOWN_CHAT_TIME"),
	cd_chat_enabled    = GetModConfigData("COOLDOWN_SAY_CHAT"),
	cd_chat_weapons    = {
		book_fossil    = GetModConfigData("WEAPON_BOOK_FOSSIL"),
		book_elemental = GetModConfigData("WEAPON_BOOK_ELEMENTAL"),
		fireballstaff  = GetModConfigData("WEAPON_FIREBALLSTAFF"),
		healingstaff   = GetModConfigData("WEAPON_HEALINGSTAFF"),
		hammer_mjolnir = GetModConfigData("WEAPON_HAMMER_MJOLNIR"),
		spear_gungnir  = GetModConfigData("WEAPON_SPEAR_GUNGNIR"),
		spear_lance    = GetModConfigData("WEAPON_SPEAR_LANCE"),
		blowdart_lava  = GetModConfigData("WEAPON_BLOWDART_LAVA"),
		blowdart_lava2 = GetModConfigData("WEAPON_BLOWDART_LAVA2"),
	},
}

local function IsHUDScreen()
	local defaultscreen = false
	if _G.TheFrontEnd:GetActiveScreen() and _G.TheFrontEnd:GetActiveScreen().name and type(_G.TheFrontEnd:GetActiveScreen().name) == "string" and _G.TheFrontEnd:GetActiveScreen().name == "HUD" then
		defaultscreen = true
	end
	return defaultscreen
end

-- called when HUD controls becomes available
local function AddCD(self)
	controls = self
	if controls and controls.containerroot then
		-- make sure we are in the forge
		if _G.TheNet:GetServerGameMode() == "lavaarena" then
			print("[CD] CD widget added!")
			controls.cd = controls.containerroot:AddChild(CDWidget(options))
		end
	else
		print("[CD] AddClassPostConstruct errors!")
		return
	end
end
AddClassPostConstruct( "widgets/controls", AddCD )

-- recharge hook
AddPrefabPostInit("inventoryitem_classified", function(inst)
	inst:ListenForEvent("rechargetimedirty", function()
		if inst ~= nil then
			if controls and controls.cd then
				controls.cd:UpdateRechargeInst(inst or nil)
			end
		end
	end)
end)

-- called on keybind, toggles display
local function ShowCD()
	if IsHUDScreen() then
		if controls and controls.cd then
			if controls.cd.IsCDShown then
				controls.cd:Close()
			else
				controls.cd:Open()
			end
		else
			print("[CD] Menu can not show!")
			return
		end
	else
		print("[CD] HUD not active")
	end
end

TheInput:AddKeyDownHandler(_G[SHOW_CD], ShowCD)
