local Text = require "widgets/text"
local Widget = require "widgets/widget"

local CDWidget = Class(Widget, function(self, options)
	
	------------------ NO TOUCHY ------------------
	Widget._ctor(self, "CDWidget")
	
	-- Root
	self.root = self:AddChild(Widget("ROOT"))
	self.root:SetVAnchor(ANCHOR_MIDDLE)
	self.root:SetHAnchor(ANCHOR_MIDDLE)
	self.root:SetScaleMode(SCALEMODE_PROPORTIONAL)
	self.root:SetPosition(0,0,0)
	
	-------------------------------------------------------------------------
	
	self.mod_root = options.mod_root or nil
	
	-- store the inst
	self.recharge_inst = nil
	
	-- used to display cooldown timer
	self.current_percent = nil
	self.current_time = nil
	
	-- used to check against to set to 0 if same as current
	self.previous_percent = nil
	
	-- whether or not to play sound
	self.sound_played = true
	
	-- whether or not to say chat message when cooldown reaches threshold below
	self.cd_chat_enabled = options.cd_chat_enabled or true
	
	-- time left on cooldown to trigger announcement
	self.cooldown_chat_time = options.cd_chat_time or 3
	
	-- table that stores what weapon you want cooldown announce for
	self.cd_chat_weapons = options.cd_chat_weapons or {}
	
	-- when chat was said
	self.cd_chat_time = 0
	
	-- When display was updated
	self.last_update = 0
	
	-- CD widget shown
	self.IsCDShown = false
	
	-- Seconds between each time display update
	self.dt_display = options.dt_display or 0.1
	
	--------------------------------------------------------------------------
	
	-- Font constant
	self.font = BODYTEXTFONT
	
	-- Colors: { r, g, b, alpha }
	self.color_white 	= {1,1,1,1}
	self.color_green 	= {0,1,0,1}
	self.color_red 		= {1,0,0,1}
	self.color_yellow	= {1,1,0,1}
	
	------------------------------------------- DISPLAY STUFF -------------------------------------------	
	
	-- CD Timer text
	self.cooldown_pos_x = options.pos_x or 0
	self.cooldown_pos_y = options.pos_y or -280
	self.cooldown_fontsize = options.cooldown_fontsize or 40
	self.cooldown_text = self.root:AddChild( Text(self.font, self.cooldown_fontsize, "0.0 s", self.color_green) )
	local cooldown_text_size_x, cooldown_text_size_y = self.cooldown_text:GetRegionSize()
	self.cooldown_text:SetPosition(self.cooldown_pos_x, self.cooldown_pos_y + cooldown_text_size_y, 0)
	
	self:Open()
end)

function CDWidget:Close()
	self:Hide()
	self.IsCDShown = false
	self:StopUpdating()
end

function CDWidget:Open()
	self:Show()
	self.IsCDShown = true
	self:StartUpdating()
end

-- when a weapon is equipped this is called to get charge stuff later
function CDWidget:UpdateRechargeInst(inst)
	if inst then
		self.recharge_inst = inst
	end
end

-- updates text and current time
function CDWidget:UpdateDisplay()	
	if self.recharge_inst and self.recharge_inst.rechargetime and self.recharge_inst._recharge then
		local dirty_time = self.recharge_inst.rechargetime:value()
		local dirty_percent = self.recharge_inst._recharge
		self.current_time = dirty_time >= -1 and dirty_time or 0
		self.current_percent =  dirty_percent < 180 and dirty_percent >= 0 and dirty_percent / 180 or 1
		if self.current_percent == self.previous_percent then
			-- sometimes time gets stuck at 0.1sec, also called when weapon is dropped with time left on timer
			self.cooldown_text:SetString("0.0 s")
			self.cooldown_text:SetColour(self.color_green)
		else
			self.previous_percent = self.current_percent
			local time_left = self.current_time - self.current_time*self.current_percent
			time_left = time_left <= 0 and 0 or time_left
			local time_str = string.format("%.1f", math.floor(time_left*100 + 0.5) / 100) .. " s"
			self.cooldown_text:SetString(time_str)
			local color_ratio = time_left <= 0.9 and time_left / 0.9 or 1
			self.cooldown_text:SetColour({color_ratio, 1, color_ratio, 1})
			local cooldown_time_str = string.format("%.1f", math.floor(self.cooldown_chat_time*100 + 0.5) / 100) .. " s"
			local dif = GetTime() - self.cd_chat_time
			-- chat has to be enabled, be around the same time, not said in past 1 sec and the player not dead
			if self.cd_chat_enabled and cooldown_time_str == time_str and dif > 1 and not ThePlayer.replica.health:IsDead() then
				local prefab = tostring(self.recharge_inst._parent.prefab)
				if prefab and self.cd_chat_weapons[prefab] then
					local message = ""
					local right_click_str = STRINGS.ACTIONS.CASTAOE[prefab:upper()]
					if right_click_str then
						message = message .. tostring(right_click_str) .. " in " .. self.cooldown_chat_time .. " sec"
					else
						message = message .. "Active ability in " .. cooldown_time_str
					end
					TheNet:Say(message)
					self.cd_chat_time = GetTime()
				end
			end
		end
	else
		self.cooldown_text:SetString("0.0 s")
		self.cooldown_text:SetColour(self.color_green)
		self.current_percent = nil
		self.current_time = nil
		self.previous_percent = nil
	end
	
	-- update positioning
	local cooldown_text_size_x, cooldown_text_size_y = self.cooldown_text:GetRegionSize()
	self.cooldown_text:UpdatePosition(self.cooldown_pos_x, self.cooldown_pos_y + cooldown_text_size_y)
end

-- called every tick after self:StartUpdating() is called
function CDWidget:OnUpdate(dt)
	local t = GetTime()
	-- if havent updated text display in self.dt_display time, then update it
	if (t - self.last_update) > self.dt_display then
		self.last_update = t
		self:UpdateDisplay()
	end
end

function CDWidget:OnControl(control, down)
	if CDWidget._base.OnControl(self,control, down) then
		return true
	end
	if not down then
		if control == CONTROL_PAUSE or control == CONTROL_CANCEL then
			self:Close()
		end
	end
	return true
end

function CDWidget:OnRawKey(key, down)
	if CDWidget._base.OnRawKey(self, key, down) then return true end
end

return CDWidget