local _G = GLOBAL

local TUNING = _G.TUNING

TUNING.EAT_GEMS_SPELL_DURATION = 10 * 480
TUNING.EAT_GEMS_INSULATION = (TUNING.INSULATION_LARGE + TUNING.INSULATION_MED) / 2

--local Hacker = _G.require"tools/upvaluehacker"

local function overwrite(tabula, name, func, post)
	if type(tabula) ~= "table" then return end 
	local old = tabula[name]
	tabula[name] = function(...)
		local unpack = unpack or table.unpack or _G.unpack
		
		local results_ante = {}
		if type(func) == "function" then results_ante = {func(...)} end 
		if #results_ante > 0 then return unpack(results_ante) end 
		
		local results_original = {}
		if type(old) == "function" then results_original = {old(...)} end 
		
		local results_post = {}
		if type(post) == "function" then results_post = {post(...)} end 
		if #results_post > 0 then return unpack(results_post) end 
		
		return unpack(results_original)
	end 
end 

local EFFECTS = {
	redgem = function(inst)
		local temperature = inst.components.temperature
		if not temperature then return end 
		temperature.inherentinsulation = temperature.inherentinsulation + TUNING.EAT_GEMS_INSULATION
	end, 
	
	bluegem = function(inst)
		local temperature = inst.components.temperature
		if not temperature then return end 
		temperature.inherentsummerinsulation = temperature.inherentsummerinsulation + TUNING.EAT_GEMS_INSULATION
	end, 
	
	purplegem = function(inst)
		local sanity = inst.components.sanity
		if sanity then 
			sanity.dapperness = sanity.dapperness + TUNING.DAPPERNESS_HUGE / 2
		end 
	end, 
	
	yellowgem = function(inst, init)
		if init then 
			if inst.wormlight then 
				local spell = inst.wormlight.components.spell
				spell.variables.radius = spell.variables.radius --* 2
				spell:ResumeSpell()
			end 
			return 
		end 
		
		if inst.wormlight then inst.wormlight:Remove() end 
		
		local light = _G.SpawnPrefab"wormlight_light"
		local spell = light.components.spell
		spell:SetTarget(inst)
		spell.duration = TUNING.EAT_GEMS_SPELL_DURATION
		spell.variables.radius = spell.variables.radius * 2
		spell:StartSpell()
	end, 
	
	greengem = function(inst)
		inst.fast_crafter = true
		local builder = inst.components.builder 
		if not builder then return end 
		builder.science_bonus = builder.science_bonus + 2
		builder.magic_bonus = builder.magic_bonus + 2-- level of presti 
	end, 
	
	orangegem = function(inst, init)
		if inst.components.locomotor and not init then 
			inst.components.locomotor:AddSpeedModifier_Mult("ORANGE_GEM", 0.25, TUNING.EAT_GEMS_SPELL_DURATION)
		end 
	end, 
}

local OFF = {
	redgem_timer = function(inst)
		local temperature = inst.components.temperature
		if not temperature then return end 
		temperature.inherentinsulation = temperature.inherentinsulation - TUNING.EAT_GEMS_INSULATION
	end, 
	
	bluegem_timer = function(inst)
		local temperature = inst.components.temperature
		if not temperature then return end 
		temperature.inherentsummerinsulation = temperature.inherentsummerinsulation - TUNING.EAT_GEMS_INSULATION
	end, 
	
	purplegem_timer = function(inst)
		local sanity = inst.components.sanity
		if sanity then 
			sanity.dapperness = sanity.dapperness - TUNING.DAPPERNESS_HUGE / 2
		end 
	end, 
		
	greengem_timer = function(inst)
		inst.fast_crafter = false 
		local builder = inst.components.builder 
		if not builder then return end 
		builder.science_bonus = builder.science_bonus -2
		builder.magic_bonus = builder.magic_bonus -2-- level of presti 
	end, 
}

AddStategraphPostInit("wilson", function(self)
	overwrite(self.actionhandlers[_G.ACTIONS.BUILD], "deststate", function(inst, action)
		if inst.fast_crafter and action.recipe ~= "livinglog" then return "doshortaction" end 
	end)
end)

local function init(inst)
	for gem, func in pairs(EFFECTS) do 
		if inst.components.timer:TimerExists(gem .. "_timer") then 
			func(inst, true)
		end 
	end 
end 

local function timerdone(inst, data)
	if OFF[data.name] then OFF[data.name](inst) end 
end 

AddPlayerPostInit(function(inst)
	if not inst.components.timer then inst:AddComponent"timer" end 
	inst:DoTaskInTime(0, init)
	inst:ListenForEvent("timerdone", timerdone)
	
	for func, _ in pairs{
		CanEat = true, 
		AbleToEat = true, 
		IsValidFood = true, 
	} do 
		overwrite(inst.components.eater, func, function(eater, food)
			if food and food:HasTag"gem" then return true end 
		end)
	end 
end)

local function oneaten(food, eater)
	if not eater.components.timer then eater:AddComponent"timer" end 
	-- if a lobster ate it, the effect will last as long as you dont relog 
	local timer = eater.components.timer 
	local timer_name = food.prefab .. "_timer"
	
	if timer:TimerExists(timer_name) then 
		timer:StopTimer(timer_name)
		if OFF[timer_name] then OFF[timer_name](eater) end 
	end 
	
	EFFECTS[food.prefab](eater, false)
	timer:StartTimer(timer_name, TUNING.EAT_GEMS_SPELL_DURATION)
end

for gem, _ in pairs(EFFECTS) do 
	AddPrefabPostInit(gem, function(inst)
		inst:AddTag"gem"
		if not inst.components.edible then inst:AddComponent"edible" end 
		overwrite(inst.components.edible, "oneaten", oneaten)
	end)
end 

--[[
local function entity_death(world, data)
	if data.cause ~= _G.GetPlayer().prefab then return end 
	
end

AddPrefabPostInit("world", function(world)
	world:ListenForEvent("entity_death", entity_death)
end)
]]