

local assets =
{
    Asset("ANIM", "anim/wilson_cabin.zip"),
}

local prefabs = 
{
    
}

local function onnear(inst)
        inst.AnimState:PlayAnimation("see")
        inst.Light:Enable(true)
end

local function onfar(inst)
       inst.AnimState:PlayAnimation("idle")     
       inst.Light:Enable(false)
end

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
      --SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle", true)
end

local function onfinished(inst)
      --inst.AnimState:PlayAnimation("destroy")
      --inst:ListenForEvent("animover", function(inst, data) inst:Remove() end)
	inst.SoundEmitter:PlaySound("dontstarve/common/tent_dis_pre")
	inst.persists = false              
      --inst:DoTaskInTime(16*FRAMES, function() inst.SoundEmitter:PlaySound                                          ("dontstarve/common/tent_dis_twirl") end)
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("idle", false)
end


local function onsleep(inst, sleeper)
	if GetClock():IsDay() then
	if sleeper.components.talker then
	sleeper.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_NODAYSLEEP"))
	return
end
end
	local hounded = GetWorld().components.hounded

	local danger = FindEntity(inst, 10, function(target) 
		return
			(target:HasTag("monster") and not target:HasTag("player") and not sleeper:HasTag("spiderwhisperer"))
			or (target:HasTag("monster") and not target:HasTag("player") and sleeper:HasTag("spiderwhisperer") and not target:HasTag("spider"))
			or (target:HasTag("pig") and not target:HasTag("player") and sleeper:HasTag("spiderwhisperer"))
			or (target.components.combat and target.components.combat.target == sleeper)
	end)
	if hounded and (hounded.warning or hounded.timetoattack <= 0) then
	danger = true
end
	if danger then
	if sleeper.components.talker then
	sleeper.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_NODANGERSLEEP"))
end
	return
end
	sleeper.components.health:SetInvincible(true)
	sleeper.components.playercontroller:Enable(false)
	TheFrontEnd:Fade(false,1)
	inst:DoTaskInTime(1.2, function() 
	TheFrontEnd:Fade(true,1) 
	if GetClock():IsDay() then
	if sleeper.components.talker then				
	sleeper.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_NODAYSLEEP"))
	sleeper.components.health:SetInvincible(false)
	sleeper.components.playercontroller:Enable(true)
	return
end
end
		
	if sleeper.components.sanity then
	sleeper.components.sanity:DoDelta(TUNING.SANITY_CABIN)
end
		
	if sleeper.components.hunger then
	sleeper.components.hunger:DoDelta(TUNING.CALORIES_CABIN, false, true)
end
		
	if sleeper.components.health then
	sleeper.components.health:DoDelta(TUNING.HEALING_CABIN, false, "tent", true)
end
		
	if sleeper.components.tempature then
	sleeper.components.tempature:SetTemperature(sleeper.components.tempature.maxtemp)
end
	inst.components.finiteuses:Use()
	GetClock():MakeNextDay()
		
	sleeper.components.health:SetInvincible(false)
	sleeper.components.playercontroller:Enable(true)
	sleeper.sg:GoToState("wakeup")	
end)
end

local function fn(Sim)
        local inst = CreateEntity()
        local trans = inst.entity:AddTransform()
        local anim = inst.entity:AddAnimState()

        inst.entity:AddSoundEmitter()
    
        inst:AddTag("structure")	
        inst:AddTag("tent")
    
        anim:SetBank("wilson_cabin")
        anim:SetBuild("wilson_cabin")
        anim:PlayAnimation("idle", true)    

        inst.Transform:SetScale(1.10, 1.10, 1.10)

        inst:AddComponent("lootdropper")
        inst:AddComponent("workable")
        inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
        inst.components.workable:SetWorkLeft(1)
        inst.components.workable:SetOnFinishCallback(onhammered)
        inst.components.workable:SetOnWorkCallback(onhit)     

        inst:AddComponent("inspectable")
    
        local minimap = inst.entity:AddMiniMapEntity()
        minimap:SetIcon( "wilson_cabin.tex" )

        local light = inst.entity:AddLight()
        inst.Light:Enable(false)
        inst.Light:SetRadius(6.5)
        inst.Light:SetFalloff(1)
        inst.Light:SetIntensity(.5)
        inst.Light:SetColour(235/255,121/255,12/255)

        inst:AddComponent("finiteuses")
        inst.components.finiteuses:SetMaxUses(TUNING.FINITEUSES_CABIN)
        inst.components.finiteuses:SetUses(100)
        inst.components.finiteuses:SetOnFinished( onfinished )
	    
        inst:AddComponent("sleepingbag") 
        inst.components.sleepingbag.onsleep = onsleep
    
        inst:AddComponent( "playerprox" )
        inst.components.playerprox:SetDist(8,9)
        inst.components.playerprox:SetOnPlayerNear(onnear)    
        inst.components.playerprox:SetOnPlayerFar(onfar)
    
        return inst
end	
	


return Prefab( "common/objects/wilson_cabin", fn, assets),
		MakePlacer( "common/wilson_cabin_placer", "wilson_cabin", "wilson_cabin", "idle" ) 
