local _G = GLOBAL

for _, prefab in pairs{
	"pigcrownhat", 
	"pig_scepter"
} do 
	AddPrefabPostInit(prefab, function(inst)
		local equippable = inst.components.equippable
		if not equippable then return end 
		local onequipfn, onunequipfn = equippable.onequipfn, equippable.onunequipfn
	
		equippable.onequipfn = function(inst, owner, ...)
			if owner.prefab ~= "wilba" then 
				owner:AddTag"pigroyalty"
			end 
			return onequipfn(inst, owner, ...)
		end
	
		equippable.onunequipfn = function(inst, owner, ...)
			if owner.prefab ~= "wilba" then 
				owner:RemoveTag"pigroyalty"
			end 
			return onunequipfn(inst, owner, ...)
		end
	end)
end 