local _G = GLOBAL
local APPI = AddPrefabPostInit
local TUNING = _G.TUNING

local function overwrite(tabula, name, func, post)
	if type(tabula) ~= "table" then return end 
	local old = tabula[name]
	tabula[name] = function(...)
		local unpack = unpack or table.unpack or _G.unpack
		
		local results_ante = {}
		if type(func) == "function" then results_ante = {func(...)} end 
		if #results_ante > 0 then return unpack(results_ante) end 
		
		local results_original = {}
		if type(old) == "function" then results_original = {old(...)} end 
		
		local results_post = {}
		if type(post) == "function" then results_post = {post(...)} end 
		if #results_post > 0 then return unpack(results_post) end 
		
		return unpack(results_original)
	end 
end 

--[[
local function CLIENT()
	return not _G.TheNet:GetIsMasterSimulation() 
end 
]]

for prefab, _ in pairs{
	amulet = true, 
--	pocketwatch_revive = true, 
	reviver = true, 
} do 
	APPI(prefab, function(inst)
		if not inst.components.tradable then inst:AddComponent"tradable" end
--		if CLIENT() then return end   
		inst:AddTag"beef_res_item"
	end)
end 

--if CLIENT() then return end 

TUNING.BEEFALO_RES_TIME = 240--15
TUNING.BEEFALO_RES_HEALTH_PERCENT = 0.5

local function erode(inst)
	local time_to_erode = 1
	local tick_time = _G.TheSim:GetTickTime()

	if inst.DynamicShadow then
		inst.DynamicShadow:Enable(false)
	end

	inst:StartThread( function()
		local ticks = 0
		while ticks * tick_time < time_to_erode do
			local erode_amount = ticks * tick_time / time_to_erode
			inst.AnimState:SetErosionParams( erode_amount, 0.1, 1.0 )
			ticks = ticks + 1
			_G.Yield()
		end
		inst:Remove()
	end)
end

local function death_state(inst)
	inst.persists = false 
	inst:DoTaskInTime(inst.components.health.destroytime or 2, erode)
end-- the real death function 

local function resurrect(inst, amulet)
	inst.components.timer:StopTimer"DEATH"
	inst:RemoveTag"corpse"
	
	inst.components.health:SetPercent(TUNING.BEEFALO_RES_HEALTH_PERCENT)
	inst.components.periodicspawner:Start()
	inst:RemoveTag"notarget"
	
	inst.sg:GoToState"wake"
	
	if not amulet then 
--[[
	elseif amulet:HasTag"pocketwatch" then 
		amulet:PushEvent"
]]
	else
		amulet:DoTaskInTime(0, amulet.Remove)
		if amulet.SoundEmitter then 
			amulet.SoundEmitter:PlaySound"dontstarve/common/gem_shatter"
		end 
	end 
end -- the res function 

local function death_event(inst)
	if not inst.ever_ridden then
		print("death of a wild beefalo, not making available res", inst)
		return -- should simply go to the death state
	end 
	
	print("death of a ridden beefalo, making a corpse out of it", inst)
	
	inst.SoundEmitter:PlaySound(inst.sounds.yell)
	inst:AddTag"notarget"
	inst:AddTag"corpse"
	inst.components.timer:StopTimer"DEATH"-- in case 
	inst.components.timer:StartTimer("DEATH", TUNING.BEEFALO_RES_TIME)
	
	inst.components.periodicspawner:Stop()
	
	inst.sg:GoToState"sleep"
	
	return true 
end-- the corpse function 

local function riderchanged(inst, data)
	if data and data.newrider then 
		inst.ever_ridden = true 
	end 
end 

local function OnSave(inst, data)
	data.ever_ridden = inst.ever_ridden
end

local function OnLoad(inst, data)
	if data and data.ever_ridden then 
		inst.ever_ridden = true 
	end 
end 

AddStategraphPostInit("beefalo", function(self)
	overwrite(self.events.death, "fn", death_event)
	overwrite(self.states.death, "onenter", death_state)
end)

local function timerdone(inst, data)
	if not data or data.name ~= "DEATH" then return end 
	
	inst:RemoveTag"corpse"
--	inst.components.health.nofadeout = false -- this line should not be necessary? 
	inst.sg:GoToState"death"
end 

local function onaccept(inst, giver, gift)
	if gift and gift:HasTag"beef_res_item" and inst:HasTag"corpse" then 
		resurrect(inst, gift)
		return true 
	end 	
end 

local function test(inst, gift, giver)
	if inst:HasTag"corpse" then 
		return gift and gift:HasTag"beef_res_item"  
	end 
end 

local function onrefuse(inst)
	if inst:HasTag"corpse" then return true end 
end

APPI("beefalo", function(inst)
	inst.components.health.nofadeout = true 
	
	if not inst.components.timer then inst:AddComponent"timer" end 
	inst:ListenForEvent("timerdone", timerdone)
	
	inst:ListenForEvent("riderchanged", riderchanged)
	
	overwrite(inst.components.trader, "onaccept", onaccept)
	overwrite(inst.components.trader, "test", test)
	overwrite(inst.components.trader, "onrefuse", onrefuse)
	
	overwrite(inst, "OnSave", OnSave)
	overwrite(inst, "OnLoad", OnLoad)
end)

if true then return end -- the parts below are unfinished. 

PrefabFiles = {
	"topiary_3_placer", 
}

TUNING.BEEFALO_EFFIGY_HEALTH_COST = TUNING.EFFIGY_HEALTH_PENALTY * 2

local EFFIGIES = {}

local function resurrectable(beef)
	local dist_sq = nil 
	local nearest = nil 
	
	for effigy, _ in pairs(EFFIGIES) do 
		if not effigy:IsValid() then 
			EFFIGIES[effigy] = nil 
			
		elseif effigy:beefalo_attuned() then 
			local x, y, z = beef.Transform:GetWorldPosition()
			local a, b, c = effigy.Transform:GetWorldPosition()
			local dist_current = (x - a) ^ 2 + (z - c) ^ 2
			
			if not dist_sq or dist_sq > dist_current then 
				dist_sq = dist_current
				nearest = effigy
			end  
		end 
	end 
	
	return nearest
end 

local function onbuilt(inst)

end

local function beefalo_attuned(effigy)

end 

AddPrefabPostInit("topiary_3", function(inst)
	EFFIGIES[inst] = true 
	inst:RemoveComponent"fixable"
	inst:ListenForEvent("onbuilt", onbuilt)
	inst.beefalo_attuned = beefalo_attuned
end)

local function mounted(inst, data)
	if not data or not data.target then return end 
	inst.beefalo_protege = data.target
	data.target.beefalo_protector = inst 
end

local function dismount(inst)
	if inst.beefalo_protege then 
		inst.beefalo_protege.beefalo_protector = nil 
		inst.beefalo_protege = nil 
	end 
end

AddPlayerPostInit(function(inst)
	inst:ListenForEvent("mounted", mounted)
	inst:ListenForEvent("dismount", dismount)
end)


