local _G = GLOBAL
local APPI = AddPrefabPostInit

PrefabFiles = {
	"musketeer_tower_placer", 
}

_G.STRINGS.NAMES.PIG_GUARD_TOWER_PALACE = "Musketeer Tower" 
_G.STRINGS.RECIPE_DESC.PIG_GUARD_TOWER_PALACE = "Protect citizens the American way."

local Ing = _G.Ingredient
local recipe = _G.Recipe(
	"pig_guard_tower_palace", 
	{
		Ing("cutstone", 3), 
		Ing("blunderbuss", 1), 
		Ing("pigskin", 4)
	}, 
	_G.RECIPETABS.CITY, 
	_G.TECH.CITY, 
	_G.RECIPE_GAME_TYPE.COMMON, 
	"musketeer_tower_placer", 
	nil, 
	true
)
recipe.image = "pig_guard_tower.tex"

APPI("pig_guard_tower_palace", function(inst)
	local spawner = inst.components.spawner
	local TakeOwnership = spawner.TakeOwnership 
	spawner.TakeOwnership = function(...)
		inst:DoTaskInTime(0, function()
			if spawner.child and spawner.child.musketeer then 
				spawner.child:musketeer()
			end 
		end)
		return TakeOwnership(...)
	end
	
	inst.displaynamefn = function() 
		return _G.STRINGS.NAMES.PIG_GUARD_TOWER_PALACE 
	end 
end)

for _, prefab in pairs{
	"pigman_royalguard", 
	"pigman_royalguard_2"
} do 
	APPI(prefab, function(inst)
		local inventory = inst.components.inventory		
		
		local function disarmable(inst)
			if inst.components.disarmable then return end 
			inst:AddComponent"disarmable" 
			inst.components.disarmable.disarmfn = function(inst, doer)
				for _, slots in pairs{inventory.equipslots, inventory.itemslots} do 
					for k, item in pairs(slots) do 
						if item.prefab == "blunderbuss" then inventory:DropItem(item) end 
					end
				end 
				inst:PushEvent("attacked", {attacker = doer, damage = 0})
			end
		end
		
		inst.musketeer = function(inst)	
			for _, slots in pairs{inventory.equipslots, inventory.itemslots} do 
				for k, item in pairs(slots) do 
				
					if item.prefab == "torch" then 
						item:Remove()
						
					elseif item.prefab == "halberd" then 
						item:Remove()
						inventory:Equip(_G.SpawnPrefab"blunderbuss")
						disarmable(inst)
						
					elseif item.prefab == "blunderbuss" then 
						disarmable(inst)
					end  
				end 
			end 
		end
	end)
end

TUNING.CITY_PIG_MUSKETEER_RELOAD = 10

APPI("blunderbuss", function(inst)		
	inst.auto_reload = function(inst)
		local owner = inst.components.inventoryitem.owner
		if not owner or not owner:HasTag"guard" or not owner:IsValid() or inst:HasTag"blunderbuss" then return end 
		inst.components.trader:AcceptGift(owner, _G.SpawnPrefab"gunpowder", false, 1)
	end
	
	inst:DoTaskInTime(0, inst.auto_reload)
	inst:ListenForEvent("itemlose", function()
		inst:DoTaskInTime(TUNING.CITY_PIG_MUSKETEER_RELOAD, inst.auto_reload)
	end)
end)

APPI("gunpowder_projectile", function(inst)
	local projectile = inst.components.projectile
	local Throw = projectile.Throw
	projectile.Throw = function(self, owner, target, attacker, ...)
		if attacker and attacker:HasTag"guard" then self:SetHoming(false) end 
		return Throw(self, owner, target, attacker, ...)
	end
end)