local assets =
{
    Asset("ANIM", "anim/jinguzhou.zip"),
}

local prefabs =
{
    "splash_ocean",
    "book_fx",
	"jinguzhou_fx",
}

local function KillMonkey(jinguzhou, whoremovehp)
    if whoremovehp:HasTag("primeape") or  whoremovehp:HasTag("monkey") then
        whoremovehp.components.health:DoDelta(-250)
    end
	
end

function jinguzhou(inst, reader)
    local num_lightnings =  0
    reader.components.sanity:DoDelta(-33)
	reader.components.health:DoDelta(-10)
	--inst.components.finiteuses:Use(1)
    local x, y, z = reader.Transform:GetWorldPosition()
    local range = 30
    local ents = TheSim:FindEntities(x, y, z, range)
    for i, v in ipairs(ents) do
        KillMonkey(inst, v)
    end
	reader:StartThread(function()
	    for k = 0, num_lightnings do

            local rad = math.random(3, 15)
            local angle = k*((4*PI)/num_lightnings)
            local pos = Vector3(reader.Transform:GetWorldPosition()) + Vector3(rad*math.cos(angle), 0, rad*math.sin(angle))
            GetSeasonManager():DoLightningStrike(pos)
            Sleep(math.random( .3, .5))
        end
        local jinguzhou_fx = SpawnPrefab("jinguzhou_fx")
	    jinguzhou_fx.Transform:SetPosition(x, y, z)
    end)
    return true
end

    local function fn(Sim)
        local inst = CreateEntity()

        local inst = CreateEntity()
    	local trans = inst.entity:AddTransform()
    	local anim = inst.entity:AddAnimState()
        local sound = inst.entity:AddSoundEmitter()

        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("jinguzhou")
        inst.AnimState:SetBuild("jinguzhou")
        inst.AnimState:PlayAnimation("idle")
if SaveGameIndex:IsModeShipwrecked() then
	MakeInventoryFloatable(inst, "idle_water", "idle")
end

        inst:AddComponent("inspectable")
        inst:AddComponent("book")
        inst.components.book.onread = jinguzhou

        inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.atlasname = "images/inventoryimages/jinguzhou.xml"
        inst:AddComponent("finiteuses")
        inst.components.finiteuses:SetMaxUses(5)
        inst.components.finiteuses:SetUses(5)
        inst.components.finiteuses:SetOnFinished(inst.Remove)

        MakeSmallPropagator(inst)

        return inst
    end

    return Prefab("common/inventory/jinguzhou", fn, assets, prefabs)

