local Widget = require "widgets/widget"
local ChargeTimeWidget = require "widgets/chargetimewidget"

return {
	init = function(hud)
				
		local width = 50
		local height = 75
		local x = -190
		local y = -270
		
		local charge_time_hud = hud:AddChild(Widget("charge_time"))
		charge_time_hud:SetHAnchor(ANCHOR_RIGHT)
		charge_time_hud:SetVAnchor(ANCHOR_TOP)
		charge_time_hud:SetPosition(x, y, 0.0)
		charge_time_hud:SetClickable(false)
		charge_time_hud:SetScaleMode(SCALEMODE_PROPORTIONAL)
		
		local charge_time_bar = charge_time_hud:AddChild(ChargeTimeWidget(width, height, charge_time_hud))
		
		local entity = CreateEntity()
		entity:DoTaskInTime(1,function()
		 entity:DoPeriodicTask(0.5, function()
		
		   if GetPlayer() and GetPlayer().prefab == "wx78" and GetPlayer().charge_time then
				local charge_time = GetPlayer().charge_time
				
				if charge_time > 0 then
				
				   if math.floor(charge_time/480) < 1 then
				   
				     if IS_CHINESE_LANGUAGE_WX then
				   	
				      charge_time_bar:SetLabel(tostring(math.floor(charge_time)).."秒")
					  
					  else
					  
					  charge_time_bar:SetLabel(tostring(math.floor(charge_time)).."S")
					  
					  end
					  
				   else	
				   
				     local text =	tostring(math.floor(charge_time/480))

				     if IS_CHINESE_LANGUAGE_WX then					 
					 
			         charge_time_bar:SetLabel(text.."天")
					 
					 else
					   
					  if math.floor(charge_time/480) >= 1 and math.floor(charge_time/480) < 2 then
					  
			           charge_time_bar:SetLabel(text.."D")
					   
					  else

			           charge_time_bar:SetLabel(text.."Ds")

                      end					  
					 
					 end
					 
				   end	
				   
				    charge_time_bar:Show()
					
				else
				
					charge_time_bar:Hide()
					
     			end
	      else

		      charge_time_bar:Hide()
			  
          end

		end)
	  end)	
	end
}