local Image = require "widgets/image"
local Text = require "widgets/text"
local Widget = require "widgets/widget"

Assets =
{
	Asset("ATLAS", "images/chargetimewidget.xml"),
}

local ChargeTimeWidget = Class(Widget, function(self, width, height, owner)
	Widget._ctor(self, "ChargeTimeWidget")
	
	self.owner = owner
	self.width = width
	self.height = height
	
	self:SetClickable(false)
	self:SetScale(1.2, 1.2, 1.2)
	
	self.bgimage = self:AddChild(Image())

	self.bgimage:SetTexture("images/chargetimewidget.xml", "chargetimewidget.tex")

    self.bgimage:ScaleToSize(self.width, self.height)
    self.bgimage:SetTint(1.0, 1.0, 1.0, 1.0)
    self.bgimage:SetBlendMode(1)
	

	self.label = self:AddChild(Text("stint-ucr", 15, ""))
	self.label:SetPosition(3.0, 10.0, 0.0)
	
	self.label:SetHAlign(ANCHOR_MIDDLE)
end)

function ChargeTimeWidget:SetLabel(text)
	self.label:SetString(text)
end

return ChargeTimeWidget