name = "Giant Frogs"
author = "MayaStoat"
version = "1.11"
description = "Sometimes, a giant frog will spawn instead of a regular one!"
forumthread = ""

api_version = 10

dst_compatible = true
dont_starve_compatible = false
reign_of_giants_compatible = false
all_clients_require_mod = true
forge_compatible = false

icon_atlas = "modicon.xml"
icon = "modicon.tex"

priority = -308

server_filter_tags = {"mayastoat","giant frogs"}


--[[
	Changelog:
		1.0
			• Sometimes, a Giant Frog will spawn instead of a normal one!
			• Giant Frogs can be customized anywhere from varg-tier to misery toadstool-tier.

		1.1
			I felt that the balance needed to be shifted more from "glass cannon" to "tank".
			I also felt that the fight was too easy, so I moved the difficulty up in a few ways.
			Why not add some more custom loot options while we're at it?

			Setting Changes:
				• Health setting now works in increments of 100 instead of 68.
				• Size setting can now be set as low as 100%.
				• Attack Period setting can now be set as low as 1.5.
				• Added "Defense" setting.
				• Added "Health Regeneration" setting.
				• Added "Gold Nugget" loot option.
				• Added "Gears" loot option.
				• Added loot options for all current gem types.

			Neutral Changes:
				• Reduced "Eat Player" duration to 10 seconds (down from 12)
				• Increased "Eat Player" DPS to 6 (up from 5)

			Nerfs:
				• Reduced attack range to 7 (down from 8)

			Buffs:
				• Increased health to 4200 (up from 3400)
				• Increased health regeneration to 1/s (up from 0/s)
				• Increased defense to 20% (up from 0%)
				• Increased movement speeds to 130/160 (up from 125/150)
				• Increased "Eat Player" sanity drain & wetness gain to 50 (up from 48)
		1.11
			• Giant Frogs' shadows are now properly-sized.
]]


-- option creator
local function A(n,l,h,o,d) return {['name'] = n,['label'] = l,['hover'] = h,['options'] = o,['default'] = d} end

-- section labeller
local function D(name) return {['name'] = "",['label'] = name,['hover'] = "",['options'] = {{description = "", data = ""}},['default'] = ""} end

-- spacer
local S = {name = "",label = "",hover = "",options = {{description = "", data = ""},},default = ""}

-- prepackaged sets of options

-- on/off
local O = {{description = "No", data = false},{description = "Yes", data = true}}

-- declaring variables
local PCT1,PCT05,DUR,DRAIN,LOOT,STEAL,SPEED,RANGE,ATKSPEED,DAMAGE,HEALTH,SIZE,AURA,DEFENSE,REGEN = {},{},{},{},{},{},{},{},{},{},{},{},{},{},{}

-- percentage (increments of 1% or 10%)
for I=1,10 do PCT1[#PCT1+1] = {description = I*10, data = I*10} end
for I=1,101 do PCT1[#PCT1+1] = {description = -1 + I, data = -1 + I} end

-- percentage (increments of 0.5% or 10%)
for I=1,10 do PCT05[#PCT05+1] = {description = I*10, data = I*10} end
for I=1,201 do PCT05[#PCT05+1] = {description = -0.5 + I*0.5, data = -0.5 + I*0.5} end

-- duration settings (3 to 120 seconds, increments of 1 or 15)
for I=1,8 do DUR[#DUR+1] = {description = I*15, data = I*15} end
for I=3,120 do DUR[#DUR+1] = {description = I, data = I} end

-- loot settings (0 to 40)
for I=1,41 do LOOT[#LOOT+1] = {description = I-1, data = I-1} end

-- stat drain settings (0/s to 24/s, increments of 0.5/s)
DRAIN[1] = {description = 24, data = 24}
for I=1,49 do DRAIN[#DRAIN+1] = {description = -0.5 + I*0.5, data = -0.5 + I*0.5} end

-- item steal settings (0 to 8)
for I=1,9 do STEAL[#STEAL+1] = {description = I-1, data = I-1} end

-- speed settings (50% to 200%, increments of 5%)
for I=1,31 do SPEED[#SPEED+1] = {description = 45 + I*5, data = 45 + I*5} end

-- attack range settings (4 to 12)
for I=1,9 do RANGE[#RANGE+1] = {description = 3 + I, data = 3 + I} end

-- improperly-labelled attack period settings (2 to 6)
for I=1,10 do ATKSPEED[#ATKSPEED+1] = {description = 1 + I*0.5, data = 1 + I*0.5} end

-- 25 to 200 damage, increments of 5
for I=1,36 do DAMAGE[#DAMAGE+1] = {description = 20 + I*5, data = 20 + I*5} end

-- 300hp to 10,000hp, increments of 100
for I=1,98 do HEALTH[#HEALTH+1] = {description = 200 + I*100, data = 200 + I*100} end

-- from 100% to 500% size, increments of 10%
for I=1,41 do SIZE[#SIZE+1] = {description = 90 + I*10, data = 90 + I*10} end

-- 0 to 800 sanity drain per minute, increments of 25/m
for I=1,33 do AURA[#AURA+1] = {description = -25 + I*25, data = -25 + I*25} end

-- 0% to 90% attack resistance, increments of 5%
for I=1,19 do DEFENSE[#DEFENSE+1] = {description = -5 + I*5, data = -5 + I*5} end

-- 0/s to 6/s hp regen
for I=1,7 do REGEN[#REGEN+1] = {description = -1 + I, data = -1 + I} end

-- the actual implementation of options:
configuration_options = {

	S,S,
	D("Percent Chances"),
	A("eatplayer_chance","Chance to Eat Players","How often should Giant Frogs eat players upon attacking?\n(Percentage)",PCT1,40),
	A("spawn_chance","Chance to Spawn","How often should Giant Frogs spawn instead of Frogs?\n(Percentage)",PCT05,0.5),

	S,S,
	D("Visual Effects"),
	A("screen_shake","Screen Shaking","Should giant frogs shake players' screens for intimidation?",O,true),
	A("size","\"Giant Frog\" Size","How large should Giant Frogs be? (Does not affect speed nor phys scale.)\n(Percentage of normal frog size)",SIZE,340),

	S,S,
	D("\"Eat Player\" Stats"),
	A("eatplayer_duration","Duration","Once eaten, how long until a player is spat out?\n(In seconds)",DUR,10),
	A("eatplayer_dps","Health Loss","How much Health do eaten players lose per second?\nThis attack bypasses all armor.",DRAIN,6),
	A("eatplayer_sps","Sanity Loss","How much Sanity do eaten players lose per second?\nThis stacks with the \"Sanity Aura\" combat option.",DRAIN,5),
	A("eatplayer_wps","Wetness Gain","How much Wetness do eaten players gain per second?",DRAIN,5),

	S,
	D("Combat Stats"),
	A("stat_health","Health","How much Health should Giant Frogs have?",HEALTH,4200),
	A("stat_regen","Health Regeneration","How much health should Giant Frogs recover per second?",REGEN,1),
	A("stat_defense","Defense","How much damage should Giant Frogs be protected from?\n(Percentage)",DEFENSE,20),
	A("stat_damage","Damage","How much Damage should Giant Frogs deal?",DAMAGE,100),
	A("stat_attackperiod","Attack Period","How much time should be inbetween Giant Frogs' attacks?\n(In seconds, Lower is faster.)",ATKSPEED,2.5),
	A("stat_range","Attack Range","What should the attack range of Giant Frogs be?\n(In wall units / quarter turfs)",RANGE,7),
	A("stat_aura","Sanity Drain Aura","How much Sanity should Giant Frogs drain per minute?",AURA,400),
	
	S,
	D("Misc Stats"),
	A("stat_walk","Passive Speed","How fast should Giant Frogs move while passive?\n(Percentage of normal frog \"walk\" speed)",SPEED,130),
	A("stat_run","Aggressive Speed","How fast should Giant Frogs move while aggressive?\n(Percentage of normal frog \"run\" speed)",SPEED,160),
	A("stat_booc","Break Objects on Collision","Should Giant Frogs destroy all that they touch?",O,true),
	A("STEAAAAAL","Items Stolen on Attack","How many items should Giant Frogs steal when attacking?",STEAL,4), -- Kazuma, no!

	S,S,
	D("Loot Settings"),
	A("monstermeat","Monster Meat","How much Monster Meat should Giant Frogs drop?",LOOT,16),
	A("froglegs","Frog Legs","How many Frog Legs should Giant Frogs drop?",LOOT,16),
	A("drumstick","Drumsticks","How many Drumsticks should Giant Frogs drop?",LOOT,16),
	A("meat","Meat","How much Meat should Giant Frogs drop?",LOOT,16),
	A("nightmarefuel","Nightmare Fuel","How much Nightmare Fuel should Giant Frogs drop?",LOOT,32),
	S,
	A("gears","Gears","How many Gears should Giant Frogs drop?",LOOT,0),
	A("thulecite","Thulecite","How much Thulecite should Giant Frogs drop?",LOOT,0),
	A("goldnugget","Gold Nuggets","How many Gold Nuggets should Giant Frogs drop?",LOOT,0),
	S,
	A("redgem","Red Gems","How many Red Gems should Giant Frogs drop?",LOOT,0),
	A("bluegem","Blue Gems","How many Blue Gems should Giant Frogs drop?",LOOT,0),
	A("purplegem","Purple Gems","How many Purple Gems should Giant Frogs drop?",LOOT,0),
	A("orangegem","Orange Gems","How many Orange Gems should Giant Frogs drop?",LOOT,0),
	A("yellowgem","Yellow Gems","How many Yellow Gems should Giant Frogs drop?",LOOT,0),
	A("greengem","Green Gems","How many Green Gems should Giant Frogs drop?",LOOT,0),
	A("opalpreciousgem","Iridescent Gems","How many Iridescent Gems should Giant Frogs drop?",LOOT,0),

	S,S,
	D("Meme Stuff"),
	A("silly_messages","Spawn Messages","Should players be warned when giant frogs are spawned?",O,false),

	S,S,

}