-- Shorthand variables to make life easier.
local G = GLOBAL
local F = G.FRAMES
local D = GetModConfigData

-- "Eat Player" stats
local DPT = D("eatplayer_dps")*F
local SPT = D("eatplayer_sps")*F
local WPT = D("eatplayer_wps")*F

-- Giant Frog stats
local HP = D("stat_health")

local REG = D("stat_regen")
local DEF = D("stat_defense") * 0.01

local DMG = D("stat_damage")
local AP = D("stat_attackperiod")
local RNG = D("stat_range")

local RUN = D("stat_run") * 0.01
local WALK = D("stat_walk") * 0.01

local STEAL = D("STEAAAAAL")

local BOOC = D("stat_booc")

local AURA = -D("stat_aura") * (F / 2)


-- Visual effects
local GetShakeyTonight = D("screen_shake")
local Size = D("size") * 0.01

-- Clients need not apply.
if G.TheNet:GetIsClient() then return end

-- Blank function for when we want to do absolutely nothing.
local function Blank() return end

-- Somewhat randomized warnings to keep things fresh. Dunno why I felt like doing this.
local Warn1 = {
	"Watch out! -",
	"Heads up! -",
	"Look out! -",
	"Uh oh! -",
	"Bad news! -",
	"Party time's over! -", -- Terraria reference :)
	"Watch yourselves,",
}

local Warn2 = {
	"A humongous",
	"A giant",
	"A huge",
	"A massive",
	"A very large",
	"A concerningly large",
}

local Warn3 = {
	"Frog",
}

local Warn4 = {

	-- neutral
	"has appeared!",
	"just showed up!",
	"has arrived on the scene!",

	-- joined the game
	"has joined the server!",
	"has joined the game!",

	-- going to be a pain
	"is looking to cause some trouble!",

	-- threats
	"is about to ruin your day!",
	"is going to steal your lunch money!",

	-- memes
	"seeks revenge against mankind!",
	"won't forgive you!",

	-- war
	"is about to violate the Geneva Convention!",
	"is about to commit a war crime!",
	"is about to commit several war crimes!",
}


-- The loot to be dropped
local Loot = {

	-- default drops
	monstermeat = D("monstermeat"),
	froglegs = D("froglegs"),
	drumstick = D("drumstick"),
	meat = D("meat"),
	nightmarefuel = D("nightmarefuel"),

	-- optional drops (misc)
	gears = D("gears"),
	thulecite = D("thulecite"),
	goldnugget = D("goldnugget"),

	-- optional drops (gems)
	redgem = D("redgem"),
	bluegem = D("bluegem"),
	purplegem = D("purplegem"),
	orangegem = D("orangegem"),
	yellowgem = D("yellowgem"),
	greengem = D("greengem"),
	opalpreciousgem = D("opalpreciousgem"),
	
}
local UglyLoot = {} for Item, Num in pairs(Loot) do for I=1,Num do UglyLoot[#UglyLoot+1] = Item end end


-- Pick a random thing from a table
local function RandStr(T)
	return T[math.random(1,#T)]
end

-- If desired, shake players' screens to increase the frogs' "intimidation" stat.
local function Shakey(Ent)
	if GetShakeyTonight then
		G.ShakeAllCameras(G.CAMERASHAKE.VERTICAL,1,0.04,0.16,Ent,36)
	end
end

local function IsValid(Entity)
	local Valid = false
	if Entity.IsValid then Valid = Entity:IsValid() end
	return Valid
end

-- I honestly don't know what to call this function. so Vwoop!
local function Vwoop(Ent)
	local Yes = false
	if Ent and IsValid(Ent) and Ent.components.health and not Ent.components.health:IsDead() then Yes = true end
	return Yes
end

local EatenPlayers = {}

-- Code that is run every tick on victim-frog pairs
local function EatenPlayerTickCode(Victim,Frog)
	Victim.Transform:SetPosition(Frog.Transform:GetWorldPosition())
	Victim.components.health:DoDelta(-DPT,false,"Frog",nil,nil,nil)
	Victim.components.sanity:DoDelta(-SPT)
	Victim.components.moisture:DoDelta(WPT)
	Victim.components.temperature:DoDelta((35-Victim.components.temperature:GetCurrent())*0.025)
end

-- Code for eating players
local function FrogEatPlayer(frog,player)

	if not Vwoop(frog) or not Vwoop(player) or EatenPlayers[player.userid] then return end

	-- Add player, frog, & some other useful data to the EatenPlayers table.
	EatenPlayers[player.userid] = {
		Victim = player,
		Frog = frog,
		Rad = player.Physics:GetRadius(),
		Height = player.Physics:GetHeight(),
		Time = G.GetTime(),
	}

	-- The first tick is usually left out, so we'll do it here.
	EatenPlayerTickCode(player,frog)

	-- Make the player invisible
	player:Hide()
	player.DynamicShadow:Enable(false)

	-- Make the player unable to collide with anything.
	player.Physics:SetCapsule(0,0,0)

	-- Having a tiny light radius stops you from being killed by Charlie.
	player.Light:Enable(true)
	player.Light:SetRadius(0.0001)

	-- Teleport the player to the frog.
	player.Transform:SetPosition(frog.Transform:GetWorldPosition())

	-- Make the player unable to move.
	player.components.playercontroller:Deactivate()
	player.components.playercontroller:Enable(false)

	-- Close the player's inventory.
	if player.components.inventory then
		player.components.inventory:Close()
	end

	-- Make the frog lose its target.
	frog.components.combat:SetTarget(nil)
end

-- Code for spitting out players
local function FrogSpitPlayer(frog,player)

	-- The physics radius we saved earlier will be used to restore the player's collisions.
	local Rad = EatenPlayers[player.userid].Rad

	-- Make sure the player exists first.
	if IsValid(player) then

		-- Stop the player from being invisible
		player:Show()
		player.DynamicShadow:Enable(true)

		-- Restore player's collisions
		player.Physics:SetCapsule(Rad,EatenPlayers[player.userid].Height,Rad)

		-- Return the light radius to normal & disable it, I think.
		player.Light:SetRadius(0.75)
		player.Light:Enable(false)

		-- Allow the player to move again
		player.components.playercontroller:Activate()
		player.components.playercontroller:Enable(true)

		-- Reopen the player's inventory if necessary
		if (player.components.health and not player.components.health:IsDead()) and player.components.inventory then
			player.components.inventory:Open()
		end

	end

	if IsValid(frog) then
		frog:PushEvent("attacked",{})
		frog:DoTaskInTime(F*30,function() if IsValid(player) then frog.components.combat:SetTarget(player) end end)
	end

	-- Remove all data associated with the player from the EatenPlayers table.
	EatenPlayers[player.userid] = nil
end


--[[
	Every tick, this code:
		• Teleports victim to frog,
		• Damages player's health & sanity,
		• Increases player's wetness,
		• Stabilizes the player's temperature to be closer to 35c.

		• Automatically spits out player if any of these criteria are met:
			♦ frog was killed or deleted
			♦ player was killed or deleted
			♦ "eaten" duration exceeds time limit

]]
G.scheduler:ExecutePeriodic(F,function()
	for _,Event in pairs(EatenPlayers) do
		if not Vwoop(Event.Victim) or not Vwoop(Event.Frog) or Event.Time < G.GetTime()-D("eatplayer_duration") then FrogSpitPlayer(Event.Frog,Event.Victim) break end
		EatenPlayerTickCode(Event.Victim,Event.Frog)
	end
end)

-- Steal items or eat players depending on RNG & settings
local function OnHitOther(frog,other,damage)
	Shakey(frog)
	if other:HasTag("player") and other.components.health and not other.components.health:IsDead() and math.random(100) < D("eatplayer_chance") then
		other.components.health:DoDelta(damage)
		FrogEatPlayer(frog,other)
	else
		for I=1,STEAL do frog.components.thief:StealItem(other) end
	end
end

-- stolen from Bearger prefab (destroy stuff the frog bumps into)
local function OnDestroyOther(inst, other)
    if other:IsValid() and
        other.components.workable ~= nil and
        other.components.workable:CanBeWorked() and
        other.components.workable.action ~= G.ACTIONS.NET then
        G.SpawnPrefab("collapse_small").Transform:SetPosition(other.Transform:GetWorldPosition())
		other.components.workable:Destroy(inst)
		Shakey(inst)
    end
end
local function OnCollide(inst, other)
    if other ~= nil and
        other:IsValid() and
        other.components.workable ~= nil and
        other.components.workable:CanBeWorked() and
        other.components.workable.action ~= G.ACTIONS.NET and
        G.Vector3(inst.Physics:GetVelocity()):LengthSq() >= 1 then
        inst:DoTaskInTime(2 * F, OnDestroyOther, other)
    end
end

local function CalcSanityAura(frog)
    return frog.components.combat.target ~= nil and AURA or AURA
end

local function MakeGiant(frog)

	-- If desired, Show silly messages when they spawn
	if D("silly_messages") then G.c_announce(RandStr(Warn1).." "..RandStr(Warn2).." "..RandStr(Warn3).." "..RandStr(Warn4)) end

	-- Increase frog's apparent size
	frog.Transform:SetScale(Size,Size,Size)

	-- Don't forget about the shadow size. :)
	frog.DynamicShadow:SetSize(Size*1.55,Size*1.55)

	-- Modify Speed, Make sure that size isn't factored in.
	frog.components.locomotor.walkspeed = (frog.components.locomotor:GetWalkSpeed()/Size)*WALK
	frog.components.locomotor.runspeed = (frog.components.locomotor:GetRunSpeed()/Size)*RUN

	-- Custom freezing & sleeping resistance
	frog.components.freezable:SetResistance(2)
	frog.components.sleeper:SetResistance(3)

	-- Health, Defense, & Regen
	frog.components.health:SetMaxHealth(HP)
	frog.components.health:SetAbsorptionAmount(DEF)
	frog.components.health:StartRegen(REG,1,false)

	-- Attack Properties
	frog.components.combat:SetAttackPeriod(AP)
	frog.components.combat:SetDefaultDamage(DMG)
	frog.components.combat:SetRange(RNG-1,RNG)

	frog.components.combat.onhitotherfn = OnHitOther

	-- Add sanity aura
	frog:AddComponent("sanityaura")
    frog.components.sanityaura.aurafn = CalcSanityAura

	-- Modify Loot
	frog.components.lootdropper:SetLoot(UglyLoot)

	-- Poof!
	frog:SpawnChild("slurper_respawn")

	-- Frog is big, Not small.
	frog.Giant = true
	frog.Regular = false

	-- Make it FEEL heavy.
	if BOOC then frog.Physics:SetCollisionCallback(OnCollide) end -- If desired, make the frog destroy everything it bumps into.
	if GetShakeyTonight then frog:ListenForEvent("attacked",Shakey) end -- If desired, shake players' screens to increase frog intimidation.

	frog.Physics:SetMass(750)
	frog.Physics:SetCapsule(2,2,2)
	frog:RemoveTag("smallcreature")
	frog:RemoveTag("canbetrapped")
	frog:RemoveTag("prey")
	frog:AddTag("largecreature")
	frog:AddTag("epic")
	frog:AddTag("monster")

end

-- This modifies Saving, Loading, & determines whether or not a frog should be giant when it spawns.
local function FrogFN(inst)

	-- Store old save & load functions for later
	local oldsave = inst.OnSave or Blank
	local oldload = inst.OnLoad or Blank

	-- Overwrite the old save & load functions to factor in giantness.
	inst.OnSave = function(frog,data)
		data.Giant = inst.Giant
		data.Regular = inst.Regular
		oldsave(frog,data)
	end
	inst.OnLoad = function(frog,data)
		oldload(frog,data)
		inst.Giant = data.Giant
		inst.Regular = inst.Regular
	end

	-- Determines if a frog should be giant or not & acts accordingly.
	inst:DoTaskInTime(F*2,function()
		if inst.Giant then
			MakeGiant(inst)
		elseif not inst.Regular then
			if math.random(0,10000)*0.01 < D("spawn_chance") then
				MakeGiant(inst)
			else
				-- Remember that the frog is regular so that reloading the save doesn't re-attempt to make the frog big
				inst.Regular = true
			end
		end
	end)

end
AddPrefabPostInit("frog",FrogFN)