require "prefabutil"
require "recipes"

local assets =
{
    Asset("ANIM", "anim/gingerbread_house1.zip"),
    Asset("ANIM", "anim/gingerbread_house2.zip"),
    Asset("ANIM", "anim/gingerbread_house3.zip"),
    Asset("ANIM", "anim/gingerbread_house4.zip"),
}

local prefabs =
{
    "collapse_small",
    "crumbs"
}

local loot =
{
    "crumbs",
    "crumbs",
	"crumbs",
	"crumbs",
	"crumbs"
}

local animdata = 
{
    { build = "gingerbread_house1", bank = "gingerbread_house1" },
    { build = "gingerbread_house3", bank = "gingerbread_house2" },
    { build = "gingerbread_house2", bank = "gingerbread_house2" },
    { build = "gingerbread_house4", bank = "gingerbread_house1" },
}

local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    
	local x, y, z = inst.Transform:GetWorldPosition()
	
	if not inst:HasTag("burnt") then
		for i, v in ipairs(loot) do
			inst.components.lootdropper:SpawnLootPrefab(v, Point(x,y,z))
		end
        if math.random() < 0.3 then
            local gingerdeadman = SpawnPrefab("gingerdeadpig")
            gingerdeadman.Transform:SetPosition(x, y, z)            
        end
    end
	
    local fx = SpawnPrefab("collapse_small")
    fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
    fx:SetMaterial("wood")
    inst:Remove()
end

local function onhit(inst, worker)
    if not inst:HasTag("burnt") then 
        inst.AnimState:PlayAnimation("hit")
        inst.AnimState:PushAnimation("idle")
    end
end

local function onbuilt(inst)

end

local function OnSave(inst, data)
    data.build = inst.build
    data.bank = inst.bank
end

local function OnLoad(inst, data)
    if data ~= nil then
        inst.build = data.build or animdata[1].build
        inst.bank = data.bank or animdata[1].bank

        inst.AnimState:SetBuild(inst.build)
        inst.AnimState:SetBank(inst.bank)
    end
end

local function onignite(inst)
    inst.components.sleepingbag:DoWakeUp()
end

local function onburntup(inst)
    inst.AnimState:PlayAnimation("burnt_rundown")
end


return Prefab("gingerbread_pig_house_2", nil, assets, prefabs),
	MakePlacer("gingerbread_pig_housep_placer", "gingerbread_house2", "gingerbread_house2", "idle")
