local _G = GLOBAL
local require = GLOBAL.require
local STRINGS = _G.STRINGS
local CONTENT_NAMES = require "content/names"
local ItemTile = require "widgets/itemtile"
local ItemTile_GetDescriptionString_base = ItemTile.GetDescriptionString or function() return "" end

local Chinesization = GetModConfigData("Chinesization")
local ShowContent = GetModConfigData("ShowContent")
local ShowButton = GetModConfigData("ShowButton")
local ButtonSize = GetModConfigData("ButtonSize")

local configs = {
	default= { scale = 0.4 , fontSize = 20 },
	smaller = { scale = 0.3 , fontSize = 18 }
	}

local config ={}

if ButtonSize == "default" then
	config = configs.default
else
	config = configs.smaller
end

function ItemTile:GetDescriptionString()

    local str = ItemTile_GetDescriptionString_base(self)
    if self.item ~= nil and self.item:IsValid() then 
			if self.item.components.unwrappable ~= nil and ShowContent then
				if self.item.components.unwrappable.itemdata ~= nil then
					str = str .."\n"
					for key, value in pairs(self.item.components.unwrappable.itemdata) do
						for k, v in pairs(value)do
							if type(v)== "string" then
								if CONTENT_NAMES[string.upper(v)]~=nil and Chinesization then
									str = str ..CONTENT_NAMES[string.upper(v)].."  "
								elseif STRINGS.NAMES[string.upper(v)]~=nil then
									str = str ..STRINGS.NAMES[string.upper(v)].."  "
								else
									str = str ..v.." "
								end
							end
						end
						
					end
				end
			end
		end
    return str
	
end

local BundleBar = require "bundlebar"
if ShowButton then
	AddClassPostConstruct("widgets/controls", function(self)
			BundleBar.init(self, config)
	end)
end




	
	