require "recipe"
require "components/builder"
local Widget = require "widgets/widget"
local ImageButton = require "widgets/imagebutton"

local function Init(self,data)
	
	local w, h = TheSim:GetScreenSize()
	local xPos = w - 120
	local yPos = 20 - h
	
	local container = self:AddChild(Widget("BundleBar"))
	container:SetHAnchor(ANCHOR_LEFT)
	container:SetVAnchor(ANCHOR_TOP)
	container:SetPosition(xPos, yPos, 0.0)
	container:SetClickable(true)
	container:SetScaleMode(SCALEMODE_PROPORTIONAL)
	
	local imgbtn = container:AddChild(ImageButton())
	imgbtn.image:SetScale(data.scale)
	imgbtn:SetTextSize(data.fontSize)
	imgbtn:SetText("make")
	imgbtn:SetOnClick(function()
		local recipe = GetRecipe("bundlewrap")
		local builder = _G.GetPlayer().components.builder
		if builder ~=nil then
			builder:MakeRecipe(recipe)
		end
	end)

end

return {
	init = Init
	}