-------tuning--------
TUNING.SCYTHE_USES = GetModConfigData("USES")				--75
TUNING.SCYTHE_DAMAGE = GetModConfigData("DAMAGE")			--27.2
TUNING.SCYTHE_DAMAGE_RADIUS	= 2
TUNING.SCYTHE_HARVEST_RADIUS = GetModConfigData("RADIUS")	--6
TUNING.SCYTHE_DAMAGE_MULTIPY = 1

-------resourses--------
PrefabFiles = {
	"scythe",
}

Assets = {
	Asset("ATLAS", "images/inventoryimages/scythe.xml"),
	Asset("IMAGE", "images/inventoryimages/scythe.tex" ),
	Asset("ATLAS", "images/inventoryimages/goldenscythe.xml"),
	Asset("IMAGE", "images/inventoryimages/goldenscythe.tex" ),
}

-------recipe--------
local Ingredient = GLOBAL.Ingredient
local AllRecipes = GLOBAL.AllRecipes

AddRecipe("scythe", { Ingredient("twigs", 2), Ingredient("flint", 4)}, GLOBAL.RECIPETABS.TOOLS, GLOBAL.TECH.SCIENCE_ONE, nil, nil, nil, nil, nil, "images/inventoryimages/scythe.xml", "scythe.tex")
AllRecipes["scythe"].sortkey = AllRecipes["hammer"].sortkey + .1		--sort after hammer
AddRecipe("goldenscythe", { Ingredient("twigs", 4), Ingredient("goldnugget", 4)}, GLOBAL.RECIPETABS.TOOLS, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/goldenscythe.xml", "goldenscythe.tex")
AllRecipes["goldenscythe"].sortkey = AllRecipes["scythe"].sortkey + .1

--------strings---------
modimport("scythe_strings.lua")
local STRINGS = GLOBAL.STRINGS

local lang = GetModConfigData("LANGUAGE") == "default" and GLOBAL.LanguageTranslator.defaultlang or GetModConfigData("LANGUAGE")
for i, v in ipairs(Scythe_Strings) do
	if v.language == lang or v.language == "en" then
		STRINGS.NAMES.SCYTHE = v.STR.NAMES
		STRINGS.RECIPE_DESC.SCYTHE = v.STR.RECIPE_DESC
		STRINGS.CHARACTERS.GENERIC.DESCRIBE.SCYTHE = v.STR.CHAR_DESC
		STRINGS.NAMES.GOLDENSCYTHE = v.GOLD_STR.NAMES
		STRINGS.RECIPE_DESC.GOLDENSCYTHE = v.GOLD_STR.RECIPE_DESC
		STRINGS.CHARACTERS.GENERIC.DESCRIBE.GOLDENSCYTHE = v.GOLD_STR.CHAR_DESC
		break
	end
end

-------stategraph--------
local State = GLOBAL.State
local TimeEvent = GLOBAL.TimeEvent
local FRAMES = GLOBAL.FRAMES
AddStategraphState("wilson", State{
	name = "doareapick",
	tags = { "doing", "busy" },
	
	onenter = function(inst)
		local buffaction = inst:GetBufferedAction()
		local target = buffaction ~= nil and buffaction.target or nil
		inst.components.locomotor:Stop()

		inst.AnimState:PlayAnimation("atk_pre")
		inst.AnimState:PushAnimation("atk", false)
		inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon")

		if target ~= nil and target:IsValid() then
			inst:FacePoint(target:GetPosition())
		end

		inst.sg.statemem.action = buffaction
		inst.sg:SetTimeout(13 * FRAMES)
	end,

	timeline =
	{
		TimeEvent(6 * FRAMES, function(inst)
			inst.sg:RemoveStateTag("busy")
		end),
		TimeEvent(8 * FRAMES, function(inst)
			inst:PushEvent("onareapick")
			inst:PerformBufferedAction()
		end),
	},

	ontimeout = function(inst)
		inst.sg:GoToState("idle", true)
	end,

	onexit = function(inst)
		if inst.bufferedaction == inst.sg.statemem.action then
			inst:ClearBufferedAction()
		end
	end,
})

AddStategraphState("wilson_client", State{
	name = "doareapick",
	tags = { "doing", "busy" },

	onenter = function(inst)
		inst.components.locomotor:Stop()
		inst.AnimState:PlayAnimation("atk_pre")
		inst.AnimState:PushAnimation("atk_lag", false)

		local buffaction = inst:GetBufferedAction()
		if buffaction ~= nil then
			inst:PerformPreviewBufferedAction()
			if buffaction.target ~= nil and buffaction.target:IsValid() then
				inst:FacePoint(buffaction.target:GetPosition())
			end
		end

		inst.sg:SetTimeout(2)
	end,

	timeline =
	{
		TimeEvent(6 * FRAMES, function(inst)
			inst.sg:RemoveStateTag("busy")
		end),
	},

	onupdate = function(inst)
		if inst:HasTag("doing") then
			if inst.entity:FlattenMovementPrediction() then
				inst.sg:GoToState("idle", "noanim")
			end
		elseif inst.bufferedaction == nil then
			inst.sg:GoToState("idle")
		end
	end,

	ontimeout = function(inst)
		inst:ClearBufferedAction()
		inst.sg:GoToState("idle")
	end,
})

--------ActionHandler---------
local ActionHandler = GLOBAL.ActionHandler
local ACTIONS = GLOBAL.ACTIONS
--PICK
AddStategraphActionHandler("wilson", ActionHandler(ACTIONS.PICK, function(inst, action)
	return action.target ~= nil
		and action.target.components.pickable ~= nil
		and (   (action.target.components.pickable.quickpick and "doshortaction") or
				(inst:HasTag("holding_scythe") and "doareapick") or
				(action.target.components.pickable.jostlepick and "dojostleaction") or
				(inst:HasTag("fastpicker") and "doshortaction") or
				(inst:HasTag("quagmire_fasthands") and "domediumaction") or
				"dolongaction"  )
		or nil
end))

AddStategraphActionHandler("wilson_client", ActionHandler(ACTIONS.PICK, function(inst, action)
	return (action.target:HasTag("quickpick") and "doshortaction")
		or (inst:HasTag("holding_scythe") and "doareapick")
		or (action.target:HasTag("jostlepick") and "dojostleaction")
		or (inst:HasTag("fastpicker") and "doshortaction")
		or (inst:HasTag("quagmire_fasthands") and "domediumaction")
		or "dolongaction"
end))
--HARVEST		--for old farm plants
AddStategraphActionHandler("wilson", ActionHandler(ACTIONS.HARVEST, function(inst, action)
	return (inst:HasTag("holding_scythe") and action.target.components.crops ~= nil and "doareapick") or
		(inst:HasTag("quagmire_fasthands") and "domediumaction") or
		"dolongaction"
end))

AddStategraphActionHandler("wilson_client", ActionHandler(ACTIONS.HARVEST, function(inst, action)
	return (inst:HasTag("holding_scythe") and action.target.components.crops ~= nil and "doareapick") or
		(inst:HasTag("quagmire_fasthands") and "domediumaction") or 
		"dolongaction"
end))

--------PostInit----------
AddPrefabPostInit("scythe", function(inst)
	if not GLOBAL.TheWorld.ismastersim then return end
	inst.ability = GetModConfigData("ABILITY")
end)

AddPrefabPostInit("goldenscythe", function(inst)
	if not GLOBAL.TheWorld.ismastersim then return end
	inst.ability = GetModConfigData("ABILITY")
end)