local assets =
{
	Asset("ANIM", "anim/scythe.zip"),
	Asset("ANIM", "anim/swap_scythe.zip"),
	Asset("ATLAS", "images/inventoryimages/scythe.xml"),
	Asset("IMAGE", "images/inventoryimages/scythe.tex" ),
	Asset("ANIM", "anim/floating_items.zip"),
}

local golden_assets =
{
	Asset("ANIM", "anim/goldenscythe.zip"),
	Asset("ANIM", "anim/swap_goldenscythe.zip"),
	Asset("ATLAS", "images/inventoryimages/goldenscythe.xml"),
	Asset("IMAGE", "images/inventoryimages/goldenscythe.tex" ),
	Asset("ANIM", "anim/floating_items.zip"),
}

local function AreaHitCheck(target, owner)
	return not (owner.components.combat:IsAlly(target) or target:HasTag("wall"))
end

local function ExtraPicks(target)
	target.components.pickable.cycles_left = target.components.pickable.cycles_left + .5
	target.components.pickable.protected_cycles = target.components.pickable.protected_cycles + .5
end

local function FastGrowth(target)
	local pickable = target.components.pickable
	if pickable.baseregentime ~= nil and not (pickable.paused or pickable:IsBarren() or target:HasTag("withered")) then
		pickable.regentime = pickable.regentime * .9

		if pickable.task ~= nil then
			pickable.task:Cancel()
		end
		local OnRegen = pickable:Regen()
		pickable.task = target:DoTaskInTime(pickable.regentime, OnRegen)
		pickable.targettime = GetTime() + self.regentime * .9
	end
end

local function ExtraItem(owner, target)			--give an addional product(extra seed for farm plant)
	local item = 
		target.components.crop ~= nil and target.components.crops.product_prefab or
		target.components.pickable.product ~= nil and target.components.pickable.product or
		target.components.lootdropper.lootsetupfn ~= nil and target.components.lootdropper:GenerateLoot()[2] or
		nil
	if item ~= nil then
		local item = SpawnPrefab(item)
		item.components.inventoryitem:InheritMoisture(TheWorld.state.wetness, TheWorld.state.iswet)
		local pt = target:GetPosition()
		if target.components.pickable.droppicked then
			pt.y = pt.y + (target.components.pickable.dropheight or 0)
			target.components.lootdropper:FlingItem(item, pt)
		else
			owner.components.inventory:GiveItem(item, nil, pt)
		end
	end
end

local function AreaDamage(owner, enable)
	if owner.components.combat ~= nil then
		owner.components.combat:EnableAreaDamage(enable)
		if enable then
			owner.components.combat:SetAreaDamage(TUNING.SCYTHE_DAMAGE_RADIUS, TUNING.SCYTHE_DAMAGE_MULTIPY, AreaHitCheck)
		else
			owner.components.combat:SetAreaDamage()
		end
	end
end

local MOW_MUST_TAG = {"plant", "pickable"}
local MOW_MUSTNOT_TAG = {"stump", "withered", "barren", "INLIMBO"}
local function OnAreaPick(owner)
	local x, y, z = owner.Transform:GetWorldPosition()
	local radius = owner.components.debuffable:HasDebuff("buff_workeffectiveness") and TUNING.SCYTHE_HARVEST_RADIUS * 2 or TUNING.SCYTHE_HARVEST_RADIUS
	local ents = TheSim:FindEntities(x, y, z, radius, MOW_MUST_TAG, MOW_MUSTNOT_TAG)

	--for old version farm plot
	local crop = TheSim:FindEntities(x, y, z, radius, {"readyforharvest"}, {"notreadyforharvest"})
	for k, v in pairs(crop) do
		table.insert(ents, v)
	end

	local equip = owner.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
	local collected = 0
	for i, ent in ipairs(ents) do
		if collected >= equip.components.finiteuses:GetUses() then break end

		if ent.components.pickable ~= nil then
			if equip.ability == "EXTRAITEMS" and math.random() < .1 then
				ExtraItem(owner, ent)
			elseif equip.ability == "EXTRAPICKS" then
				ExtraPicks(ent)
			end

			ent.components.pickable:Pick(owner)
			collected = collected + 1

			if equip.ability == "FASTGROWTH" then
				FastGrowth(ent)
			end
		elseif ent.components.crop ~= nil then
			if equip.ability == "EXTRAITEMS" and math.random() < .1 then
				ExtraItem(owner, ent)
			end

			ent.components.crop:Harvest(owner)
			collected = collected + 1
		end
	end

	if equip:HasTag("goldentool") then
		equip.components.finiteuses:Use(collected / TUNING.GOLDENTOOLFACTOR)
	else
		equip.components.finiteuses:Use(collected)
	end
end

local function OnEquip(inst, owner)
	if inst:HasTag("goldentool") then
		owner.AnimState:OverrideSymbol("swap_object", "swap_goldenscythe", "swap_goldenscythe")
		owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
	else
		owner.AnimState:OverrideSymbol("swap_object", "swap_scythe", "swap_scythe")
	end
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
	owner:AddTag("holding_scythe")
	owner:ListenForEvent("onareapick", OnAreaPick)
	AreaDamage(owner, true)
end

local function OnUnequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
	owner:RemoveTag("holding_scythe")
	owner:RemoveEventCallback("onareapick", OnAreaPick)
	AreaDamage(owner, false)
end

local function common_fn(bank, build, golden)
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()

	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank(bank)
	inst.AnimState:SetBuild(build)
	inst.AnimState:PlayAnimation("idle")

	if golden then
		inst:AddTag("goldentool")
	end
	inst:AddTag("sharp")
	inst:AddTag("tool")
	inst:AddTag("weapon")
	inst:AddTag("bramble_resistant")

	MakeInventoryFloatable(inst, "med", 0.05, {0.75, 0.4, 0.75}, true, -11, {sym_build = build})

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
		return inst
	end

	inst:AddComponent("tool")

	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(TUNING.SCYTHE_USES)
	inst.components.finiteuses:SetUses(TUNING.SCYTHE_USES)
	inst.components.finiteuses:SetOnFinished(inst.Remove)

	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(TUNING.SCYTHE_DAMAGE)
	inst.components.weapon.attackwear = inst:HasTag("goldentool") and 2 / TUNING.GOLDENTOOLFACTOR or 2		--double consumption when attack

	inst:AddComponent("inspectable")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = bank
	inst.components.inventoryitem.atlasname = "images/inventoryimages/"..bank..".xml"

	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(OnEquip)
	inst.components.equippable:SetOnUnequip(OnUnequip)

	MakeHauntableLaunch(inst)
	return inst
end

local function normal()
	return common_fn("scythe", "swap_scythe")
end

local function golden()
	return common_fn("goldenscythe", "swap_goldenscythe", true)
end

return 	Prefab("common/inventory/scythe", normal, assets),
		Prefab("common/inventory/goldenscythe", golden, golden_assets)