env._G = GLOBAL

--Beard economy tuning
local BEARD_DAYS = { 8, 16, 32 }
local BEARD_BITS = { 1,  3,  9 }

local beard_prizes = {
	wurt = "fish",
	wx78 = "trinket_6",
	waxwell = "nightmarefuel",
	walter = "baconeggs",
	wolfgang = "hambat",
	wormwood = "cutgrass",
	wes = "balloon",
	wickerbottom = "cutreeds",
	wendy = "boneshard",
	wathgrithr = "cookedmeat",
	willow = "houndfire",
	winona = "gears",
	warly = "spice_salt",
	wortox = "spider_warrior"
}

local function GrowBeard(inst, bits)
	local length = bits == BEARD_BITS[1] and "short" or (bits == BEARD_BITS[2] and "medium" or "long")
	inst.AnimState:OverrideSymbol("beard", "beard", "beard_"..length)
	inst.components.beard.bits = bits
end

AddPlayerPostInit(function(inst)
	inst:AddTag("bearded")

	if _G.TheNet:GetIsServer() then
		if not inst.components.beard then
			inst:AddComponent("beard")
			inst.components.beard.onreset = function() inst.AnimState:ClearOverrideSymbol("beard") end
			inst.components.beard.prize = beard_prizes[inst.prefab] or "beardhair"
			inst.components.beard:AddCallback(BEARD_DAYS[1], function() GrowBeard(inst, BEARD_BITS[1]) end)
    		inst.components.beard:AddCallback(BEARD_DAYS[2], function() GrowBeard(inst, BEARD_BITS[2]) end)
    		if inst.prefab == "wickerbottom" or inst.prefab == "waxwell" then
    			inst.components.beard:AddCallback(BEARD_DAYS[3], function() GrowBeard(inst, BEARD_BITS[3]) end)
    		end
		end
	end
end)