PrefabFiles = {
	"webber",
	"wathgrithr",
	"spear_wathgrithr",	
	"wathgrithrhat",
	-- "wathgrithr_spirit",
}

Assets =
{
	Asset( "IMAGE", "images/saveslot_portraits.tex"),
	Asset( "ATLAS", "images/saveslot_portraits.xml"),
	
	Asset( "IMAGE", "images/selectscreen_portraits.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits.xml" ),

    Asset( "IMAGE", "bigportraits/wathgrithr.tex" ),
    Asset( "ATLAS", "bigportraits/wathgrithr.xml" ),

    Asset( "IMAGE", "bigportraits/webber.tex" ),
    Asset( "ATLAS", "bigportraits/webber.xml" ),

    Asset( "IMAGE", "minimap/minimap_atlas.tex" ),
    Asset( "ATLAS", "minimap/minimap_data.xml" ),
	
	Asset("SOUNDPACKAGE", "sound/dontstarve_DLC001.fev"),
    Asset("SOUND", "sound/wathgrithr.fsb"),
	Asset("SOUND", "sound/webber.fsb"),
	
	Asset( "IMAGE", "images/avatars.tex" ),
    Asset( "ATLAS", "images/avatars.xml" ),	
}

local wathgrithr_spirit_fx =
    {
	    name = "wathgrithr_spirit", 
	    bank = "wathgrithr_spirit", 
	    build = "wathgrithr_spirit", 
    	anim = "wathgrithr_spirit",
	    sound = "dontstarve_DLC001/characters/wathgrithr/valhalla",
	    sounddelay = .2,
	    -- dlc = true,
    }

GLOBAL.table.insert(GLOBAL.require("fx"), wathgrithr_spirit_fx)

--#rezecib This is a fix for the recipe problem; you can no longer put recipes in character prefabs
-- because then when the host creates the game, some recipes won't be loaded;
-- when they do get loaded later, further connections will have garbled net data because the
-- new recipes change the size of the data (that's my guess)
--The approach here is to instead associate a tag with each recipe, then modify the function
-- that checks if they can see it to check for those tags
local OldIsRecipeValid = GLOBAL.IsRecipeValid
local function IsRecipeValid(recipe)
	return OldIsRecipeValid(recipe) and
		((GLOBAL.ThePlayer and GLOBAL.ThePlayer:HasTag(recipe.name.."_builder")) or not recipe.tagneeded)
end
GLOBAL.IsRecipeValid = IsRecipeValid

--#rezecib Had to move all the recipes here to support the above
local Recipe = GLOBAL.Recipe
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH

local recipes = 
{
	Recipe("spidereggsack", {Ingredient("silk", 12), Ingredient("spidergland", 6), Ingredient("papyrus", 6)}, RECIPETABS.TOWN, TECH.NONE),
	Recipe("wathgrithrhat", {Ingredient("goldnugget", 2), Ingredient("rocks", 2)}, RECIPETABS.WAR, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0}, nil, nil, nil, nil, true),
	Recipe("spear_wathgrithr", {Ingredient("twigs", 2), Ingredient("flint", 2), Ingredient("goldnugget", 2)}, RECIPETABS.WAR, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0}, nil, nil, nil, nil, true),
}
for k,v in pairs(recipes) do
	v.sortkey = -v.sortkey
	v.tagneeded = true
end
GLOBAL.STRINGS.RECIPE_DESC.SPIDEREGGSACK = "Get a little help from your friends."
-- local nest_recipe = Recipe("spidereggsack", {Ingredient("silk", 12), Ingredient("spidergland", 6), Ingredient("papyrus", 6)}, RECIPETABS.TOWN, TECH.NONE)
-- nest_recipe.sortkey = -nest_recipe.sortkey
-- GLOBAL.STRINGS.RECIPE_DESC.SPIDEREGGSACK = "Get a little help from your friends."
-- nest_recipe.tagneeded = true

--Remapping all their sounds to the RoG sound file
-- hopefully this is more robust than my prior method of replacing the SGwilson and SGwilson_ghost
--For some reason this doesn't work for any non-talk_LP remappings... so I'm keeping the SGs, ugh
local dsc = "dontstarve/characters/"
local dsrogc = "dontstarve_DLC001/characters/"
for k,v in pairs({'wathgrithr', 'webber'}) do
	-- print('remap sound:',v)
	RemapSoundEvent(dsc..v.."/death_voice",
					dsrogc..v.."/death_voice")
	RemapSoundEvent(dsc..v.."/hurt",
					dsrogc..v.."/hurt")
	RemapSoundEvent(dsc..v.."/talk_LP",
					dsrogc..v.."/talk_LP")
	RemapSoundEvent(dsc..v.."/emote",
					dsrogc..v.."/talk_LP")
	RemapSoundEvent(dsc..v.."/ghost_LP",
					dsrogc..v.."/talk_LP")
end

GLOBAL.STRINGS.CHARACTERS.WATHGRITHR = GLOBAL.require "speech_wathgrithr"
GLOBAL.STRINGS.CHARACTERS.WEBBER = GLOBAL.require "speech_webber"

--I use this method instead of AddModCharacter because most of their assets are already in the files
-- e.g. their avatars; for mod characters the game looks elsewhere for them
GLOBAL.table.insert(GLOBAL.DST_CHARACTERLIST, 'wathgrithr')
GLOBAL.table.insert(GLOBAL.DST_CHARACTERLIST, 'webber')

local function LobbyScreenPostInit(self)
	local OldOnBecomeActive = self.OnBecomeActive
	function self:OnBecomeActive()
		OldOnBecomeActive(self)
		self.profile:UnlockEverything()
		self.profile:Save()
	end
end
AddClassPostConstruct("screens/lobbyscreen", LobbyScreenPostInit)

local function SilkPostInit(inst)
	local function CanUpgrade(inst, target, doer)
		return doer:HasTag("spiderwhisperer")
	end
	if not GLOBAL.TheWorld.ismastersim then return end
    inst:AddComponent("upgrader")
    inst.components.upgrader.canupgradefn = CanUpgrade
    inst.components.upgrader.upgradetype = "SPIDER"
end
AddPrefabPostInit("silk", SilkPostInit)

local function SpiderDenPostInit(inst)
	local function OnStageAdvance(inst)
		inst.components.growable:DoGrowth()
		return true
	end
	local function OnUpgrade(inst)
		inst.AnimState:PlayAnimation(inst.anims.hit)
		inst.AnimState:PushAnimation(inst.anims.idle)
	end

	if not GLOBAL.TheWorld.ismastersim then return end
	
	if inst.components.growable.stage ~= 3 then
		inst:AddTag("upgradeablebysilk")
	end
	local OldSetStage = inst.components.growable.SetStage
	inst.components.growable.SetStage = function(self, stage)
		OldSetStage(self, stage)
		if stage < 3 then
			inst:AddTag("upgradeablebysilk")
		else
			inst:RemoveTag("upgradeablebysilk")
		end
	end
	
	inst:AddComponent("upgradeable")
	inst.components.upgradeable.upgradetype = "SPIDER"
	inst.components.upgradeable.onupgradefn = OnUpgrade
	inst.components.upgradeable.onstageadvancefn = OnStageAdvance
end
AddPrefabPostInit("spiderden", SpiderDenPostInit)

local function MonsterMeatPostInit(inst)
	inst:AddTag("monstermeat")
end
AddPrefabPostInit("monstermeat", MonsterMeatPostInit)
AddPrefabPostInit("cookedmonstermeat", MonsterMeatPostInit)
AddPrefabPostInit("monstermeat_dried", MonsterMeatPostInit)

local UPGRADE = GLOBAL.Action(0, false, true)
UPGRADE.str = "Upgrade"
UPGRADE.id = "UPGRADE"
UPGRADE.fn = function(act)
    if act.invobject and act.target then
        return act.target.components.upgradeable:Upgrade(act.invobject)
    end
end
AddAction(UPGRADE)

AddStategraphActionHandler("wilson", GLOBAL.ActionHandler(UPGRADE, "dolongaction"))

--#rezecib I want to revisit this tag-based system later. Although it seems to work fine...
-- the main reason I don't like this solution is because it doesn't preserve the "upgradetype"
-- system that the upgrader/upgradeable pair use
local function canupgrade(inst, doer, target, actions)
	-- if target.components.upgradeable
		-- and inst.components.upgrader:CanUpgrade(target, doer)
		-- and target.components.upgradeable:CanUpgrade() then
	if target:HasTag("upgradeableby"..inst.prefab) then
		GLOBAL.table.insert(actions, GLOBAL.ACTIONS.UPGRADE)
	end
end
AddComponentAction("USEITEM", "upgrader", canupgrade)

local function SpiderQueenPostInit(inst)
	if not GLOBAL.TheWorld.ismastersim then return end
	local sanityaura = inst.components.sanityaura.aura
	inst.components.sanityaura.aurafn = function(inst, observer)
		if observer.prefab == "webber" then return 0 end
		return sanityaura
	end
	inst.components.sanityaura.aura = 0
	
	local function Retarget(inst)
		if not inst.components.health:IsDead() and not inst.components.sleeper:IsAsleep() then
			local oldtarget = inst.components.combat.target

			local newtarget = GLOBAL.FindEntity(inst, 10, 
				function(guy) 
					if inst.components.combat:CanTarget(guy) then
						return guy:HasTag("character") and not guy:HasTag("monster")
					end
				end)
			
			if newtarget and newtarget ~= oldtarget then
				inst.components.combat:SetTarget(newtarget)
			end
		end
	end
	inst.components.combat:SetRetargetFunction(3, Retarget)
end
AddPrefabPostInit("spiderqueen", SpiderQueenPostInit)

--unlocks all the characters
local function LobbyScreenPostConstruct(self)
	local OldOnBecomeActive = self.OnBecomeActive
	function self:OnBecomeActive()
		OldOnBecomeActive(self)
		self.profile:UnlockEverything()
		self.profile:Save()
	end
end
AddClassPostConstruct('screens/lobbyscreen', LobbyScreenPostConstruct)