--[[
 /-----------------------------------\
|           Version History           |
 \-----------------------------------/

1.0 - Released
]]
modimport("scripts/cookpotfix.lua")

TUNING.TUNGSTEN_SPEAR_USES = 220
TUNING.TUNGSTEN_SPEAR_DAMAGE = 51 --Two hit kill vs Spiders (100 health). Very usefull
TUNING.TUNGSTEN_AXE_DAMAGE = 49
TUNING.TUNGSTEN_AXE_USES=420 --Blaze it
TUNING.FIREBLADE_DAMAGE = 55
TUNING.FIREBLADE_USES=250
TUNING.ARMORTUNGSTEN=1600
TUNING.ARMORTUNGSTEN_ABSORPTION=0.90
TUNING.TUNGSTEN_PICKAXE_DAMAGE = 49
TUNING.TUNGSTEN_PICKAXE_USES=420 --Blaze it

PrefabFiles = 
{
"additional_walls",
"energy_fire",
"tungstenore",
"tungsten",
"rock_tough",
"potion_health",
"potion_restoration",
"potion_sanity",
"potion_insanity",
"tungsten_firepit",
"tungsten_axe",
"armor_tungsten",
"fireblade",
"tungsten_pickaxe",
}

Assets = 
{
	Asset("ATLAS", "images/inventoryimages/tungstenore.xml"),
	Asset("ATLAS", "images/inventoryimages/tungsten.xml"),
	Asset("ATLAS", "images/inventoryimages/rock_tough.xml"),
	Asset("ATLAS", "images/inventoryimages/potion_health.xml"),
	Asset("ATLAS", "images/inventoryimages/potion_restoration.xml"),
	Asset("ATLAS", "images/inventoryimages/potion_sanity.xml"),
	Asset("ATLAS", "images/inventoryimages/potion_insanity.xml"),
	Asset("ATLAS", "images/inventoryimages/tungsten_firepit.xml"),
	Asset("ATLAS", "images/inventoryimages/tungsten_axe.xml"),
	Asset("ATLAS", "images/inventoryimages/armor_tungsten.xml"),
	Asset("ATLAS", "images/inventoryimages/fireblade.xml"),
	Asset("ATLAS", "images/inventoryimages/wall_tungsten_item.xml"),
	Asset("ATLAS", "images/inventoryimages/tungsten_pickaxe.xml"),
	}

--IMPORTANT FOR READERS: TUNGSTEN & tungsten = tungsten spear
--        				 TUNGSTENORE & tungstenore = tungsten item (tungsten nugget or tungsten ore, whatever it's called in this version)
--Please don't get confused. If you've got any question about modding, just ask on the Steamworkshop page, if I've got some spare time, I don't mind helping anyone with LUA or modding in general

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local TECH = GLOBAL.TECH

GLOBAL.HUMAN_MEAT_ENABLED = true --MUHAHAHAHAHAHAHA (<- evil laugh)

GLOBAL.STRINGS.NAMES.TUNGSTEN = "Tungsten Spear"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTEN = "Forged in fire"


GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TUNGSTEN = "It looks so sharp"
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.TUNGSTEN="C HOW # IT IS?"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.TUNGSTEN = "This is better than some flint weapon!"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.TUNGSTEN = "I feel like impaling something..."
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.TUNGSTEN = "It's not like I'd need this thing"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.TUNGSTEN = "Would be better if it burned, though"


GLOBAL.STRINGS.NAMES.TUNGSTENORE = "Tungsten Nugget"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTENORE = "Metallic Material"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TUNGSTENORE = "What a tough stone"
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.TUNGSTENORE="HARDNESS > 8"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.TUNGSTENORE = "Tungsten... also referred to as Wolfram"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.TUNGSTENORE = "It's harder than all the other rocks"
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.TUNGSTENORE = "Hard materials for a hard man"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.TUNGSTENORE = "Time to create something dangerous with it"


GLOBAL.STRINGS.NAMES.ROCK_TOUGH = "Tough Stone"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ROCK_TOUGH = "Is it better than gold?"
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.ROCK_TOUGH="HARD ROCK CONTAINS HEAVY METAL"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.ROCK_TOUGH = "Where have I seen these kind of boulders before..?"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.ROCK_TOUGH = "Let's smash it into pieces"
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.ROCK_TOUGH = "Not as tough as me!"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.ROCK_TOUGH = "These look kind of funny"

GLOBAL.STRINGS.NAMES.POTION_HEALTH = "Potion of Health"

GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.POTION_HEALTH="REPAIRATION FLUID"

GLOBAL.STRINGS.NAMES.POTION_RESTORATION = "Potion of Restoration"

GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.POTION_RESTORATION="TIME TO ERASE ALL ERRORS"

GLOBAL.STRINGS.NAMES.POTION_INSANITY = "Potion of Insanity"

GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.POTION_INSANITY="DON'T DO DRUGS"

GLOBAL.STRINGS.NAMES.POTION_SANITY = "Potion of Sanity"

GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.POTION_SANITY="EXTENDS COGNITIVE FUNCTIONS"

GLOBAL.STRINGS.NAMES.TUNGSTEN_FIREPIT = "Tungsten Firepit"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTEN_FIREPIT = "Improved Firepit that gives off more heat"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TUNGSTEN_FIREPIT = "This makes me wonder if I could harness the power of the sun..."
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.TUNGSTEN_FIREPIT="WARNING! TEMPERATURE ON CONSTANT HIGH LEVEL!"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.TUNGSTEN_FIREPIT = "This fire seems to be highly effecient."
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.TUNGSTEN_FIREPIT = "A portal to Hell!"
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.TUNGSTEN_FIREPIT = "Fire makes my muscles weep! Is good!"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.TUNGSTEN_FIREPIT = "That's a little hot even for ME!"


GLOBAL.STRINGS.NAMES.TUNGSTEN_AXE = "Corrupt Cutter"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTEN_AXE = "It hates Trees"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TUNGSTEN_AXE ="Made from 50% real Treeguard!" 
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.TUNGSTEN_AXE="RUN COMMAND; DEFORESTATION.EXE"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.TUNGSTEN_AXE = "Not Environmentally Friendly"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.TUNGSTEN_AXE = "Everything dies eventually. Even Trees."
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.TUNGSTEN_AXE = "Wood is WEAK, I am MIGHTY!"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.TUNGSTEN_AXE = "Where do Trees go when they die? ON THE FIRE!"


GLOBAL.STRINGS.NAMES.ARMOR_TUNGSTEN = "Zero Kelvin Suit"
GLOBAL.STRINGS.RECIPE_DESC.ARMOR_TUNGSTEN = "Cold as deep space"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ARMOR_TUNGSTEN ="Hmm, so safety can be cool? Who knew!"
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.ARMOR_TUNGSTEN="THE COLD IS IRRELEVANT"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.ARMOR_TUNGSTEN = "A low temperature protective device"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.ARMOR_TUNGSTEN = "Cold deep inside, like Abigail."
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.ARMOR_TUNGSTEN = "Stay Safe, Stay Cool, Stay MIGHTY!"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.ARMOR_TUNGSTEN = "Safe AND Cold, That's no fun!"


GLOBAL.STRINGS.NAMES.FIREBLADE = "Fire Blade"
GLOBAL.STRINGS.RECIPE_DESC.FIREBLADE = "Might be too hot for you"

GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.FIREBLADE = "I don't mind the heat"

GLOBAL.STRINGS.NAMES.WALL_TUNGSTEN_ITEM = "Tungsten Wall"
GLOBAL.STRINGS.RECIPE_DESC.WALL_TUNGSTEN_ITEM = "Better protection for your Base"

GLOBAL.STRINGS.NAMES.WALL_TUNGSTEN = "Tungsten Wall"

GLOBAL.STRINGS.NAMES.TUNGSTEN_PICKAXE = "Infiniminer"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTEN_PICKAXE = "Feasts upon the blood of your foes"



local tungsten = GLOBAL.Recipe("tungsten", { Ingredient("twigs", 3), Ingredient("rope", 1), Ingredient("tungstenore", 2,"images/inventoryimages/tungstenore.xml")}, RECIPETABS.WAR,  TECH.SCIENCE_TWO)--{ Ingredient("twigs", 3), Ingredient("rope", 1), Ingredient("tungstenore", 2,"images/inventoryimages/tungstenore.xml")}
tungsten.atlas = "images/inventoryimages/tungsten.xml"

AddMinimapAtlas("images/inventoryimages/rock_tough.xml")

--local tungsten_axe = GLOBAL.Recipe("tungsten_axe",{}, RECIPETABS.TOOLS,  TECH.NONE)
local tungsten_axe = GLOBAL.Recipe("tungsten_axe", { Ingredient("purplegem",1),Ingredient("livinglog", 2), Ingredient("tungstenore", 4,"images/inventoryimages/tungstenore.xml")}, RECIPETABS.TOOLS,  TECH.MAGIC_TWO)
tungsten_axe.atlas = "images/inventoryimages/tungsten_axe.xml"

--local armor_tungsten = GLOBAL.Recipe("armor_tungsten", {}, RECIPETABS.WAR,  TECH.NONE)
local armor_tungsten = GLOBAL.Recipe("armor_tungsten", { Ingredient("bluegem",1), Ingredient("tungstenore", 4,"images/inventoryimages/tungstenore.xml"),Ingredient("moonrocknugget",2)}, RECIPETABS.WAR,  TECH.MAGIC_TWO)
armor_tungsten.atlas = "images/inventoryimages/armor_tungsten.xml"

local fireblade = GLOBAL.Recipe("fireblade", { Ingredient("redgem", 2),Ingredient("tungstenore", 5,"images/inventoryimages/tungstenore.xml"),Ingredient("nightmarefuel", 2)}, RECIPETABS.WAR,  TECH.MAGIC_TWO)
--local fireblade = GLOBAL.Recipe("fireblade", { Ingredient("twigs", 3)}, RECIPETABS.WAR,  TECH.NONE)
fireblade.atlas = "images/inventoryimages/fireblade.xml"

local wall_tungsten_item=GLOBAL.Recipe("wall_tungsten_item", {Ingredient("cutstone", 1),Ingredient("tungstenore", 1,"images/inventoryimages/tungstenore.xml")}, RECIPETABS.TOWN, TECH.SCIENCE_TWO,nil,nil,nil,6)--Ingredient("cutstone", 1),Ingredient("tungstenore", 1,"images/inventoryimages/tungstenore.xml")
wall_tungsten_item.atlas="images/inventoryimages/wall_tungsten_item.xml"

--local tungsten_pickaxe = GLOBAL.Recipe("tungsten_pickaxe",{}, RECIPETABS.TOOLS,  TECH.NONE)
local tungsten_pickaxe = GLOBAL.Recipe("tungsten_pickaxe", { Ingredient("purplegem",1),Ingredient("livinglog", 3), Ingredient("tungstenore", 5,"images/inventoryimages/tungstenore.xml")}, RECIPETABS.TOOLS,  TECH.MAGIC_TWO)
tungsten_pickaxe.atlas = "images/inventoryimages/tungsten_pickaxe.xml"


local potion_health = {
		name = "potion_health",
	    test = function(cooker, names, tags) return names.red_cap and names.red_cap >= 2 and not tags.meat and not tags.fruit and not tags.decoration and not tags.egg and not tags.inedible end,
		priority = 3,
		weight = 1,
		foodtype = "GENERIC",
		cooktime = 1.5,
	}
	AddCookerRecipe("cookpot", potion_health)
potion_health.atlas = "images/inventoryimages/potion_health.xml"

local potion_restoration = {
		name = "potion_restoration",
	    test = function(cooker, names, tags) return names.frog_legs and names.blue_cap and not tags.fruit and not tags.decoration and not tags.egg and not tags.inedible end,
		priority = 20,
		weight = 1,
		foodtype = "GENERIC",
		cooktime = 2.0,
	}
	AddCookerRecipe("cookpot", potion_restoration)
potion_restoration.atlas = "images/inventoryimages/potion_restoration.xml"


	local potion_insanity = {
		name = "potion_insanity",
	    test = function(cooker, names, tags) return names.blue_cap and names.blue_cap >= 2 and not tags.meat and not tags.fruit and not tags.decoration and not tags.egg and not tags.inedible end,
		priority = 4,
		weight = 1,
		foodtype = "GENERIC",
		cooktime = 1.1,
	}
	AddCookerRecipe("cookpot", potion_insanity)
potion_insanity.atlas = "images/inventoryimages/potion_insanity.xml"

	local potion_sanity = {
		name = "potion_sanity",
	    test = function(cooker, names, tags) return names.green_cap and names.green_cap >= 2 and not tags.meat and not tags.fruit and not tags.decoration and not tags.egg and not tags.inedible end,
		priority = 2,
		weight = 1,
		foodtype = "GENERIC",
		cooktime = 1.3,
	}
	AddCookerRecipe("cookpot", potion_sanity)
potion_sanity.atlas = "images/inventoryimages/potion_sanity.xml"

local tungsten_firepit = Recipe("tungsten_firepit", 
			{
				Ingredient("tungstenore", 4,"images/inventoryimages/tungstenore.xml"), 
				Ingredient("cutstone", 5), 
				Ingredient("boards", 3)
			},
			RECIPETABS.LIGHT, TECH.SCIENCE_TWO, 
			"tungsten_firepit_placer")

tungsten_firepit.atlas = "images/inventoryimages/tungsten_firepit.xml"