local assets =
{
	Asset("ANIM", "anim/energy_fire.zip"),
	Asset("SOUND", "sound/common.fsb"),
}

local heats = { 120, 180, 220, 280 }
local function GetHeatFn(inst)
	return heats[inst.components.firefx.level] or 30
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddLight()
    inst.entity:AddNetwork()

    inst.AnimState:SetBank("campfire_fire")
    inst.AnimState:SetBuild("energy_fire")
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst.AnimState:SetRayTestOnBB(true)
    inst.AnimState:SetFinalOffset(-1)
    
    inst:AddTag("fx")

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

    inst:AddComponent("heater")
    inst.components.heater.heatfn = GetHeatFn

    inst:AddComponent("firefx")
    inst.components.firefx.levels =
    {
        {anim="level1", sound="dontstarve/common/campfire", radius=3, intensity=.8, falloff=.33, colour = {255/255,135/255,255/255}, soundintensity=.1},
        {anim="level2", sound="dontstarve/common/campfire", radius=4, intensity=.8, falloff=.33, colour = {255/255,135/255,255/255}, soundintensity=.3},
        {anim="level3", sound="dontstarve/common/campfire", radius=5, intensity=.8, falloff=.33, colour = {255/255,135/255,255/255}, soundintensity=.6},
        {anim="level4", sound="dontstarve/common/campfire", radius=6, intensity=.8, falloff=.33, colour = {255/255,135/255,255/255}, soundintensity=1},
    }
    
    inst.components.firefx:SetLevel(1)
    inst.components.firefx.usedayparamforsound = true
    return inst
end

return Prefab("common/fx/energy_fire", fn, assets)