local assets =
{
	Asset("ANIM", "anim/fireblade.zip"),
	Asset("ANIM", "anim/swap_fireblade.zip"),
	Asset("ATLAS", "images/inventoryimages/fireblade.xml"),
    
}

--OK, just a few little annotations for people who don't know what I'm doing right here...
--The player implements a component called "temperature", ranging from -20 to 40
--There are two possibilities. 1: owner temperature is below 40 degrees 2: owner temperature is at (almost) 40 degrees
--If owner temperature is above 40 degrees, do damage (except for willow -> how do i get the character of the owner??)

local function overheatfn(inst, owner)
	if owner and owner.components and owner.components.health and owner.components.temperature and owner.components.temperature.current > (owner.components.temperature.maxtemp-1) then
		if owner.prefab~='willow' then
			owner.components.health:DoDelta(-1,false,"fireblade")
		else
			owner.components.sanity:DoDelta(1,false,"fireblade")
		end
	elseif owner and owner.components and owner.components.temperature then
		owner.components.temperature.current= owner.components.temperature.current+1.3
	end 
	inst.components.finiteuses:Use(0.1)
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_fireblade", "swap_nightmaresword")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
	inst.dotick=true
	inst.task=inst:DoPeriodicTask(1, overheatfn,nil,owner)
end

local function onattack(weapon, attacker, target)
    if target ~= nil and target.components.burnable ~= nil and math.random() < TUNING.TORCH_ATTACK_IGNITE_PERCENT * target.components.burnable.flammability then
        target.components.burnable:Ignite()
    end
end



local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	if inst.task ~= nil then
		inst.dotick=false
        inst.task:Cancel()
        inst.task = nil
    end
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
	

    if not TheWorld.ismastersim then
        return inst
    end

    inst.AnimState:SetBank("nightmaresword")
    inst.AnimState:SetBuild("fireblade")
    inst.AnimState:PlayAnimation("idle")

	inst:AddComponent("heater")
    inst.components.heater.iscooler = false
	inst.components.heater.carriedheat = 5
    inst.components.heater.equippedheat = 15
    
    inst:AddTag("metal")
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.FIREBLADE_DAMAGE)
	inst.components.weapon:SetAttackCallback(onattack)

    -------

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.FIREBLADE_USES)
    inst.components.finiteuses:SetUses(TUNING.FIREBLADE_USES)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/fireblade.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    MakeHauntableLaunch(inst)

    return inst
end

return Prefab("common/inventory/fireblade", fn, assets)