local Assets=
{
    Asset("ANIM", "anim/potion_sanity.zip"),
	Asset("ATLAS", "images/inventoryimages/potion_sanity.xml"),
	Asset("IMAGE", "images/inventoryimages/potion_sanity.tex"),
}



local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBuild("potion_sanity") -- Stolen from the chocolate mod... had to use their .build
    inst.AnimState:SetBank("chocolate")
    inst.AnimState:PlayAnimation("idle", false)
	
	inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
	
	if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddTag("preparedfood")
				
   inst:AddComponent("edible")
    inst.components.edible.healthvalue = -5
    inst.components.edible.hungervalue = -45
    inst.components.edible.sanityvalue = 50
    inst.components.edible.foodtype = FOODTYPE.GENERIC
	

	

    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERSLOW)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/potion_sanity.xml"	
	
	

    return inst
end

return Prefab( "common/inventory/potion_sanity", fn, Assets) 
