local assets=
{
	Asset("ANIM", "anim/tungstenore.zip"),
	Asset("ATLAS", "images/inventoryimages/tungstenore.xml"),
	Asset("IMAGE", "images/inventoryimages/tungstenore.tex")
}


local function shine(inst)
    inst.task = nil
    inst.AnimState:PlayAnimation("sparkle")
    inst.AnimState:PushAnimation("idle")
    inst.task = inst:DoTaskInTime(4 + math.random() * 5, shine)
end


local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
    inst.entity:AddSoundEmitter()
	
	
    if not TheWorld.ismastersim then
        return inst
    end
    
    inst.AnimState:SetRayTestOnBB(true);    
    inst.AnimState:SetBank("flint")
    inst.AnimState:SetBuild("tungstenore")
    inst.AnimState:PlayAnimation("idle")
	
    inst:AddComponent("tradable")
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/tungstenore.xml"

	inst:AddComponent("repairer")
	inst.components.repairer.repairmaterial = "tungsten"
	inst.components.repairer.workrepairvalue = 1
    inst.components.repairer.healthrepairvalue = 75
	
    MakeHauntableLaunchAndSmash(inst)	
	shine(inst)
	
    return inst
end

return Prefab( "common/inventory/tungstenore", fn, assets) 
