local require = GLOBAL.require
local TheInput = GLOBAL.TheInput
local ThePlayer = GLOBAL.ThePlayer
local UICompass = require "widgets/uicompass"

Assets = {
	Asset("ANIM", "anim/uicompass-style1.zip"),
	Asset("ATLAS", "images/arrow-style1.xml"),
	Asset("ANIM", "anim/uicompass-style2.zip"),
	Asset("ATLAS", "images/arrow-style2.xml"),
}


UICOMPASS_OPTION = 
{
	STYLE = GetModConfigData("uicompass_style"),
	POSITION = GetModConfigData("uicompass_pos"),
	VISIBILITY = GetModConfigData("uicompass_visibility"),
}

-- init compass hud
function AddCompassHud(controls)

	local uicompass = UICompass()
	
	-- init Style
	uicompass:ChangeStyle(UICOMPASS_OPTION.STYLE)

	-- add to sidepanel
	controls.sidepanel:AddChild(uicompass)

	-- check visibility
	if (UICOMPASS_OPTION.VISIBILITY) then
		uicompass:Show()
	else
		uicompass:Hide()
	end

	-- TODO: adjust mod position
	
	-- raise rotate event
	local lastrottime = nil
	local onupdate_base = controls.OnUpdate
	controls.OnUpdate = function (self, dt)
		onupdate_base(self, dt)
    	local time = GLOBAL.GetTime()
    	local ROT_REPEAT = 0.25
    	if not lastrottime or time - lastrottime > ROT_REPEAT then
    		--[[ can't rotate the pointer of compass in the follow scenes
    		1. while the game was paused(ESC) =FINISHED=
    		2. if the debug console was on, and the commend has the Rotation Key =FINISHED=
    		3. while the TAB was pressed.=FINISHED=
    		4. if the player was hit by panflute(will sleep and the map can't rotate) =TODO=
    		--]]
    		if TheInput:IsControlPressed(GLOBAL.CONTROL_ROTATE_LEFT) 
    			and not TheInput:IsControlPressed(GLOBAL.CONTROL_SHOW_PLAYER_STATUS) 
    			and not GLOBAL.IsPaused() then
    			GLOBAL.ThePlayer:PushEvent("rotleft")
    			lastrottime = time
	    	elseif TheInput:IsControlPressed(GLOBAL.CONTROL_ROTATE_RIGHT) 
	    		and not TheInput:IsControlPressed(GLOBAL.CONTROL_SHOW_PLAYER_STATUS) 
	    		and not GLOBAL.IsPaused() then
    			GLOBAL.ThePlayer:PushEvent("rotright")
    			lastrottime = time
    		end
    	end
	end

end


AddClassPostConstruct("widgets/controls", AddCompassHud)