local Widget = require "widgets/widget"
local Image = require "widgets/image"
local Text = require "widgets/text"
local UIAnim = require "widgets/uianim"

local UICompass = Class(Widget, function (self)
	Widget._ctor(self, "UICompass")

    self.anim = nil
    self.hands = nil
    self.current_rotation = 0
    self.style = nil

    self.lastrottime = nil
    self.isknockedout = false

    self.rotangle = 
    {
        N=-45, S=135,
        NE=0, E=45, SE=90,
        NW=-90, W=-135, SW=180,
    }

	self.base_scale = 1	
	self:SetScale(self.base_scale,self.base_scale,self.base_scale)	
	self:SetPosition(-160,-4,0)	

	self.inst:ListenForEvent("rotleft", function() self:RotLeft() end, ThePlayer)
    self.inst:ListenForEvent("rotright", function() self:RotRight() end, ThePlayer)

    -- self.inst:ListenForEvent("knockedout", function () self.isknockedout = true end, ThePlayer)
    -- self.inst:ListenForEvent("wakeup", function () self.isknockedout = false end, ThePlayer)
end)

function UICompass:GetDirection()
        
    local heading = TheCamera:GetHeading()--inst.Transform:GetRotation() 
    local dir, closest_diff = nil, nil

    local dirs = 
    {
        N=0, S=180,
        NE=45, E=90, SE=135,
        NW=-45, W=-90, SW=-135, 
    }

    for k,v in pairs(dirs) do
        local diff = math.abs(anglediff(heading, v))
        if not dir or diff < closest_diff then
            dir, closest_diff = k, diff
        end
    end
    return dir
end

function UICompass:ResetCompass()
    if self.hands ~= nil then 
        self:RemoveChild(self.hands)
    end
    local str_hands_xml = string.format("images/arrow-%s.xml", self.style)
    local str_hands_tex = string.format("arrow-%s.tex", self.style)
    self.hands = self:AddChild(Image(str_hands_xml, str_hands_tex))
    self.current_rotation = 0
end

function UICompass:VerifyCompass()
    local current_direction = self:GetDirection()
    print (current_direction)
    self.current_rotation = self.rotangle[current_direction]
    print (self.current_rotation)


end

function UICompass:GetCurrentRotation()
    return self.current_rotation
end

function UICompass:RotLeft()

    if not TheCamera:CanControl() then
        return
    end
    -- self:VerifyCompass()
    self.inst:DoTaskInTime(0.125, function(inst)
        local current_direction = self:GetDirection()
        self.current_rotation = self.rotangle[current_direction]
        self.hands:SetRotation(self.current_rotation)
    end)

end

function UICompass:RotRight()

    if not TheCamera:CanControl() then
        return
    end
    -- self:VerifyCompass()
    self.inst:DoTaskInTime(0.125, function(inst)
        --[[
        self.current_rotation = self.current_rotation + 45
        if self.current_rotation == 225 then
            self.current_rotation = -135
        end
        self.hands:SetRotation(self.current_rotation)
        --]]
        local current_direction = self:GetDirection()
        self.current_rotation = self.rotangle[current_direction]
        self.hands:SetRotation(self.current_rotation)
    end)

end

function UICompass:SetCustomPosition(pos_x, pos_y)
    self:SetPosition(pos_x, pos_y, 0)
end

function UICompass:ChangeStyle(uicompass_style)
    -- save style
    self.style = uicompass_style
    -- remove old compass style
    if self.hands ~= nil then
        self:RemoveChild(self.hands)
    end
    if self.anim ~= nil then
        self.RemoveChild(self.anim)
    end

    -- set up new compass style
    local str_anim = string.format("uicompass-%s", uicompass_style)
    self.anim = self:AddChild(UIAnim())
    self.anim:SetScale(self.base_scale, self.base_scale, self.base_scale)
    self.anim:GetAnimState():SetBank("clock01")
    self.anim:GetAnimState():SetBuild(str_anim)
    self.anim:GetAnimState():PlayAnimation("idle_day", true)

    local str_hands_xml = string.format("images/arrow-%s.xml", uicompass_style)
    local str_hands_tex = string.format("arrow-%s.tex", uicompass_style)
    self.hands = self:AddChild(Image(str_hands_xml, str_hands_tex))
end

return UICompass