
local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/seras.zip" ),
        Asset( "ANIM", "anim/ghost_seras_build.zip" ),
    		Asset( "ANIM", "anim/seras_fed.zip" ),
    		Asset( "ANIM", "anim/seras_starved.zip" ),
    		Asset( "ANIM", "anim/seras_sunlight.zip" ),
    		Asset( "ANIM", "anim/seras_nightmare.zip" ),
    		
    		
}
local prefabs = {}

local commentMoonlight = 1

-- Level Up System --
-- XP Chart:
-- Pig/Bunnyman = 100 XP
-- Player = 500 XP
local experience = 0 -- EXPERIENCE IS NOT RETAINED IN SAVED GAMES. I NEED TO FIX THIS
local level = 0

-- Attributes --
local baseHealth = 100
local baseStomache = 150
local baseDmgMult = 1
local walkSpeed = 1
local currentLevel = 0

-- level up system
-- Currently levels on its own.
local function onExperienceGain(inst)
    experience = experience + 100
    if experience >= 66600 and level < 10 then
        -- Level 6 (easter egg level!) (666 pigs)
        level = 10
        inst.components.hunger:SetMax(300)
        baseDmgMult = 2.5
        walkSpeed = 1.25
        baseHealth = 400
        inst.components.talker:Say("I have become a True Vampire!")
        
    elseif experience >= 10000 and level < 9 then
        -- Level 5 (100 pigs)
        level = 9
        baseHealth = 200
        inst.components.hunger:SetMax(250)
        walkSpeed = 1.1
        baseDmgMult = 1.5
        inst.components.talker:Say("My power is still growing... Alucard would be proud.")
    
    elseif experience >= 6600 and level < 8 then
        -- Level 5 (66 pigs)
        level = 8
        baseHealth = 190
        inst.components.hunger:SetMax(240)
        walkSpeed = 1.09
        baseDmgMult = 1.45
        inst.components.talker:Say("I'm... becoming a monster.")
    
    elseif experience >= 4000 and level < 7 then
        -- Level 4 (40x pigs)
        level = 7
        baseHealth = 180
        inst.components.hunger:SetMax(230)
        walkSpeed = 1.08
        baseDmgMult = 1.4
        inst.components.talker:Say("Am I losing the last of my humanity?")
    
    elseif experience >= 3200 and level < 6 then
        -- Level 2 (32x pigs)
        level = 6
        baseHealth = 170
        inst.components.hunger:SetMax(220)
        walkSpeed = 1.07
        baseDmgMult = 1.35
        inst.components.talker:Say("I feel warm. Almost burning with power.")
        
    elseif experience >= 2400 and level < 5 then
        -- Level 3 (24 pigs)
        level = 5
        baseHealth = 160
        inst.components.hunger:SetMax(210)
        walkSpeed = 1.06
        baseDmgMult = 1.3
        inst.components.talker:Say("Ah... I can feel dark power within.")
    
    elseif experience >= 1400 and level < 4 then
        -- Level 2 (16 pigs)
        level = 4
        baseHealth = 150
        inst.components.hunger:SetMax(200)
        walkSpeed = 1.05
        baseDmgMult = 1.25
        inst.components.talker:Say("I feel lighter and more... powerful.")
        
    elseif experience >= 800 and level < 3 then
        -- Level 2 (8x pigs)
        level = 3
        baseHealth = 140
        inst.components.hunger:SetMax(190)
        walkSpeed = 1.04
        baseDmgMult = 1.2
        inst.components.talker:Say("I feel... stronger.")
        
    elseif experience >= 400 and level < 2 then
        -- Level 2 (4x pigs)
        level = 2
        baseHealth = 130
        inst.components.hunger:SetMax(180)
        walkSpeed = 1.03
        baseDmgMult = 1.15
        inst.components.talker:Say("I can feel a bit of my power returning to me.")
        
    elseif experience >= 1 and level < 1 then
        -- Level 1 (1x pig)
        level = 1
        baseHealth = 120
        inst.components.hunger:SetMax(170)
        walkSpeed = 1.02
        baseDmgMult = 1.1
        inst.components.talker:Say("The blood... I can feel its power.")
    end
    
end


local tempCaveVar = false --Replace this once caves are out

--startregen parameters: first parameter = tick size. second parameter = tick frequency

-- stat/apperance differences night/day hungry/starved
local function updatestats(inst)
  if inst.sg:HasStateTag("nomorph") or
          inst:HasTag("playerghost") or
          inst.components.health:IsDead() then
          return
  end
	local health_percent = inst.components.health:GetPercent()
    if TheWorld.state.isday then
		if inst.strength == "mighty" then
		      -- HP 100 - 200
    			inst.components.health.maxhealth = 0.8 * baseHealth -10
    			inst.components.health:StopRegen()
    			inst.components.combat.damagemultiplier = 0.8 * baseDmgMult
    			inst.components.hunger:SetRate(2*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL
    			inst.components.temperature.inherentinsulation = 30*6
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.1 * walkSpeed)
    			inst.AnimState:SetBuild("seras")
    			commentMoonlight = 1
  		elseif inst.strength == "normal" then
  		    -- HP 80 - 180
          inst.components.health.maxhealth = 0.8 * baseHealth - 15
          inst.components.health:StopRegen()
          inst.components.combat.damagemultiplier = 0.6 * baseDmgMult
          inst.components.hunger:SetRate(0.8*TUNING.WILSON_HUNGER_RATE)	
          inst.components.sanity.dapperness = 0
          inst.components.temperature.inherentinsulation = 30*4
          inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.0 * walkSpeed)
          inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.0 * walkSpeed)
          inst.AnimState:SetBuild("seras_sunlight")
          commentMoonlight = 1
  		elseif inst.strength == "wimpy" then
  		    -- HP 60 - 150
    			inst.components.health.maxhealth = 0.6 * baseHealth - 0
    			inst.components.health:StopRegen()
    			inst.components.combat.damagemultiplier = 0.4 * baseDmgMult
    			inst.components.hunger:SetRate(0.7*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL*-1
    			inst.components.temperature.inherentinsulation = 30*2
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.9 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.9 * walkSpeed)
    			inst.AnimState:SetBuild("seras_starved")
    			commentMoonlight = 1
  			
  		end		
  		inst.components.health:SetPercent(health_percent)
  		inst.Light:Enable(false)
		
	elseif TheWorld.state.isdusk then
  		if inst.strength == "mighty" then
  		    -- HP 200 - 300
    			inst.components.health.maxhealth = 1.00 * baseHealth + 100
    			inst.components.health:StartRegen(1 * baseHealth / 100, 5, false) 			--regeneration speed 1hp/ 3sec
    			inst.components.combat.damagemultiplier = 1.5 * baseDmgMult
    			inst.components.hunger:SetRate(1.5*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL
    			inst.components.temperature.inherentinsulation = 30*6
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.1 * walkSpeed)
    			inst.AnimState:SetBuild("seras_fed")
  		elseif inst.strength == "normal" then
  		    -- HP 150 - 250
    			inst.components.health.maxhealth = 	1.00 * baseHealth + 50
    			inst.components.health:StopRegen()
    			inst.components.combat.damagemultiplier = 1 * baseDmgMult
    			inst.components.hunger:SetRate(0.8*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = 0
    			inst.components.temperature.inherentinsulation = 30*4
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.0 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.0 * walkSpeed)
    			inst.AnimState:SetBuild("seras")
  		elseif inst.strength == "wimpy" then
  		    -- HP 70 - 150
    			inst.components.health.maxhealth = 0.70 * baseHealth - 10
    			inst.components.health:StopRegen()
    			inst.components.combat.damagemultiplier = 0.75 * baseDmgMult
    			inst.components.hunger:SetRate(0.7*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = TUNING.DAPPERNESS_MED*-1
    			inst.components.temperature.inherentinsulation = 30*2
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.9 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.9 * walkSpeed)
    			inst.AnimState:SetBuild("seras_starved")
  			
  		end
  		inst.components.health:SetPercent(health_percent)
  		inst.Light:Enable(false)
		
	elseif TheWorld.state.isnight then
  		if TheWorld.state.isfullmoon then
  		    -- HP 666 - 1332
    			inst.components.health.maxhealth = 666 + (634.00 * (baseHealth-100))
    			inst.components.health:StartRegen(3 * baseHealth / 100 , 0.5, false) 			--regeneration speed 2-4hp/ 1sec
    			inst.components.combat.damagemultiplier = 1.5 * baseDmgMult
    			inst.components.hunger:SetRate(-5*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = TUNING.DAPPERNESS_HUGE*-5
    			inst.components.temperature.inherentinsulation = 30*20
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.8 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.8 * walkSpeed)
    			inst.AnimState:SetBuild("seras_nightmare")
    			
    			if commentMoonlight == 1 then
      				inst.components.talker:Say("It's full moon. I don't feel right...")
      				commentMoonlight = 0
  			end
  			
  		  elseif inst.strength == "mighty" then
  		      -- HP 250 - 400
      			inst.components.health.maxhealth = 1.5 * baseHealth + 100
      			inst.components.health:StartRegen(1 * baseHealth / 100, 2, false) 			--regeneration speed 1hp/ 2sec
      			inst.components.combat.damagemultiplier = 1.33 * baseDmgMult
      			inst.components.hunger:SetRate(1*TUNING.WILSON_HUNGER_RATE)
      			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL
      			inst.components.temperature.inherentinsulation = 30*6
      			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2 * walkSpeed)
      			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2 * walkSpeed)
      			inst.AnimState:SetBuild("seras_fed")
    		elseif inst.strength == "normal" then
    		    -- HP 200 - 350
      			inst.components.health.maxhealth = 1.5 * baseHealth + 50
      			inst.components.health:StartRegen(1 * baseHealth / 100, 3, false) 			--regeneration speed 1hp/ 3sec
      			inst.components.combat.damagemultiplier = 1 * baseDmgMult
      			inst.components.hunger:SetRate(0.8*TUNING.WILSON_HUNGER_RATE)
      			inst.components.sanity.dapperness = 0
      			inst.components.temperature.inherentinsulation = 30*4
      			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1 * walkSpeed)
      			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.1 * walkSpeed)
      			inst.AnimState:SetBuild("seras_fed")
    		elseif inst.strength == "wimpy" then
    		    -- HP 100 - 200
      			inst.components.health.maxhealth = 1 * baseHealth + 0
      			inst.components.health:StopRegen()
      			inst.components.combat.damagemultiplier = 0.8 * baseDmgMult
      			inst.components.hunger:SetRate(0.7*TUNING.WILSON_HUNGER_RATE)
      			inst.components.sanity.dapperness = TUNING.DAPPERNESS_LARGE*-1
      			inst.components.temperature.inherentinsulation = 30*2
      			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.0 * walkSpeed)
      			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.0 * walkSpeed)
      			inst.AnimState:SetBuild("seras_starved")
    		end
    		inst.components.health:SetPercent(health_percent)
    		inst.Light:Enable(true)
        inst.Light:SetRadius(10)
        inst.Light:SetFalloff(0.75)
        inst.Light:SetIntensity(.6)
        inst.Light:SetColour(235/255,12/255,12/255)
    end
    if tempCaveVar == true then
        inst.Light:Enable(true)
    end
    
    
	

end

-- hunger speech
local function onhungerchange(inst, data)

	if inst.strength == "mighty" then
		if inst.components.hunger.current < baseStomache * 0.867 then
			
			inst.strength = "normal"
			inst.components.talker:Say("The hunger has returned...")

		end
	elseif inst.strength == "wimpy" then
		if inst.components.hunger.current > baseStomache * 0.4 then

			inst.strength = "normal"
			inst.components.talker:Say("I need more!")

		end
	else
		if inst.components.hunger.current > baseStomache * 0.967 then
			inst.strength = "mighty"
			inst.components.talker:Say("I feel alive!")


		elseif inst.components.hunger.current < baseStomache * 0.367 then
			inst.strength = "wimpy"
			inst.components.talker:Say("Bloody hell... feels like I'm slowly fading away.")

		end
	end
	
	
	updatestats(inst)
end


local function onbecameghost(inst)
    if inst._wasnomorph ~= nil then
        inst.strength = "normal"
        inst._wasnomorph = nil
        inst.talksoundoverride = nil
        inst.hurtsoundoverride = nil
        inst:RemoveEventCallback("hungerdelta", onhungerchange)
        inst:RemoveEventCallback("newstate", onnewstate)
    end
end

local function onbecamehuman(inst)
    if inst._wasnomorph == nil then
        inst.strength = "normal"
        inst._wasnomorph = inst.sg:HasStateTag("nomorph")
        inst.talksoundoverride = nil
        inst.hurtsoundoverride = nil
        inst:ListenForEvent("hungerdelta", onhungerchange)
        inst:ListenForEvent("newstate", onnewstate)
        onhungerchange(inst, nil, true)
    end
end

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

local start_inv =
{
	-- Put vampire attack 'item' here
    "trap",
    "trap",
    "carrot",
    "carrot",
    "smallmeat",
    "smallmeat",
    "smallmeat",
    "smallmeat",
    "smallmeat",
}

local fn = function(inst)
      -- choose which sounds this character will play
    inst.soundsname = "willow"
  
    -- a minimap icon must be specified
    inst.MiniMapEntity:SetIcon( "seras.tex" )
end

local function master_postinit(inst)

  -- Ghost TEMP
  

	-- default hunger level
	inst.strength = "normal"
	inst.components.hunger.current = 125
	inst.components.hunger:SetMax(150)
	
	-- Emit light at night / Night vision
	-- WARNING doesn't work at day in caves!
	local light = inst.entity:AddLight()
	inst.Light:Enable(false)
	inst.Light:SetRadius(10)
	inst.Light:SetFalloff(0.75)
	inst.Light:SetIntensity(.6)
	inst.Light:SetColour(235/255,12/255,12/255)
	
	-- Stats varies day/night
	inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())
	inst:ListenForEvent( "daytime", function() updatestats(inst) end , GetWorld())
	inst:ListenForEvent( "nighttime", function() updatestats(inst) end , GetWorld())
	updatestats(inst)
	
	-- Sanity Changes
	inst.components.sanity.night_drain_mult = 0.5
	inst.components.sanity.neg_aura_mult = 1.1
	inst.components.sanity:SetMax(TUNING.WILLOW_SANITY)
	
	--Update hunger status
	inst:ListenForEvent("hungerdelta", onhungerchange)
	
	--temp test
--	inst:ListenForEvent("hungerdelta", onExperienceGain)
	
	--Carnivore, can only eat meat. Can Eat Monster Meat.
	inst.components.eater:SetCarnivore()
	inst.components.eater.strongstomach = true
	
	--Tag
	inst:AddTag("hellsingVamp")
    return inst
	
end

---- add blood sword
--function serasPostInit(seras)
--    local bloodswordRecipe = GLOBAL.Recipe("bloodsword", {Ingredient("nightmarefuel", 1),Ingredient("pigskin", 1)}, RECIPETABS.WAR, {SCIENCE =0} )
--    bloodswordRecipe.atlas = "images/inventoryimages/bloodsword.xml"
--end
--
--AddSimPostInit(function(inst)
--    if owner:HasTag("hellsingVamp") then
--        serasPostInit(inst)
--    end
--end)

return MakePlayerCharacter("seras", prefabs, assets, fn, master_postinit, start_inv)
