local RespawnMechanical = Class(function(self,inst)

	assert(TheWorld.ismastersim, "RespawnMechanical should not exist on client")

	self.inst = inst
	self.finddist = 40
	self.spawndist = 8
	self.successrate = 15 --in 1000 chance
	self.successhard = 3 --in 1000 chance
    self:WatchWorldState("cycles", self.CheckSpawn)

    self.MECHSPAWN_GROUPS = 
    {
    	{"bishop"},
    	{"bishop"},
    	{"knight"},
    	{"knight"},
    	{"rook"}
	}

	self.MECHSPAWN_GROUPS_HARD =
	{
		{"bishop", "bishop"},
		{"bishop", "bishop"},
		{"bishop", "bishop", "bishop"},
		{"bishop", "bishop", "bishop", "bishop"},
		{"knight", "knight"},
		{"knight", "knight"},
		{"knight", "knight"},
		{"knight", "knight"},
		{"knight", "knight", "knight"},
		{"knight", "knight", "knight", "knight"},
		{"rook", "rook"},
		{"bishop", "knight", "knight"},
		{"bishop", "bishop", "knight"},
		{"bishop", "knight", "rook"},
		{"bishop", "bishop", "rook"},
		{"bishop", "bishop", "knight", "knight"},
		{"bishop", "bishop", "knight", "knight", "rook"},
		{"bishop", "bishop", "knight", "knight", "rook", "rook"},
	}

	--print("RespawnMechanical created!!")
end)

function RespawnMechanical:CheckSpawn()
	local dice = math.random(1,1000)

	--debug
	--dice = 5

	--we do this check again later but we do it once here so we can avoid doing find entities if possible
	if dice > self.successrate then
		--print("RespawnMechanical:CheckSpawn - not spawning mobs (first success check). Rolled ", dice)
		return
	end

	local pos = self.inst:GetPosition()
	self.pos = pos;

	local spawngroup = self.MECHSPAWN_GROUPS

	local bishops = TheSim:FindEntities(pos.x, pos.y, pos.z, self.finddist, {"bishop"})
	local knights = TheSim:FindEntities(pos.x, pos.y, pos.z, self.finddist, {"knight"})
	local rooks = TheSim:FindEntities(pos.x, pos.y, pos.z, self.finddist, {"rook"})

	local dice2 = dice + dice * (#bishops + #knights + #rooks)

	if dice2 > self.successrate then
		--print("RespawnMechanical:CheckSpawn - not spawning mobs (second success check). Rolled ", dice, ", modified to ", dice2)
		return
	end

	if dice2 <= self.successhard then
		--print("RespawnMechanical:CheckSpawn - Rolled ", dice, ", modified to ", dice2, ", qualified for spawning hard group.")
		spawngroup = self.MECHSPAWN_GROUPS_HARD
	end

	--print("Spawning mobs at RespawnMechanical Position ",self.pos)

	local chosengroup = spawngroup[math.random(1, #spawngroup)]

	for i, obj in ipairs(chosengroup) do
		self:SpawnMob(chosengroup[i])
	end
end

function RespawnMechanical:GetSpawnPoint()

	if not self.pos then
		self.pos = self.inst:GetPosition()
	end

	--based on meteorspawner
    local theta = math.random() * 2 * PI
    local radius = 2 + math.random() * self.spawndist
    
    local resultoffset = FindValidPositionByFan(theta, radius, 32, 
    	function(offset)
    		local spawnpt = self.pos + offset
	        return TheWorld.Map:IsPassableAtPoint(spawnpt:Get())
    	end) 

    if resultoffset ~= nil then
        return self.pos + resultoffset
    end
end

function RespawnMechanical:SpawnMob( obj )
	local location = self:GetSpawnPoint()


	if location then
		local pfab = SpawnPrefab(obj)		

    	pfab.Transform:SetPosition(location.x, location.y, location.z)
    	--print("Spawned ", obj, " at ", location)
	else
		--print("Failed to spawn mob, could not find suitable location")
	end

    
end

function RespawnMechanical:OnSave()

end

function RespawnMechanical:OnLoad()

end

return RespawnMechanical