local MakePlayerCharacter = require "prefabs/player_common"
 
 
local assets = {
 
        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/willow.fsb" ),
 
        Asset( "ANIM", "anim/lola.zip" ),
        Asset( "ANIM", "anim/ghost_lola_build.zip" ),
}
local prefabs = { "willowfire",
    "lighter",}
local start_inv = {"lighter",
-- Custom starting items
}
 
-- This initializes for both clients and the host
local common_postinit = function(inst) 
-- choose which sounds this character will play
inst.soundsname = "wendy"
 
-- Minimap icon
inst.MiniMapEntity:SetIcon( "lola.tex" )
end
 
local function sanityfn(inst)
local x,y,z = inst.Transform:GetWorldPosition()
local delta = 0
local max_rad = 10
local ents = TheSim:FindEntities(x,y,z, max_rad, {"fire"})
    for k,v in pairs(ents) do 
    if v.components.burnable and v.components.burnable.burning then
    local sz = TUNING.SANITYAURA_TINY
    local rad = v.components.burnable:GetLargestLightRadius() or 1
    sz = sz * ( math.min(max_rad, rad) / max_rad )
local distsq = inst:GetDistanceSqToInst(v)
delta = delta + sz/math.max(1, distsq)
    end
    end
 
    return delta
end
 
-- This initializes for the host only
local master_postinit = function(inst)
-- Stats
inst.components.health:SetMaxHealth(150)
inst.components.hunger:SetMax(150)
inst.components.sanity:SetMax(200)
inst:AddComponent("firebug")
inst.components.firebug.prefab = "willowfire"
inst.components.health.fire_damage_scale = 0
 
inst.components.sanity.custom_rate_fn = sanityfn
end
 
return MakePlayerCharacter("lola", prefabs, assets, common_postinit, master_postinit, start_inv)