local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
		
        Asset( "ANIM", "anim/clementine.zip" ),
		Asset( "ANIM", "anim/clem_hat.zip" ),
        Asset( "ANIM", "anim/ghost_clementine_build.zip" ),		
}

local prefabs = 
{
    "clem_hat",
	"walkie_talkie",
}

local start_inv = 
{
    "clem_hat",
	"walkie_talkie",
}

local function onbecamehuman(inst)

	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2)
	
	inst.components.combat.damagemultiplier = 0.85	
	
	inst.components.sanity.night_drain_mult = 1.1
	inst.components.sanity.neg_aura_mult = 2
end

local common_postinit = function(inst) 
	inst.soundsname = "winnie"
	inst.MiniMapEntity:SetIcon( "clementine.tex" )
end

local master_postinit = function(inst)

    inst.components.health:SetMaxHealth(125)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(150)
	
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2)

	inst.components.combat.damagemultiplier = 0.85

	inst.components.sanity.night_drain_mult = 1.1
	inst.components.sanity.neg_aura_mult = 2
	
	onbecamehuman(inst)
	
end

STRINGS.CHARACTER_TITLES.clementine = "Clementine"
STRINGS.CHARACTER_NAMES.clementine = "Clementine."
STRINGS.CHARACTER_DESCRIPTIONS.clementine = "*She's fast, but not as strong as others.\n*Has a cap and broken walkie-talkie."
STRINGS.CHARACTER_QUOTES.clementine = "\"Can I see my parents?\""

STRINGS.CHARACTERS.CLEMENTINE = require "speech_clementine"

return MakePlayerCharacter("clementine", prefabs, assets, common_postinit, master_postinit, start_inv)
