require("map/tasks")
local blockersets = require("map/blockersets")

AddTask("Hubville_Spiders", {
		locks={LOCKS.ONLYTIER1}, -- note: adventure level, tier1 lock and abundant keys is to control world shape
		keys_given={KEYS.SPIDERS,KEYS.TIER3,KEYS.AXE},
		entrance_room=blockersets.spiders_hard,
		room_choices={
			["SpiderCity"] = 4,
			["SpiderVillage"] = 3,
			["SpiderMarsh"] = 2+math.random(2), 
		},
		room_bg=GROUND.MARSH,
		background_room="BGMarsh",
		colour={r=.05,g=.5,b=.05,a=1}
	}) 
AddTask("Hubville_Tentacles", {
		locks={LOCKS.ONLYTIER1}, -- note: adventure level, tier1 lock and abundant keys is to control world shape
		keys_given={KEYS.TENTACLES,KEYS.TIER3,KEYS.AXE},
		entrance_room="TentaclelandA",
		room_choices={
			["MermTown"] = 1,
			["Marsh"] = 1+math.random(3), 
			["SlightlyMermySwamp"] = 1+math.random(3), 
		},
		room_bg=GROUND.MARSH,
		background_room="BGMarsh",
		colour={r=.05,g=.05,b=.5,a=1}
	}) 
AddTask("Hubville_Tallbirds", {
		locks={LOCKS.ONLYTIER1}, -- note: adventure level, tier1 lock and abundant keys is to control world shape
		keys_given={KEYS.TALLBIRDS,KEYS.MEAT,KEYS.WOOL,KEYS.POOP,KEYS.TIER3,KEYS.TIER4,KEYS.GOLD,KEYS.AXE},
		entrance_room=blockersets.tallbirds_hard,
		room_choices={
			["WalrusHut_Rocky"] = 1,
			["WalrusHut_Plains"] = 1,
			["BeefalowPlain"] = 1+math.random(3), 
			["TallbirdNests"] = 1+math.random(3), 
		},
		room_bg=GROUND.ROCKY,
		background_room="BGRocky",
		colour={r=.5,g=.3,b=.05,a=1}
	}) 
AddTask("Hubville_Chess", {
		locks={LOCKS.ONLYTIER1}, -- note: adventure level, tier1 lock and abundant keys is to control world shape
		keys_given={KEYS.CHESSMEN,KEYS.GEARS,KEYS.WOOL,KEYS.POOP,KEYS.TIER3,KEYS.TIER4,KEYS.GOLD},
		entrance_room=blockersets.chess_hard,
		room_choices={
			["ChessForest"] = 1+math.random(1),
			["ChessBarrens"] = 1+math.random(1),
			["ChessMarsh"] = 1+math.random(2),
			["Thickchess"] = 1+math.random(3),
		},
		room_bg=GROUND.ROCKY,
		background_room="BGChessRocky",
		colour={r=.8,g=.08,b=.05,a=1}
	})
AddTask("Hubville_Pigs", {
		locks={LOCKS.ONLYTIER1}, -- note: adventure level, tier1 lock and abundant keys is to control world shape
		keys_given={KEYS.WOOL,KEYS.POOP,KEYS.TIER3,KEYS.TIER4,KEYS.GOLD,KEYS.MEAT},
		entrance_room=blockersets.pigs_hard,
		room_choices={
			["Guarded_PigKingdom"] = 1,
			["Guarded_Pondopolis"] = 1,
			["BeeClearing"] = 1,
		},
		room_bg=GROUND.GRASS,
		background_room="BGGrass",
		colour={r=.8,g=.08,b=.05,a=1}
	}) 
	
------------------
--optional tasks
------------------
	
AddTask("The hunters_deerclops", {
		locks={LOCKS.ADVANCED_COMBAT,LOCKS.MONSTERS_DEFEATED,LOCKS.TIER4},
		keys_given={KEYS.WALRUS,KEYS.TIER5},
		entrance_room={"Deerclopsfield"},
		room_choices={
			["WalrusHut_Plains"] = 1,
			["WalrusHut_Grassy"] = 1,
			["WalrusHut_Rocky"] = 1,
			["Clearing"] = 2,
			["BGGrass"] = 2,
			["BGRocky"] = 2,
		}, 
		room_bg=GROUND.SAVANNA,
		background_room="BGSavanna",
		colour={r=0,g=1,b=0,a=1}
	}) 
AddTask("Guarded Wasps and Frogs and bugs", {
		locks={LOCKS.BASIC_COMBAT,LOCKS.TIER3},
		keys_given={KEYS.MEAT,KEYS.GRASS,KEYS.HONEY,KEYS.TIER2},
		entrance_room=blockersets.all_bees,
		room_choices={
			["Guarded_Pondopolis"] = 1,
			["BeeClearing"] = 1,
			["EvilFlowerPatch"] = 1 + math.random(3), 
			["Clearing"] = 2,
		}, 
		room_bg=GROUND.GRASS,
		background_room="BGGrass",
		colour={r=0,g=1,b=0,a=1}
	}) 
AddTask("Hard Tentacle-Blocked The Deep Forest", {
		locks={LOCKS.TREES,LOCKS.TIER3},
		keys_given={KEYS.TENTACLES,KEYS.PIGS,KEYS.WOOD,KEYS.MEAT,KEYS.TIER3},
		entrance_room=blockersets.tentacles_hard,
		room_choices={
			--["Wormhole"] = 1,
			["PigVillage"] = 1,
			["BGForest"] = 1 + math.random(3), 
			["Marsh"] = math.random(3), 
			["DeepForest"] = 1+math.random(3), 
			["Clearing"] = 1
		}, 
		room_bg=GROUND.FOREST,
		background_room="BGDeepForest",
		colour={r=1,g=0,b=0,a=1}
	}) 