GLOBAL.setmetatable(GLOBAL.getfenv(1), {__index = function(self, index)
	return GLOBAL.rawget(GLOBAL, index)
end})-- ty penguin

local unpack = unpack or table.unpack or GLOBAL.unpack

local function results(data, ...)
	return type(data) == "function" and {data(...)}  
		or type(data) == "table" and data 
		or {data} 
end 

local function sandwich(func, ante, post)	
	return function(...)
		local results_ante = results(ante, ...)
		if #results_ante > 0 then return unpack(results_ante) end 		
		
		local results_original = results(func, ...)
		
		local results_post = results(post, ...)
		if #results_post > 0 then return unpack(results_post) end 
		
		return unpack(results_original)
	end 
end 

local function overwrite(tabula, name, ante, post)
	if type(tabula) ~= "table" then return end 
	local old = tabula[name]
	tabula[name] = sandwich(old, ante, post)
end 

--			*			*			*			*			*			*			--

TUNING.WHEELER_DODGE_EMPTY_INVENTORY_MULTIPLIER = 2
TUNING.WHEELER_DOGE_DISTANCE = 20 -- not originally a tuning variable 

AddStategraphPostInit("wilson", function(self)
	overwrite(self.states.dodge, "onenter", nil, function(inst)
		local inventory = inst.components.inventory 
		local max = inventory:GetNumSlots()
		local free = inventory:GetFreeSlotCount()
		
		local multi = 1 + free / max * (TUNING.WHEELER_DODGE_EMPTY_INVENTORY_MULTIPLIER - 1)
		local distance = multi * TUNING.WHEELER_DOGE_DISTANCE
		inst.Physics:SetMotorVelOverride(distance, 0, 0)
	end)
end)