local _G = GLOBAL
local TheNet = _G.TheNet

-- 語言
modimport("myhome_"..GetModConfigData("language")..".lua")
-- 允許ADMIN權限
_G.MyHome_ALLOW_ADMIN = GetModConfigData("admin")
-- 個人家的上限
-- _G.MAX_HOME = GetModConfigData("max_home")
-- WALL最低值
_G.MyHome_MIN_WALL = GetModConfigData("min_wall")
-- WALL最高值
_G.MyHome_MAX_WALL = GetModConfigData("max_wall")
-- 啟用禁區
_G.MyHome_RESTRICTED_AREA = GetModConfigData("restricted_area")

_G.MH = nil

local MH_Points = {     -- 管理的牆類建築
    "fence",
    "fence_gate",
    -- 其它 wall_xxx 牆類建築由 AllRecipes 提取
}
local MH_Network = {    -- 監聽世界存檔
    "forest_network",
    "cave_network",
}
MSG_CHOOSE = {      -- 說話指令
    add = 1,
    del = 2,
}
if _G.TheNet:GetIsServer() and _G.MyHome_RESTRICTED_AREA then
    local MH_Prefabs1 = {     -- MyHome禁止包含
        "multiplayer_portal", -- 惡魔之門
        "spawnpoint_master", -- 惡魔之門
        "migration_portal",  -- 旅行機器
        "cave_entrance",  -- 地洞路口
        "cave_entrance_open",  -- 地洞路口
        "cave_exit",  -- 地洞出口
        "wormhole",  -- 蟲洞
        "resurrectionstone", -- 復活石
        "critterlab", -- 寵物實驗室
        "statueglommer", -- 咕嚕咪雕像
        "ancient_altar", -- 遠古祭壇
        "ancient_altar_broken", -- 壞的遠古祭壇
        "pond", -- 池塘
        "pond_cave", -- 洞穴池塘
        "tentacle_pillar", -- 大觸手
        "tentacle_pillar_hole", -- 黏呼呼大坑
        "nightmarelight", -- 夢魘燈座
        "spiderhole", -- 洞穴蜘蛛洞
        "batcave", -- 蝙蝠洞
        "slurtlehole", -- 蝸牛窩
        "monkeybarrel", -- 猴子桶
        "walrus_camp", -- 海象屋
        "rabbithole", -- 兔子洞
        "tallbirdnest", -- 高腳鳥窩
        "houndmound", -- 獵犬丘
        "catcoonden", -- 浣熊洞
        "cactus", -- 仙人掌
        "reeds", -- 蘆葦
        "beefalo", -- 牛
        "babybeefalo", -- 小牛
        "lightninggoat", -- 羊
        "deer", -- 鹿
        "rocky", -- 石龍蝦
        "warg", -- 座狼
        "spat", -- 鋼羊
        "bearger", -- 秋熊
        "deerclops", -- 冬王
        "mooseegg", -- 鴨蛋
        "mossling", -- 鴨
        "birchnutdrake", -- 大鴨
        "moose", -- 春王
    }
    local MH_Prefabs2 = {     -- MyHome禁止周圍
        "lava_pond", -- 岩漿
        "beequeenhive", -- 女王蜂巢
        "toadstool_cap", -- 蟾蜍洞
        "pigtorch", -- 豬火炬
    }

    ----- 替所有禁區加上Tag -----
    for _, v in pairs(MH_Prefabs1) do
        AddPrefabPostInit(v, function(inst)
            if _G.TheWorld.ismastersim then
                inst:AddTag("mhr1")
            end
        end)
    end
    for _, v in pairs(MH_Prefabs2) do
        AddPrefabPostInit(v, function(inst)
            if _G.TheWorld.ismastersim then
                inst:AddTag("mhr2")
            end
        end)
    end
end

function intable(table, str)
    for _, v in pairs(table) do
        if v == str then
            return true
        end
    end
    return false
end

----- 允許右鍵 -----
-- 動作訊息
AddAction("MYHOME_UNLOCK", _G.MyHome_LANG["M8"], function(act)
    return act.target.components.wall:ClickRight(act.doer, 13)
end)
AddAction("MYHOME_SELFLOCK", _G.MyHome_LANG["M9"], function(act)
    return act.target.components.wall:ClickRight(act.doer, 12)
end)
AddAction("MYHOME_FRIENDSLOCK", _G.MyHome_LANG["M10"], function(act)
    return act.target.components.wall:ClickRight(act.doer, 11)
end)
AddAction("MYHOME_NOSELFLOCK", _G.MyHome_LANG["M11"], function(act)
    return act.target.components.wall:ClickRight(act.doer, 10)
end)
AddAction("MYHOME_SELF", _G.MyHome_LANG["M12"], function(act)
    return act.target.components.wall:ClickRight(act.doer, 2)
end)
AddAction("MYHOME_FRIENDS", _G.MyHome_LANG["M13"], function(act)
    return act.target.components.wall:ClickRight(act.doer, 1)
end)
AddAction("MYHOME_NOSELF", _G.MyHome_LANG["M14"], function(act)
    return act.target.components.wall:ClickRight(act.doer, 0)
end)

-- 查看動作邏輯判斷
AddComponentAction("SCENE", "wall", function(inst, doer, actions, right)
    inst.components.wall:AddAction(doer, actions, right)
end)

-- 對人物綁動作
AddStategraphActionHandler("wilson", _G.ActionHandler(_G.ACTIONS.MYHOME_UNLOCK, "give"))
AddStategraphActionHandler("wilson_client", _G.ActionHandler(_G.ACTIONS.MYHOME_UNLOCK, "give"))
AddStategraphActionHandler("wilson", _G.ActionHandler(_G.ACTIONS.MYHOME_SELFLOCK, "give"))
AddStategraphActionHandler("wilson_client", _G.ActionHandler(_G.ACTIONS.MYHOME_SELFLOCK, "give"))
AddStategraphActionHandler("wilson", _G.ActionHandler(_G.ACTIONS.MYHOME_FRIENDSLOCK, "give"))
AddStategraphActionHandler("wilson_client", _G.ActionHandler(_G.ACTIONS.MYHOME_FRIENDSLOCK, "give"))
AddStategraphActionHandler("wilson", _G.ActionHandler(_G.ACTIONS.MYHOME_NOSELFLOCK, "give"))
AddStategraphActionHandler("wilson_client", _G.ActionHandler(_G.ACTIONS.MYHOME_NOSELFLOCK, "give"))
AddStategraphActionHandler("wilson", _G.ActionHandler(_G.ACTIONS.MYHOME_SELF, "give"))
AddStategraphActionHandler("wilson_client", _G.ActionHandler(_G.ACTIONS.MYHOME_SELF, "give"))
AddStategraphActionHandler("wilson", _G.ActionHandler(_G.ACTIONS.MYHOME_FRIENDS, "give"))
AddStategraphActionHandler("wilson_client", _G.ActionHandler(_G.ACTIONS.MYHOME_FRIENDS, "give"))
AddStategraphActionHandler("wilson", _G.ActionHandler(_G.ACTIONS.MYHOME_NOSELF, "give"))
AddStategraphActionHandler("wilson_client", _G.ActionHandler(_G.ACTIONS.MYHOME_NOSELF, "give"))

----- 修改圍牆 -----
local wallInit = function(inst)
    if inst.components.wall == nil then
        inst:AddComponent("talker")
        inst:AddComponent("wall")
    end
end

----- 提取牆類建築名稱 -----
for _, v in pairs(_G.AllRecipes) do
    local name = string.match(v.name, "^wall_(.+)_item$")
    if name ~= nil then
        table.insert(MH_Points, "wall_"..name)
    end
end

----- 替所有牆加上組建和動作 -----
for _, v in pairs(MH_Points) do
    AddPrefabPostInit(v, wallInit)
end

-- 安置物品，為每個安置的新物品都添加Tag
local old_DEPLOY = _G.ACTIONS.DEPLOY.fn
_G.ACTIONS.DEPLOY.fn = function(act)
    if _G.TheWorld.ismastersim and act and intable(MH_Points, string.sub(act.invobject.prefab, 0, -6)) then --建造牆
        act.doer:DoTaskInTime(0, function ()
            local x = act.pos.x
            local y = act.pos.y
            local z = act.pos.z
            x = math.floor(x) + .5
            z = math.floor(z) + .5

            local ents = _G.TheSim:FindEntities(x, y, z, 0.5)

            for _, target in pairs(ents) do
                if target.components.wall == nil then   -- 剛蓋好指標沒移開會無法初始化
                    wallInit(target)
                end
                target.components.wall:SetOid(act.doer.userid)
            end
        end)
    end
    return old_DEPLOY(act)
end

----- 防拆牆系列 -----
local oldfn = {}

local monitor1 = function(type)
    return function(act)
        if _G.TheWorld.ismastersim and act ~= nil and act.target ~= nil and act.target:HasTag("wall") == true and act.target.components.wall and act.target.components.wall.inst:HasTag("lockmyhome") == true then
            return false
        end
        return oldfn[type](act)
    end
end

oldfn["HAMMER"] = _G.ACTIONS.HAMMER.fn  -- 槌子
_G.ACTIONS.HAMMER.fn = monitor1("HAMMER")

oldfn["HAUNT"] = _G.ACTIONS.HAUNT.fn    -- 作祟
_G.ACTIONS.HAUNT.fn = monitor1("HAUNT")

oldfn["CASTSPELL"] = _G.ACTIONS.CASTSPELL.fn    -- 魔法攻擊
_G.ACTIONS.CASTSPELL.fn = monitor1("CASTSPELL")

oldfn["ACTIVATE"] = _G.ACTIONS.ACTIVATE.fn    -- 開關門
_G.ACTIONS.ACTIVATE.fn = function(act)
    if _G.TheWorld.ismastersim then
        if act.target == nil or act.target:HasTag("wall") ~= true or act.target.components == nil or act.target.components.wall == nil then
            return oldfn["ACTIVATE"](act)
        end
        local inst = act.target.components.wall.inst
        local mid = _G.MH.players[act.doer.userid]
        if inst:HasTag("lockmyhome") == true and mid ~= inst.oid and _G.MH:GetFriendsByMid(inst.oid, mid) ~= true and (_G.MyHome_ALLOW_ADMIN ~= true or not act.doer.Network:IsServerAdmin()) then
            return false
        end
    end
    return oldfn["ACTIVATE"](act)
end

----- 向所有世界存檔添加myhome的全局變量 -----
for _, v in pairs(MH_Network) do
    AddPrefabPostInit(v, function(inst)
            if inst.components.myhome == nil then
                inst:AddComponent("myhome")
            end
            if _G.MH ~= nil then
                inst.components.myhome:SyncParams(_G.MH)
            else
                _G.MH = inst.components.myhome
            end
    end)
end

----- 玩家進入 -----
AddComponentPostInit("playerspawner", function(OnPlayerSpawn, inst)
    inst:ListenForEvent("ms_playerjoined", function(inst, player)
        _G.MH:SetPlayerName(player)
    end)
end)

----- 聽對話訊息 -----
local Old_Networking_Say = _G.Networking_Say
_G.Networking_Say = function(guid, userid, name, prefab, message, colour, whisper, isemote, ...)
    Old_Networking_Say(guid, userid, name, prefab, message, colour, whisper, isemote, ...)
    if _G.TheWorld.ismastersim then
        local lower_msg = string.lower(message)
        local hashtag = string.find(lower_msg, "#")

        if hashtag then
            local sid = nil
            local mode = nil
            for k, v in pairs(MSG_CHOOSE) do
                sid = string.match(lower_msg, k.."%s*(%d+)", hashtag + 1)
                if sid then
                    mode = k
                    break
                end
            end
            if mode == nil then return end

            local recipient = _G.MH:GetPlayerBySid(sid)
            local talker = _G.MH:GetPlayerById(userid)
            if recipient ~= nil and talker ~= nil then
                if recipient.userid and recipient.GetDisplayName then
                    if talker and recipient.userid == talker.userid then
                        if talker and talker.components.talker then
                            _G.MH:Talker(talker, _G.MyHome_LANG["M1"])
                        end
                    else
                        if MSG_CHOOSE[mode] == 1 then   -- add
                            if _G.MH:GetFriends(talker.userid, recipient.userid) == nil then
                                _G.MH:SetFriends(talker.userid, recipient.userid, 1)
                                _G.MH:Talker(talker, _G.MyHome_LANG["M2"](recipient:GetDisplayName()))
                                _G.MH:Talker(recipient, _G.MyHome_LANG["M3"](talker:GetDisplayName()))
                            else
                                _G.MH:Talker(talker, _G.MyHome_LANG["M4"](recipient:GetDisplayName()))
                            end
                        elseif MSG_CHOOSE[mode] == 2 then   -- del
                            if _G.MH:GetFriends(talker.userid, recipient.userid) == nil then
                                _G.MH:Talker(talker, _G.MyHome_LANG["M5"](recipient:GetDisplayName()))
                            else
                                _G.MH:SetFriends(talker.userid, recipient.userid, false)
                                _G.MH:Talker(talker, _G.MyHome_LANG["M6"](recipient:GetDisplayName()))
                                _G.MH:Talker(recipient, _G.MyHome_LANG["M7"](talker:GetDisplayName()))
                            end
                        end
                    end
                end
            else
                if talker and talker.components.talker then
                    _G.MH:Talker(talker, _G.MyHome_LANG["M16"])
                end
            end
        end
    end
end
