require 'json'

local mh = Class(function(self, inst)

--Public
self.inst = inst

-- params
self.friends = {}   -- [MID] = {[friendsMID] = 1, ...}
self.players = {}   -- [userid] = MID
self.names = {}     -- [MID] = name
self.config = {}    -- [sum] = int

self.handle_config = {
    -- lock = false,   -- 申請鎖
    -- animlock = false,   -- 動畫鎖
    player = nil,   -- 申請人
    mid = nil,      -- 申請人mid
    total = nil,    -- 總牆數
    count = {},     -- 自己、朋友、別人
    timeout = nil,  -- 超時function
    -- 紀錄x,z最小/大值
    x1 = nil,
    z1 = nil,
    x2 = nil,
    z2 = nil,
}

-- 須存檔的參數
local SAVEPARAMS = {
    "friends",
    "players",
    "names",
    "config",
}

inst.net_players = net_string(inst.GUID, "players", "players_dirty")
inst.net_names = net_string(inst.GUID, "names", "names_dirty")
if TheNet:GetIsClient() then
    inst:ListenForEvent("players_dirty", function(inst)
        self.players = json.decode(inst.net_players:value())
    end)
    inst:ListenForEvent("names_dirty", function(inst)
        self.names = json.decode(inst.net_names:value())
    end)
end

-- 重置轉換配置
local cancel = function()
    for _, v in ipairs(TheSim:FindEntities(0, 0, 0, 1e4, {"focusmyhome"})) do
        v:RemoveTag("focusmyhome")
    end
    for _, v in ipairs(TheSim:FindEntities(0, 0, 0, 1e4, {"guidemyhome"})) do
        v:RemoveTag("guidemyhome")
    end
    for _, v in ipairs(TheSim:FindEntities(0, 0, 0, 1e4, {"firstmyhome"})) do
        v:RemoveTag("firstmyhome")
    end

    inst:RemoveTag("animlock")
    inst:DoTaskInTime(5, function ()
        inst:RemoveTag(self.handle_config.player.userid)
        inst:RemoveTag("lock")
    end)
end

-- 逾時處理
local timeout = function()
    self:Talker(self.handle_config.player, MyHome_LANG["A1"])
    cancel()
end

-- MyHome 轉換成功
local success = function()
    -- 第幾個家
    if self.config.sum == nil then
        self.config.sum = 0
    end
    local newhid = self.config.sum + 1
    self.config.sum = newhid

    -- 轉換處理
    inst:StartThread(function()
        for n, v in ipairs(TheSim:FindEntities(0, 0, 0, 1e4, {"focusmyhome"})) do
            v.components.wall:AddLock(newhid)
            local inst = v.components.wall.inst
            if inst.oid ~= self.handle_config.mid then
                inst.components.wall:SetOid(self.handle_config.mid)
            end
            if v:HasTag("firstmyhome") then
                inst.components.wall:SetHid(newhid)
            end

            if n % 50 == 0 then
                Sleep(.5)
            end
        end

        self:Talker(self.handle_config.player, MyHome_LANG["A2"], 3)
        TheNet:Announce(MyHome_LANG["A3"](self.handle_config.player:GetDisplayName(), self.handle_config.total))
        cancel()
    end)
end

-- MyHome處理器
function self:HandleMyHome(target, doer)
    local c = self.handle_config
    -- 不可用: 未執行、指向沒有指引的牆、操作者非申請人
    if inst:HasTag("animlock") ~= true or target:HasTag("guidemyhome") ~= true or inst:HasTag(doer.userid) ~= true then return end

    -- 取消逾時、紀錄當前牆
    if c.timeout ~= nil then
        c.timeout:Cancel()
        c.timeout = nil
    end

    -- 消除指引、選中當前牆
    local x, y, z = target.Transform:GetWorldPosition()
    if x == nil or z == nil then
        cancel()
    end
    local total = c.total + 1
    c.total = total
    for _, v in ipairs(TheSim:FindEntities(x, y, z, 3.5, {"guidemyhome"})) do
        v:RemoveTag("guidemyhome")
    end
    target:AddTag("focusmyhome")

    -- 抓出x, z最大最小值
    if x > c.x2 then
        c.x2 = x
    elseif x < c.x1 then
        c.x1 = x
    end
    if z > c.z2 then
        c.z2 = z
    elseif z < c.z1 then
        c.z1 = z
    end

    -- 判斷牆的所有者並說話
    if c.mid == target.oid then
        c.count[1] = c.count[1] + 1
    elseif self:GetFriendsByMid(target.oid, c.mid) == true then
        c.count[2] = c.count[2] + 1
    else
        c.count[3] = c.count[3] + 1
    end
    self:Talker(doer, MyHome_LANG["A4"](total, c.count[1], c.count[2], c.count[3]), 10)

    -- 選中後隱藏
    inst:DoTaskInTime(0.6, function ()
        target.components.wall:SetNeonColour(2, 1)
    end)

    -- 判斷是否與頭相接
    if total >= MyHome_MIN_WALL or MyHome_ALLOW_ADMIN == true and doer.Network:IsServerAdmin() and total > 7 then
        if #TheSim:FindEntities(x, y, z, 1.5, {"firstmyhome"}) > 0 then
            -- 禁涵蓋判斷
            local allow = true
            local cx = (c.x1 + c.x2) / 2
            local cz = (c.z1 + c.z2) / 2
            local cr = math.max(c.x2 - cx, c.z2 - cz)

            if MyHome_ALLOW_ADMIN == true and doer.Network:IsServerAdmin() then
                self:Talker(doer, MyHome_LANG["A5"], 10)
                return success()
            else
                if MyHome_RESTRICTED_AREA then
                    for _, v in ipairs(TheSim:FindEntities(cx, 0, cz, cr, {"mhr1"})) do
                        allow = false
                        self:Talker(doer, MyHome_LANG["A6"](tostring(v.name)), 10)
                        break
                    end
                    for _, v in ipairs(TheSim:FindEntities(cx, 0, cz, cr + 30, {"mhr2"})) do
                        allow = false
                        self:Talker(doer, MyHome_LANG["A7"](tostring(v.name)), 10)
                        break
                    end
                end
                for _, v in ipairs(TheSim:FindEntities(cx, 0, cz, cr + 10, {"lockmyhome"})) do
                    allow = false
                    self:Talker(doer, MyHome_LANG["A8"], 10)
                    break
                end

                -- 所有者比例判斷
                if allow then
                    if total * .2 < c.count[3] then
                        self:Talker(doer, MyHome_LANG["A9"], 10)
                    elseif total * .6 < c.count[2] then
                        self:Talker(doer, MyHome_LANG["A10"], 10)
                    else
                        self:Talker(doer, MyHome_LANG["A5"], 10)
                        return success()
                    end
                end
            end
            return inst:DoTaskInTime(.5, cancel)
        end
    elseif total > MyHome_MAX_WALL then
        self:Talker(doer, MyHome_LANG["A11"](MyHome_MAX_WALL))
        return inst:DoTaskInTime(.5, cancel)
    end

    -- 添加指引
    local find = TheSim:FindEntities(x, y, z, 1.5, {"wall"}, {"focusmyhome", "lockmyhome"})
    if #find == 0 then
        self:Talker(doer, MyHome_LANG["A12"](MyHome_MIN_WALL))
        return inst:DoTaskInTime(3, function ()
            cancel()
        end)
    end

    for _, v in ipairs(find) do
        if TheWorld.ismastersim then
            v:AddTag("guidemyhome")
        end
        v.components.wall:SetNeonText(2)
        v.components.wall:SetNeonColour(1, 2)
    end

    -- 添加逾時
    c.timeout = inst:DoTaskInTime(10, timeout)
end

-- 申請MyHome
function self:ReceiverMyHome(target, doer)
    local mid = self.players[doer.userid]
    -- 不可以申請: 沒有申請人、申請人錯誤、沒有目標、目標不是申請人造的
    if doer == nil or doer.components == nil or target == nil or target.oid ~= mid then
        return self:Talker(doer, MyHome_LANG["A14"])
    end
    local c = self.handle_config

    if inst:HasTag("lock") then
        if c.mid ~= mid then
            self:Talker(doer, MyHome_LANG["A15"](c.player:GetDisplayName()))
        end
        return
    end

    inst:AddTag("lock")
    inst:AddTag("animlock")
    inst:AddTag(doer.userid)

    target:AddTag("guidemyhome")    -- 指引
    target:AddTag("firstmyhome")    -- 起點

    c.player, c.mid, c.total, c.count = doer, mid, 0, {0, 0, 0}

    local x, y, z = target.Transform:GetWorldPosition()
    if x == nil or z == nil then
        cancel()
    end
    c.x1, c.z1, c.x2, c.z2 = x, z, x, z

    self:Talker(doer, MyHome_LANG["A16"], 4)

    inst:DoTaskInTime(3, function ()
        self:HandleMyHome(target, doer)
    end)
end

-- 取消MyHome
function self:CancelMyHome(target, doer)
    -- 不可以申請: 目標非起始點、不是自己的
    if target == nil or target.hid == nil or (target.oid ~= self.players[doer.userid] and MyHome_ALLOW_ADMIN == true and not doer.Network:IsServerAdmin()) then
        return self:Talker(doer, MyHome_LANG["A14"])
    end

    -- 解除所有該MyHome
    for _, v in ipairs(TheSim:FindEntities(0, 0, 0, 1e4, {"myhome_"..target.hid})) do
        v.components.wall:RemoveLock()
        v.components.wall:SetHid(nil)
    end

    self:Talker(doer, MyHome_LANG["A17"])
    TheNet:Announce(MyHome_LANG["A18"](doer:GetDisplayName()))
end

-- 人物說話的安全檢查
function self:Talker(player, msg, sec)
    if player and player.components and player.components.talker then
        local talker = player.components.talker
        talker:Say(msg, sec or 3)
        return talker
    end
    return nil
end

-- 透過userid取得player
function self:GetPlayerById(userid)
    for _, v in ipairs(AllPlayers) do
        if v ~= nil and v.userid and v.userid == userid then
            return v
        end
    end
    return nil
end

-- 授權別人時判斷遊戲編號對應的玩家
function self:GetPlayerBySid(sid)
    local isdedicated = not TheNet:GetServerIsClientHosted()
    local index = 1
    sid = tonumber(sid)

    for _, v in ipairs(TheNet:GetClientTable()) do
        if not isdedicated or v.performance == nil then
            if index == sid then
                return self:GetPlayerById(v.userid)
            end
            index = index + 1
        end
    end
    return nil
end

-- 請人授權時須要知道自己的遊戲編號
function self:GetSidByPlayer(player)
    local isdedicated = not TheNet:GetServerIsClientHosted()
    local index = 1

    for _, v in ipairs(TheNet:GetClientTable()) do
        if not isdedicated or v.performance == nil then
            if v.userid == player.userid then
                break
            end
            index = index + 1
        end
    end
    return index
end

-- 將兩人的userid轉為mid，然後開關朋友關係
function self:SetFriends(talker, recipient, allow)
    local t_mid = self.players[talker]
    local r_mid = self.players[recipient]
    if self.friends[t_mid] == nil then
        self.friends[t_mid] = {}
    end

    if allow ~= false then
        self.friends[t_mid][r_mid] = 1
        if TheWorld.ismastersim then
            inst:AddTag(tostring(t_mid).."f"..tostring(r_mid))
        end
    else
        self.friends[t_mid][r_mid] = nil
        if TheWorld.ismastersim then
            inst:RemoveTag(tostring(t_mid).."f"..tostring(r_mid))
        end
    end
end

-- 將兩人的userid轉為mid
function self:GetFriends(talker, recipient)
    return self:GetFriendsByMid(self.players[talker], self.players[recipient])
end

-- 判斷兩人是否為朋友關係
function self:GetFriendsByMid(t_mid, r_mid)
    if not TheWorld.ismastersim then
        return inst:HasTag(tostring(t_mid).."f"..tostring(r_mid))
    end
    if self.friends[t_mid] ~= nil and self.friends[t_mid][r_mid] ~= nil then
        return true
    end
    return nil
end

-- 將所有玩家的名稱及userid=mid保存到兩個server變量中
function self:SetPlayerName(player)
    if player and player.userid then
        local player_mid = self.players[player.userid]
        local name = player:GetDisplayName()
        if player_mid then
            if self.names[player_mid] ~= name then
                self.names[player_mid] = name
                if TheWorld.ismastersim then
                    inst.net_names:set(json.encode(self.names))
                end
            end
        else
            table.insert(self.names, name)
            self.players[player.userid] = #self.names
            if TheWorld.ismastersim then
                inst.net_players:set(json.encode(self.players))
                inst.net_names:set(json.encode(self.names))
            end
        end
    end
end

-- 將userid轉為mid
function self:GetPlayerName(userid)
    return self:GetPlayerNameByMid(userid and self.players[userid])
end

-- 透過userid取得玩家名稱
function self:GetPlayerNameByMid(mid)
    local name = MyHome_LANG["A19"]
    if mid and self.names[mid] then
        name = self.names[mid]
    end
    return name
end

-- 同步子世界參數
function self:SyncParams(source)
    for _, v in pairs(SAVEPARAMS) do
        self[v] = source[v]
    end
end

function self:OnSave()
    local save = {}
    for _, v in pairs(SAVEPARAMS) do
        save[v] = self[v]
    end
    return save
end

function self:OnLoad(data)
    for _, v in pairs(SAVEPARAMS) do
        if data[v] then
            for n, p in pairs(data[v]) do
                self[v][n] = p
            end
        end
    end
    for t_mid, n in pairs(self.friends) do
        for r_mid, _ in pairs(n) do
            inst:AddTag(tostring(t_mid).."f"..tostring(r_mid))
        end
    end
    inst.net_players:set(json.encode(self.players))
    inst.net_names:set(json.encode(self.names))
end

end)

----- server收 -----
AddModRPCHandler("wall", "OnFocus", function(doer, x, y, z)
    local ents = TheSim:FindEntities(x, y, z, 0.5, {"wall"})
    if #ents == 1 then
        for _, target in pairs(ents) do
            target.components.wall:SendFocus(doer)
        end
    end
end)

return mh
